/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.CommandLine;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class LengthAction
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private final CommandLine parentPlugin;
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private Cursor currentCursor;
    private final Color selectedColor;
    private Point drawStartPos;
    private Point drawEndPos;
    private LatLon startCoor;
    private LatLon endCoor;
    private Point mousePos;
    private Node nearestNode;
    private boolean drawing;

    public LengthAction(MapFrame mapFrame, CommandLine parentPlugin) {
        super(null, "addsegment.png", null, mapFrame, ImageProvider.getCursor((String)"crosshair", null));
        this.parentPlugin = parentPlugin;
        this.selectedColor = Main.pref.getColor(I18n.marktr((String)"selected"), Color.red);
        this.cursorCrosshair = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.currentCursor = this.cursorCrosshair;
        this.nearestNode = null;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.drawing) {
            Main.map.mapView.repaint();
        }
    }

    public void cancelDrawing() {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setAngle(-1.0);
        this.updateStatusLine();
        this.parentPlugin.abortInput();
    }

    @Override
    public void eventDispatched(AWTEvent arg0) {
        if (!(arg0 instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)arg0;
        if (ev.getKeyCode() == 27 && ev.getID() == 401) {
            if (this.drawing) {
                ev.consume();
            }
            this.cancelDrawing();
        }
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (!this.drawing) {
            return;
        }
        g.setColor(this.selectedColor);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        GeneralPath b = new GeneralPath();
        Point pp1 = this.drawStartPos;
        Point pp2 = this.drawEndPos;
        b.moveTo(pp1.x, pp1.y);
        b.lineTo(pp2.x, pp2.y);
        g.draw(b);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawingStart(MouseEvent e) {
        this.mousePos = e.getPoint();
        this.drawStartPos = this.nearestNode != null ? Main.map.mapView.getPoint(this.nearestNode.getCoor()) : this.mousePos;
        this.drawEndPos = this.drawStartPos;
        this.endCoor = this.startCoor = Main.map.mapView.getLatLon(this.drawStartPos.x, this.drawStartPos.y);
        this.drawing = true;
        this.updateStatusLine();
    }

    private void drawingFinish() {
        this.parentPlugin.loadParameter(String.valueOf(this.startCoor.greatCircleDistance(this.endCoor)), true);
        this.drawStartPos = null;
        this.drawing = false;
        this.exitMode();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (!Main.map.mapView.isActiveLayerDrawable()) {
                return;
            }
            this.requestFocusInMapView();
            this.drawingStart(e);
        } else {
            this.drawing = false;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean dragged = true;
        if (this.drawStartPos != null) {
            boolean bl = dragged = this.drawEndPos.distance(this.drawStartPos) > 10.0;
        }
        if (this.drawing && dragged) {
            this.drawingFinish();
        }
        this.drawing = false;
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
        this.updCursor();
        this.drawEndPos = this.nearestNode != null ? Main.map.mapView.getPoint(this.nearestNode.getCoor()) : this.mousePos;
        this.endCoor = Main.map.mapView.getLatLon(this.drawEndPos.x, this.drawEndPos.y);
        if (this.drawing) {
            Main.map.statusLine.setDist(this.startCoor.greatCircleDistance(this.endCoor));
            Main.map.mapView.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        if (this.drawing) {
            Main.map.mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.drawing) {
            return I18n.tr((String)"Point on the start", (Object[])new Object[0]);
        }
        return I18n.tr((String)"Point on the end", (Object[])new Object[0]);
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    private void updCursor() {
        if (this.mousePos != null) {
            if (!Main.isDisplayingMapView()) {
                return;
            }
            this.nearestNode = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
            if (this.nearestNode != null) {
                this.setCursor(this.cursorJoinNode);
            } else {
                this.setCursor(this.cursorCrosshair);
            }
        }
    }

    private void setCursor(final Cursor c) {
        if (this.currentCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!(Main.map.mapMode instanceof LengthAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(c);
                }
            });
            this.currentCursor = c;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

