/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class ErrPtg
extends ScalarConstantPtg {
    public static final ErrPtg NULL_INTERSECTION = new ErrPtg(0);
    public static final ErrPtg DIV_ZERO = new ErrPtg(7);
    public static final ErrPtg VALUE_INVALID = new ErrPtg(15);
    public static final ErrPtg REF_INVALID = new ErrPtg(23);
    public static final ErrPtg NAME_INVALID = new ErrPtg(29);
    public static final ErrPtg NUM_ERROR = new ErrPtg(36);
    public static final ErrPtg N_A = new ErrPtg(42);
    public static final short sid = 28;
    private static final int SIZE = 2;
    private final int field_1_error_code;

    private ErrPtg(int n) {
        if (!HSSFErrorConstants.isValidCode(n)) {
            throw new IllegalArgumentException("Invalid error code (" + n + ")");
        }
        this.field_1_error_code = n;
    }

    public static ErrPtg read(LittleEndianInput littleEndianInput) {
        return ErrPtg.valueOf(littleEndianInput.readByte());
    }

    @Override
    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(28 + this.getPtgClass());
        littleEndianOutput.writeByte(this.field_1_error_code);
    }

    @Override
    public String toFormulaString() {
        return HSSFErrorConstants.getText(this.field_1_error_code);
    }

    @Override
    public int getSize() {
        return 2;
    }

    public static ErrPtg valueOf(int n) {
        switch (n) {
            case 7: {
                return DIV_ZERO;
            }
            case 42: {
                return N_A;
            }
            case 29: {
                return NAME_INVALID;
            }
            case 0: {
                return NULL_INTERSECTION;
            }
            case 36: {
                return NUM_ERROR;
            }
            case 23: {
                return REF_INVALID;
            }
            case 15: {
                return VALUE_INVALID;
            }
        }
        throw new RuntimeException("Unexpected error code (" + n + ")");
    }
}

