/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectBoundaryAction
extends JosmAction {
    private Way lastUsedStartingWay;
    private boolean lastUsedLeft;

    public SelectBoundaryAction() {
        super(I18n.tr((String)"Area boundary [testing]", (Object[])new Object[0]), "selboundary", I18n.tr((String)"Select relation or all ways that forms area boundary", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selboundary", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Area boundary [testing]"}), (int)47, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAreaBoundary"));
    }

    public static void selectByInternalPoint(EastNorth e) {
        TreeMap<Double, Object> found = new TreeMap<Double, Object>();
        for (Way w : SelectBoundaryAction.getCurrentDataSet().getWays()) {
            if (!w.isUsable() || !w.isClosed() || !NodeWayUtils.isPointInsidePolygon(e, NodeWayUtils.getWayPoints(w))) continue;
            found.put(Geometry.closedWayArea((Way)w), w);
        }
        for (Relation r : SelectBoundaryAction.getCurrentDataSet().getRelations()) {
            if (!r.isUsable() || !r.isMultipolygon() || !NodeWayUtils.isPointInsideMultipolygon(e, r)) continue;
            for (RelationMember m : r.getMembers()) {
                if (!m.isWay() || !m.getWay().isClosed()) continue;
                found.values().remove(m.getWay());
            }
            BBox bBox = r.getBBox();
            EastNorth en1 = Main.map.mapView.getProjection().latlon2eastNorth(bBox.getTopLeft());
            EastNorth en2 = Main.map.mapView.getProjection().latlon2eastNorth(bBox.getBottomRight());
            double s = Math.abs((en1.east() - en2.east()) * (en1.north() - en2.north()));
            if (s == 0.0) {
                s = 1.0E8;
            }
            found.put(s, r);
        }
        if (!found.isEmpty()) {
            SelectBoundaryAction.getCurrentDataSet().setSelected(Collections.singletonList(found.firstEntry().getValue()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent e) {
        Set selectedWays = OsmPrimitive.getFilteredSet((Collection)SelectBoundaryAction.getCurrentDataSet().getSelected(), Way.class);
        Set selectedNodes = OsmPrimitive.getFilteredSet((Collection)SelectBoundaryAction.getCurrentDataSet().getSelected(), Node.class);
        HashSet<Way> newWays = new HashSet<Way>();
        Way w = null;
        if (selectedWays.isEmpty()) {
            if (selectedNodes.size() != 1) {
                Point p = Main.map.mapView.getMousePosition();
                SelectBoundaryAction.selectByInternalPoint(Main.map.mapView.getEastNorth(p.x, p.y));
                return;
            }
            for (OsmPrimitive p : ((Node)selectedNodes.iterator().next()).getReferrers()) {
                if (!(p instanceof Way) || !p.isSelectable()) continue;
                w = (Way)p;
                break;
            }
        } else if (selectedWays.size() == 1) {
            w = (Way)selectedWays.iterator().next();
        } else if (selectedWays.contains(this.lastUsedStartingWay)) {
            w = this.lastUsedStartingWay;
            boolean bl = this.lastUsedLeft = !this.lastUsedLeft;
        }
        if (w == null) {
            return;
        }
        if (!w.isSelectable()) {
            return;
        }
        if (w.isClosed()) {
            return;
        }
        if (w.getNodesCount() < 2) {
            return;
        }
        newWays.add(w);
        this.lastUsedStartingWay = w;
        if (!NodeWayUtils.addAreaBoundary(w, newWays, this.lastUsedLeft)) {
            NodeWayUtils.addAreaBoundary(w, newWays, !this.lastUsedLeft);
        }
        if (!newWays.isEmpty()) {
            SelectBoundaryAction.getCurrentDataSet().setSelected(newWays);
            return;
        }
        new Notification(I18n.tr((String)"Nothing found. Please select way that is a part of some polygon formed by connected ways", (Object[])new Object[0])).setIcon(2).show();
    }

    protected void updateEnabledState() {
        if (SelectBoundaryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            return;
        }
        this.setEnabled(true);
    }
}

