/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.VehiclePropertyStringParser;

public class PreferenceAccessParameters
implements AccessParameters {
    private final String accessClass;
    private final Map<AccessType, Boolean> accessTypeUsableMap;
    private final Map<VehiclePropertyType<?>, String> vehiclePropertyStrings;
    private final Map<VehiclePropertyType<?>, Object> vehiclePropertyValues;

    @Override
    public String getAccessClass() {
        return this.accessClass;
    }

    @Override
    public boolean getAccessTypeUsable(AccessType accessType) {
        assert (accessType != null);
        return this.accessTypeUsableMap.get((Object)accessType);
    }

    @Override
    public Collection<VehiclePropertyType<?>> getAvailableVehicleProperties() {
        return this.vehiclePropertyValues.keySet();
    }

    public <D> D getVehiclePropertyValue(VehiclePropertyType<D> vehicleProperty) {
        assert (vehicleProperty != null);
        Object value = this.vehiclePropertyValues.get(vehicleProperty);
        return (D)value;
    }

    public String getVehiclePropertyString(VehiclePropertyType<?> vehicleProperty) {
        assert (vehicleProperty != null);
        return this.vehiclePropertyStrings.get(vehicleProperty);
    }

    public PreferenceAccessParameters(String accessClass, Collection<AccessType> usableAccessTypes, Map<VehiclePropertyType<?>, String> vehiclePropertyStrings) throws VehiclePropertyStringParser.PropertyValueSyntaxException {
        this.accessClass = accessClass;
        this.accessTypeUsableMap = new EnumMap<AccessType, Boolean>(AccessType.class);
        for (AccessType accessType : AccessType.values()) {
            this.accessTypeUsableMap.put(accessType, usableAccessTypes.contains((Object)accessType));
        }
        this.vehiclePropertyStrings = Collections.unmodifiableMap(new HashMap(vehiclePropertyStrings));
        this.vehiclePropertyValues = new HashMap();
        for (VehiclePropertyType<?> vehiclePropertyType : vehiclePropertyStrings.keySet()) {
            String propertyValueString = vehiclePropertyStrings.get(vehiclePropertyType);
            Object propertyValue = VehiclePropertyStringParser.parsePropertyValue(vehiclePropertyType, propertyValueString);
            this.vehiclePropertyValues.put(vehiclePropertyType, propertyValue);
        }
    }
}

