/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.transition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessEvaluator;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRuleset;
import org.openstreetmap.josm.plugins.graphview.core.access.RulesetAccessEvaluator;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSourceObserver;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.transition.Restriction;
import org.openstreetmap.josm.plugins.graphview.core.transition.Segment;
import org.openstreetmap.josm.plugins.graphview.core.transition.SegmentNode;
import org.openstreetmap.josm.plugins.graphview.core.transition.TransitionStructure;
import org.openstreetmap.josm.plugins.graphview.core.transition.TransitionStructureObserver;

public class GenericTransitionStructure<N, W, R, M>
implements TransitionStructure,
DataSourceObserver {
    private static final Collection<Segment> EMPTY_SEGMENT_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final Collection<Restriction> EMPTY_RESTRICTION_COLLECTION = new ArrayList<Restriction>(0);
    private final Set<TransitionStructureObserver> observers = new HashSet<TransitionStructureObserver>();
    private final Collection<RoadPropertyType<?>> properties;
    private final DataSource<N, W, R, M> dataSource;
    private AccessParameters accessParameters;
    private AccessRuleset ruleset;
    private AccessEvaluator<N, W> accessEvaluator;
    private Collection<SegmentNode> nodes = null;
    private Collection<Segment> segments = new LinkedList<Segment>();
    private Collection<Restriction> restrictions = new LinkedList<Restriction>();

    public GenericTransitionStructure(AccessParameters accessParameters, AccessRuleset ruleset, DataSource<N, W, R, M> dataSource, Collection<RoadPropertyType<?>> properties) {
        assert (accessParameters != null && ruleset != null);
        assert (dataSource != null);
        assert (properties != null);
        this.dataSource = dataSource;
        this.properties = properties;
        this.setAccessParametersAndRuleset(accessParameters, ruleset);
        dataSource.addObserver(this);
    }

    public void setAccessParametersAndRuleset(AccessParameters accessParameters, AccessRuleset ruleset) {
        if (accessParameters != null) {
            this.accessParameters = accessParameters;
        }
        if (ruleset != null) {
            this.ruleset = ruleset;
        }
        if (accessParameters != null || ruleset != null) {
            assert (this.dataSource != null);
            this.accessEvaluator = new RulesetAccessEvaluator<N, W, R, M>(this.dataSource, this.ruleset, this.accessParameters);
            this.updateData();
            this.notifyObservers();
        }
    }

    @Override
    public Collection<SegmentNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Collection<Segment> getSegments() {
        return this.segments;
    }

    @Override
    public Collection<Restriction> getRestrictions() {
        return this.restrictions;
    }

    protected void updateData() {
        ArrayList<SegmentNode> nodes = new ArrayList<SegmentNode>();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        HashMap nodeCreationMap = new HashMap();
        HashMap waySegmentMap = new HashMap();
        for (W way : this.dataSource.getWays()) {
            this.createSegmentsAndSegmentNodes(way, this.accessEvaluator, nodes, segments, nodeCreationMap, waySegmentMap);
        }
        nodes.trimToSize();
        segments.trimToSize();
        Collection<Restriction> restrictions = this.createRestrictionsFromTurnRestrictions(this.dataSource.getRelations(), nodeCreationMap, waySegmentMap);
        restrictions.addAll(this.createRestrictionsFromBarrierNodes(nodeCreationMap, waySegmentMap));
        this.nodes = nodes;
        this.segments = segments;
        this.restrictions = restrictions;
        this.notifyObservers();
    }

    private void createSegmentsAndSegmentNodes(W way, AccessEvaluator<N, W> wayAccessEvaluator, Collection<SegmentNode> nodes, Collection<Segment> segments, Map<N, SegmentNodeImpl> nodeCreationMap, Map<W, List<Segment>> waySegmentMap) {
        assert (way != null && wayAccessEvaluator != null && nodes != null && segments != null && nodeCreationMap != null && waySegmentMap != null);
        Map<RoadPropertyType<?>, Object> forwardPropertyValues = this.getWayPropertyMap(way, true);
        Map<RoadPropertyType<?>, Object> backwardPropertyValues = this.getWayPropertyMap(way, false);
        boolean forwardAccess = wayAccessEvaluator.wayUsable(way, true, forwardPropertyValues);
        boolean backwardAccess = wayAccessEvaluator.wayUsable(way, false, backwardPropertyValues);
        if (forwardAccess || backwardAccess) {
            if (!waySegmentMap.containsKey(way)) {
                waySegmentMap.put(way, new LinkedList());
            }
            N previousNode = null;
            for (N node : this.dataSource.getNodes(way)) {
                if (previousNode != null) {
                    SegmentImpl segment;
                    SegmentNodeImpl node1 = this.getOrCreateSegmentNodeForNode(previousNode, nodes, nodeCreationMap);
                    SegmentNodeImpl node2 = this.getOrCreateSegmentNodeForNode(node, nodes, nodeCreationMap);
                    if (forwardAccess) {
                        segment = new SegmentImpl(node1, node2, forwardPropertyValues);
                        segments.add(segment);
                        waySegmentMap.get(way).add(segment);
                        node1.addOutboundSegment(segment);
                        node2.addInboundSegment(segment);
                    }
                    if (backwardAccess) {
                        segment = new SegmentImpl(node2, node1, backwardPropertyValues);
                        segments.add(segment);
                        waySegmentMap.get(way).add(segment);
                        node1.addInboundSegment(segment);
                        node2.addOutboundSegment(segment);
                    }
                }
                previousNode = node;
            }
        }
    }

    private SegmentNodeImpl getOrCreateSegmentNodeForNode(N node, Collection<SegmentNode> nodes, Map<N, SegmentNodeImpl> nodeCreationMap) {
        SegmentNodeImpl segmentNode = nodeCreationMap.get(node);
        if (segmentNode == null) {
            Map<RoadPropertyType<?>, Object> nodePropertyValues = this.getNodePropertyMap(node);
            segmentNode = new SegmentNodeImpl(this.dataSource.getLat(node), this.dataSource.getLon(node), nodePropertyValues);
            nodeCreationMap.put(node, segmentNode);
            nodes.add(segmentNode);
        }
        return segmentNode;
    }

    private Collection<Restriction> createRestrictionsFromTurnRestrictions(Iterable<R> relations, Map<N, SegmentNodeImpl> nodeCreationMap, Map<W, List<Segment>> waySegmentMap) {
        assert (relations != null && nodeCreationMap != null && waySegmentMap != null);
        LinkedList<Restriction> results = new LinkedList<Restriction>();
        for (R relation : relations) {
            TagGroup tags = this.dataSource.getTagsR(relation);
            if (!"restriction".equals(tags.getValue("type")) || tags.getValue("restriction") == null) continue;
            if (tags.getValue("restriction").startsWith("no_")) {
                results.addAll(this.createRestrictionsFromRestrictionRelation(relation, true, nodeCreationMap, waySegmentMap));
                continue;
            }
            if (!tags.getValue("restriction").startsWith("only_")) continue;
            results.addAll(this.createRestrictionsFromRestrictionRelation(relation, false, nodeCreationMap, waySegmentMap));
        }
        return results;
    }

    private Collection<Restriction> createRestrictionsFromRestrictionRelation(R relation, boolean restrictive, Map<N, SegmentNodeImpl> nodeCreationMap, Map<W, List<Segment>> waySegmentMap) {
        Object fromWay = null;
        LinkedList<Object> viaNodes = new LinkedList<Object>();
        LinkedList<Object> viaWays = new LinkedList<Object>();
        LinkedList<Object> toWays = new LinkedList<Object>();
        for (M member : this.dataSource.getMembers(relation)) {
            if ("from".equals(this.dataSource.getRole(member))) {
                if (fromWay != null || !this.dataSource.isWMember(member)) {
                    return EMPTY_RESTRICTION_COLLECTION;
                }
                fromWay = this.dataSource.getMember(member);
                continue;
            }
            if ("to".equals(this.dataSource.getRole(member))) {
                if (!this.dataSource.isWMember(member)) {
                    return EMPTY_RESTRICTION_COLLECTION;
                }
                toWays.add(this.dataSource.getMember(member));
                continue;
            }
            if (!"via".equals(this.dataSource.getRole(member))) continue;
            if (this.dataSource.isWMember(member)) {
                viaWays.add(this.dataSource.getMember(member));
                continue;
            }
            if (!this.dataSource.isNMember(member)) continue;
            viaNodes.add(this.dataSource.getMember(member));
        }
        if (fromWay != null && toWays.size() > 0 && (viaNodes.size() > 0 || viaWays.size() > 0)) {
            return this.createRestrictionsFromRestrictionRelationMembers(restrictive, nodeCreationMap, waySegmentMap, fromWay, viaNodes, viaWays, toWays);
        }
        return new ArrayList<Restriction>(0);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Restriction> createRestrictionsFromRestrictionRelationMembers(boolean restrictive, Map<N, SegmentNodeImpl> nodeCreationMap, Map<W, List<Segment>> waySegmentMap, W fromWay, Collection<N> viaNodes, Collection<W> viaWays, Collection<W> toWays) {
        void var11_16;
        ArrayList<SegmentNodeImpl> nodesCreatedFromViaNodes = new ArrayList<SegmentNodeImpl>(viaNodes.size());
        for (N viaNode : viaNodes) {
            if (!nodeCreationMap.containsKey(viaNode)) continue;
            nodesCreatedFromViaNodes.add(nodeCreationMap.get(viaNode));
        }
        if (!waySegmentMap.containsKey(fromWay)) {
            return EMPTY_RESTRICTION_COLLECTION;
        }
        for (Object viaWay : viaWays) {
            if (waySegmentMap.containsKey(viaWay)) continue;
            return EMPTY_RESTRICTION_COLLECTION;
        }
        for (Object toWay : toWays) {
            if (waySegmentMap.containsKey(toWay)) continue;
            return EMPTY_RESTRICTION_COLLECTION;
        }
        ArrayList<Segment> viaSegments = new ArrayList<Segment>();
        for (W w : viaWays) {
            viaSegments.addAll((Collection)waySegmentMap.get(w));
        }
        for (SegmentNode segmentNode : nodesCreatedFromViaNodes) {
            for (Segment segment : segmentNode.getOutboundSegments()) {
                if (!nodesCreatedFromViaNodes.contains(segment.getNode2())) continue;
                viaSegments.add(segment);
            }
        }
        viaSegments.trimToSize();
        HashSet<SegmentNodeImpl> nodesCreatedFromViaMembers = new HashSet<SegmentNodeImpl>(nodesCreatedFromViaNodes);
        for (W viaWay : viaWays) {
            for (Object object : this.dataSource.getNodes(viaWay)) {
                nodesCreatedFromViaMembers.add(nodeCreationMap.get(object));
            }
        }
        Object var11_15 = null;
        ArrayList<Segment> toSegments = new ArrayList<Segment>();
        for (Segment segment : waySegmentMap.get(fromWay)) {
            if (!nodesCreatedFromViaMembers.contains(segment.getNode2())) continue;
            if (var11_16 == null) {
                Segment segment2 = segment;
                continue;
            }
            return EMPTY_RESTRICTION_COLLECTION;
        }
        if (var11_16 == null) {
            return EMPTY_RESTRICTION_COLLECTION;
        }
        if (restrictive) {
            for (Object object : toWays) {
                if (!waySegmentMap.containsKey(object)) continue;
                Segment toSegment = null;
                for (Segment possibleToSegment : waySegmentMap.get(object)) {
                    if (!nodesCreatedFromViaMembers.contains(possibleToSegment.getNode1())) continue;
                    if (toSegment == null) {
                        toSegment = possibleToSegment;
                        continue;
                    }
                    return EMPTY_RESTRICTION_COLLECTION;
                }
                if (toSegment == null) {
                    return EMPTY_RESTRICTION_COLLECTION;
                }
                toSegments.add(toSegment);
            }
        } else {
            for (SegmentNode segmentNode : nodesCreatedFromViaMembers) {
                for (Segment outboundSegment : segmentNode.getOutboundSegments()) {
                    if (viaSegments.contains(outboundSegment)) continue;
                    boolean isAllowed = false;
                    for (W toWay : toWays) {
                        if (!waySegmentMap.get(toWay).contains(outboundSegment)) continue;
                        isAllowed = true;
                        break;
                    }
                    if (isAllowed) continue;
                    toSegments.add(outboundSegment);
                }
            }
        }
        ArrayList<Restriction> results = new ArrayList<Restriction>(1);
        results.add(new RestrictionImpl((Segment)var11_16, viaSegments, toSegments));
        return results;
    }

    private Collection<Restriction> createRestrictionsFromBarrierNodes(Map<N, SegmentNodeImpl> nodeCreationMap, Map<W, List<Segment>> waySegmentMap) {
        assert (nodeCreationMap != null);
        assert (waySegmentMap != null);
        LinkedList<Restriction> results = new LinkedList<Restriction>();
        for (N node : nodeCreationMap.keySet()) {
            if (this.accessEvaluator.nodeUsable(node, nodeCreationMap.get(node).getProperties())) continue;
            SegmentNode barrierNode = nodeCreationMap.get(node);
            for (Segment inboundSegment : barrierNode.getInboundSegments()) {
                for (Segment outboundSegment : barrierNode.getOutboundSegments()) {
                    results.add(new RestrictionImpl(inboundSegment, EMPTY_SEGMENT_LIST, Arrays.asList(outboundSegment)));
                }
            }
        }
        return results;
    }

    private Map<RoadPropertyType<?>, Object> getWayPropertyMap(W way, boolean forward) {
        HashMap propertyValues = new HashMap();
        for (RoadPropertyType<?> property : this.properties) {
            Object value = property.evaluateW(way, forward, this.accessParameters, this.dataSource);
            if (value == null) continue;
            propertyValues.put(property, value);
        }
        return propertyValues;
    }

    private Map<RoadPropertyType<?>, Object> getNodePropertyMap(N node) {
        HashMap propertyValues = new HashMap();
        for (RoadPropertyType<?> property : this.properties) {
            Object value = property.evaluateN(node, this.accessParameters, this.dataSource);
            if (value == null) continue;
            propertyValues.put(property, value);
        }
        return propertyValues;
    }

    @Override
    public void update(DataSource<?, ?, ?, ?> dataSource) {
        assert (this.dataSource == dataSource);
        this.updateData();
    }

    @Override
    public void addObserver(TransitionStructureObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void deleteObserver(TransitionStructureObserver observer) {
        this.observers.remove(observer);
    }

    protected void notifyObservers() {
        for (TransitionStructureObserver observer : this.observers) {
            observer.update(this);
        }
    }

    private static class RestrictionImpl
    implements Restriction {
        private final Segment from;
        private final Collection<Segment> vias;
        private final Collection<Segment> tos;

        public RestrictionImpl(Segment from, Collection<Segment> vias, Collection<Segment> tos) {
            this.from = from;
            this.vias = Collections.unmodifiableCollection(vias);
            this.tos = Collections.unmodifiableCollection(tos);
        }

        @Override
        public Segment getFrom() {
            return this.from;
        }

        @Override
        public Collection<Segment> getVias() {
            return this.vias;
        }

        @Override
        public Collection<Segment> getTos() {
            return this.tos;
        }

        public String toString() {
            return this.from + " -> " + this.vias + " -> " + this.tos;
        }
    }

    private static class SegmentImpl
    implements Segment {
        private final SegmentNode node1;
        private final SegmentNode node2;
        private final Map<RoadPropertyType<?>, Object> properties;

        public SegmentImpl(SegmentNode node1, SegmentNode node2, Map<RoadPropertyType<?>, Object> properties) {
            this.node1 = node1;
            this.node2 = node2;
            this.properties = properties;
        }

        @Override
        public SegmentNode getNode1() {
            return this.node1;
        }

        @Override
        public SegmentNode getNode2() {
            return this.node2;
        }

        @Override
        public Collection<RoadPropertyType<?>> getAvailableProperties() {
            return this.properties.keySet();
        }

        @Override
        public <P> P getPropertyValue(RoadPropertyType<P> property) {
            Object result = this.properties.get(property);
            return (P)result;
        }

        public String toString() {
            return "(" + this.node1 + "->" + this.node2 + ")";
        }
    }

    private static class SegmentNodeImpl
    implements SegmentNode {
        private final double lat;
        private final double lon;
        private final List<Segment> inboundSegments = new LinkedList<Segment>();
        private final List<Segment> outboundSegments = new LinkedList<Segment>();
        private final Map<RoadPropertyType<?>, Object> properties;

        public SegmentNodeImpl(double lat, double lon, Map<RoadPropertyType<?>, Object> properties) {
            assert (properties != null);
            this.lat = lat;
            this.lon = lon;
            this.properties = properties;
        }

        @Override
        public double getLat() {
            return this.lat;
        }

        @Override
        public double getLon() {
            return this.lon;
        }

        public void addInboundSegment(Segment segment) {
            this.inboundSegments.add(segment);
        }

        public void addOutboundSegment(Segment segment) {
            this.outboundSegments.add(segment);
        }

        @Override
        public Collection<Segment> getOutboundSegments() {
            return this.outboundSegments;
        }

        @Override
        public Collection<Segment> getInboundSegments() {
            return this.inboundSegments;
        }

        @Override
        public Collection<RoadPropertyType<?>> getAvailableProperties() {
            return this.properties.keySet();
        }

        @Override
        public <P> P getPropertyValue(RoadPropertyType<P> property) {
            Object result = this.properties.get(property);
            return (P)result;
        }

        public Map<RoadPropertyType<?>, Object> getProperties() {
            return this.properties;
        }

        public String toString() {
            return "(" + this.lat + ", " + this.lon + ")";
        }
    }
}

