/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;

public class MediaPlayerLatch {
    private final MediaPlayer mediaPlayer;

    public MediaPlayerLatch(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play() {
        Logger.debug("play()", new Object[0]);
        CountDownLatch latch = new CountDownLatch(1);
        LatchListener listener = new LatchListener(latch);
        this.mediaPlayer.addMediaPlayerEventListener(listener);
        this.mediaPlayer.play();
        try {
            Logger.debug("Waiting for media playing or error...", new Object[0]);
            latch.await();
            Logger.debug("Finished waiting.", new Object[0]);
            boolean started = listener.playing.get();
            Logger.debug("started={}", started);
            boolean bl = started;
            return bl;
        }
        catch (InterruptedException e) {
            Logger.debug("Interrupted while waiting for media player", e, new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mediaPlayer.removeMediaPlayerEventListener(listener);
        }
    }

    private final class LatchListener
    extends MediaPlayerEventAdapter {
        private final CountDownLatch latch;
        private final AtomicBoolean playing = new AtomicBoolean();

        private LatchListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void playing(MediaPlayer mediaPlayer) {
            this.playing.set(true);
            this.latch.countDown();
        }

        @Override
        public void error(MediaPlayer mediaPlayer) {
            this.playing.set(false);
            this.latch.countDown();
        }
    }
}

