/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import java.awt.Canvas;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_module_description_t;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AudioDevice;
import uk.co.caprica.vlcj.player.AudioOutput;
import uk.co.caprica.vlcj.player.DefaultMediaMeta;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.ModuleDescription;
import uk.co.caprica.vlcj.player.direct.DefaultDirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.embedded.DefaultEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.videosurface.CanvasVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.ComponentIdVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.linux.LinuxVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.mac.MacVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.windows.WindowsVideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.headless.DefaultHeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.headless.HeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.list.DefaultMediaListPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.manager.DefaultMediaManager;
import uk.co.caprica.vlcj.player.manager.MediaManager;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class MediaPlayerFactory {
    private static final String PLUGIN_PATH_HELP = "Failed to initialise libvlc.\n\nThis is most often caused either by an invalid vlc option begin passed when creating a MediaPlayerFactory or by libvlc being unable to locate the required plugins.\n\nIf libvlc is unable to locate the required plugins the instructions below may help:\n\nIn the text below <libvlc-path> represents the name of the directory containing \"{0}\" and \"{1}\" and <plugins-path> represents the name of the directory containing the vlc plugins...\n\nFor libvlc to function correctly the vlc plugins must be available, there are a number of different ways to achieve this:\n 1. Make sure the plugins are installed in the \"<libvlc-path>/{2}\" directory, this should be the case with a normal vlc installation.\n 2. Set the VLC_PLUGIN_PATH operating system environment variable to point to \"<plugins-path>\".\n\nMore information may be available in the log, specify -Dvlcj.log=DEBUG on the command-line when starting your application.\n\n";
    protected final LibVlc libvlc;
    protected final libvlc_instance_t instance;
    private boolean released;

    public MediaPlayerFactory() {
        this(new String[0]);
    }

    public MediaPlayerFactory(String ... libvlcArgs) {
        this(LibVlcFactory.factory().atLeast("2.0.0").create(), libvlcArgs);
    }

    public MediaPlayerFactory(LibVlc libvlc) {
        this(libvlc, new String[0]);
    }

    public MediaPlayerFactory(LibVlc libvlc, String ... libvlcArgs) {
        Logger.debug("MediaPlayerFactory(libvlc={},libvlcArgs={})", libvlc, Arrays.toString(libvlcArgs));
        Logger.debug("jna.library.path={}", System.getProperty("jna.library.path"));
        if (libvlcArgs == null) {
            libvlcArgs = new String[]{};
        }
        for (String libvlcArg : libvlcArgs) {
            if (!libvlcArg.startsWith("--plugin-path=")) continue;
            Logger.debug(libvlcArg, new Object[0]);
        }
        String vlcPluginPath = System.getProperty("VLC_PLUGIN_PATH");
        if (vlcPluginPath != null) {
            Logger.debug("VLC_PLUGIN_PATH={}", vlcPluginPath);
        }
        this.libvlc = libvlc;
        this.instance = libvlc.libvlc_new(libvlcArgs.length, libvlcArgs);
        Logger.debug("instance={}", this.instance);
        if (this.instance == null) {
            Logger.error("Failed to initialise libvlc", new Object[0]);
            String msg = MessageFormat.format(PLUGIN_PATH_HELP, RuntimeUtil.getLibVlcName(), RuntimeUtil.getLibVlcCoreName(), RuntimeUtil.getPluginsDirectoryName());
            throw new RuntimeException(msg);
        }
    }

    public MediaPlayerFactory(List<String> libvlcArgs) {
        this(libvlcArgs.toArray(new String[libvlcArgs.size()]));
    }

    public MediaPlayerFactory(LibVlc libvlc, List<String> libvlcArgs) {
        this(libvlc, libvlcArgs.toArray(new String[libvlcArgs.size()]));
    }

    public void release() {
        Logger.debug("release()", new Object[0]);
        if (!this.released) {
            if (this.instance != null) {
                this.libvlc.libvlc_release(this.instance);
            }
            this.released = true;
        }
    }

    public void setUserAgent(String userAgent) {
        Logger.debug("setUserAgent(userAgent={})", userAgent);
        this.setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, String httpUserAgent) {
        Logger.debug("setUserAgent(userAgent={},httpUserAgent={})", userAgent, httpUserAgent);
        this.libvlc.libvlc_set_user_agent(this.instance, userAgent, userAgent);
    }

    public List<AudioOutput> getAudioOutputs() {
        Logger.debug("getAudioOutputs()", new Object[0]);
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutput = this.libvlc.libvlc_audio_output_list_get(this.instance);
        while (audioOutput != null) {
            result.add(new AudioOutput(audioOutput.psz_name, audioOutput.psz_description, this.getAudioOutputDevices(audioOutput.psz_name)));
            audioOutput = audioOutput.p_next;
        }
        this.libvlc.libvlc_audio_output_list_release(audioOutput);
        return result;
    }

    private List<AudioDevice> getAudioOutputDevices(String outputName) {
        Logger.debug("getAudioOutputDevices(outputName={})", outputName);
        int deviceCount = this.libvlc.libvlc_audio_output_device_count(this.instance, outputName);
        Logger.debug("deviceCount={}", deviceCount);
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>(deviceCount);
        for (int i = 0; i < deviceCount; ++i) {
            String deviceId = null;
            Pointer deviceIdPtr = this.libvlc.libvlc_audio_output_device_id(this.instance, outputName, i);
            if (deviceIdPtr != null) {
                deviceId = deviceIdPtr.getString(0L, false);
                this.libvlc.libvlc_free(deviceIdPtr);
            }
            String longName = null;
            Pointer longNamePtr = this.libvlc.libvlc_audio_output_device_longname(this.instance, outputName, i);
            if (longNamePtr != null) {
                longName = longNamePtr.getString(0L, false);
                this.libvlc.libvlc_free(longNamePtr);
            }
            result.add(new AudioDevice(deviceId, longName));
        }
        return result;
    }

    public List<ModuleDescription> getAudioFilters() {
        Logger.debug("getAudioFilters()", new Object[0]);
        libvlc_module_description_t moduleDescriptions = this.libvlc.libvlc_audio_filter_list_get(this.instance);
        moduleDescriptions.setAutoSynch(false);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        this.libvlc.libvlc_module_description_list_release(moduleDescriptions);
        return result;
    }

    public List<ModuleDescription> getVideoFilters() {
        Logger.debug("getVideoFilters()", new Object[0]);
        libvlc_module_description_t moduleDescriptions = this.libvlc.libvlc_video_filter_list_get(this.instance);
        moduleDescriptions.setAutoSynch(false);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        this.libvlc.libvlc_module_description_list_release(moduleDescriptions);
        return result;
    }

    private List<ModuleDescription> getModuleDescriptions(libvlc_module_description_t moduleDescriptions) {
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        libvlc_module_description_t moduleDescription = moduleDescriptions;
        while (moduleDescription != null) {
            result.add(new ModuleDescription(moduleDescription.psz_name, moduleDescription.psz_shortname, moduleDescription.psz_longname, moduleDescription.psz_help));
            moduleDescription = moduleDescription.p_next;
        }
        return result;
    }

    public EmbeddedMediaPlayer newEmbeddedMediaPlayer() {
        Logger.debug("newEmbeddedMediaPlayer()", new Object[0]);
        return this.newEmbeddedMediaPlayer(null);
    }

    public EmbeddedMediaPlayer newEmbeddedMediaPlayer(FullScreenStrategy fullScreenStrategy) {
        Logger.debug("newEmbeddedMediaPlayer(fullScreenStrategy={})", fullScreenStrategy);
        return new DefaultEmbeddedMediaPlayer(this.libvlc, this.instance, fullScreenStrategy);
    }

    public DirectMediaPlayer newDirectMediaPlayer(int width, int height, RenderCallback renderCallback) {
        Logger.debug("newDirectMediaPlayer(width={},height={},renderCallback={})", width, height, renderCallback);
        return this.newDirectMediaPlayer("RV32", width, height, width * 4, renderCallback);
    }

    public DirectMediaPlayer newDirectMediaPlayer(String format, int width, int height, int pitch, RenderCallback renderCallback) {
        Logger.debug("newDirectMediaPlayer(format={},width={},height={},pitch={},renderCallback={})", format, width, height, pitch, renderCallback);
        return new DefaultDirectMediaPlayer(this.libvlc, this.instance, format, width, height, pitch, renderCallback);
    }

    public HeadlessMediaPlayer newHeadlessMediaPlayer() {
        Logger.debug("newHeadlessMediaPlayer()", new Object[0]);
        return new DefaultHeadlessMediaPlayer(this.libvlc, this.instance);
    }

    public MediaListPlayer newMediaListPlayer() {
        Logger.debug("newMediaListPlayer()", new Object[0]);
        return new DefaultMediaListPlayer(this.libvlc, this.instance);
    }

    public CanvasVideoSurface newVideoSurface(Canvas canvas) {
        VideoSurfaceAdapter videoSurfaceAdapter;
        Logger.debug("newVideoSurface(canvas={})", canvas);
        if (RuntimeUtil.isNix()) {
            videoSurfaceAdapter = new LinuxVideoSurfaceAdapter();
        } else if (RuntimeUtil.isWindows()) {
            videoSurfaceAdapter = new WindowsVideoSurfaceAdapter();
        } else if (RuntimeUtil.isMac()) {
            videoSurfaceAdapter = new MacVideoSurfaceAdapter();
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        CanvasVideoSurface videoSurface = new CanvasVideoSurface(canvas, videoSurfaceAdapter);
        Logger.debug("videoSurface={}", videoSurface);
        return videoSurface;
    }

    public ComponentIdVideoSurface newVideoSurface(long componentId) {
        VideoSurfaceAdapter videoSurfaceAdapter;
        Logger.debug("newVideoSurface(componentId={})", componentId);
        if (RuntimeUtil.isNix()) {
            videoSurfaceAdapter = new LinuxVideoSurfaceAdapter();
        } else if (RuntimeUtil.isWindows()) {
            videoSurfaceAdapter = new WindowsVideoSurfaceAdapter();
        } else if (RuntimeUtil.isMac()) {
            videoSurfaceAdapter = new MacVideoSurfaceAdapter();
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        ComponentIdVideoSurface videoSurface = new ComponentIdVideoSurface(componentId, videoSurfaceAdapter);
        Logger.debug("videoSurface={}", videoSurface);
        return videoSurface;
    }

    public MediaList newMediaList() {
        Logger.debug("newMediaList()", new Object[0]);
        return new MediaList(this.libvlc, this.instance);
    }

    public MediaMeta getMediaMeta(String mediaPath, boolean parse) {
        Logger.debug("getMediaMeta(mediaPath={},parse={})", mediaPath, parse);
        libvlc_media_t media = this.libvlc.libvlc_media_new_path(this.instance, mediaPath);
        Logger.debug("media={}", media);
        if (media != null) {
            if (parse) {
                Logger.debug("Parsing media...", new Object[0]);
                this.libvlc.libvlc_media_parse(media);
                Logger.debug("Media parsed.", new Object[0]);
            }
            DefaultMediaMeta mediaMeta = new DefaultMediaMeta(this.libvlc, media);
            this.libvlc.libvlc_media_release(media);
            return mediaMeta;
        }
        return null;
    }

    public long clock() {
        Logger.trace("clock()", new Object[0]);
        return this.libvlc.libvlc_clock();
    }

    public MediaManager newMediaManager() {
        Logger.trace("newMediaManager()", new Object[0]);
        return new DefaultMediaManager(this.libvlc, this.instance);
    }

    public String version() {
        Logger.debug("version()", new Object[0]);
        return this.libvlc.libvlc_get_version();
    }

    public String compiler() {
        Logger.debug("compiler()", new Object[0]);
        return this.libvlc.libvlc_get_compiler();
    }

    public String changeset() {
        Logger.debug("changeset()", new Object[0]);
        return this.libvlc.libvlc_get_changeset();
    }
}

