/*
 * Decompiled with CFR 0.152.
 */
package smed2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import panels.PanelMain;
import panels.PanelS57;
import panels.ShowFrame;
import s57.S57map;
import smed2.MapImage;

public class Smed2Action
extends JosmAction
implements MapView.EditLayerChangeListener,
SelectionChangedListener {
    private static String editor = I18n.tr((String)"SeaMap Editor", (Object[])new Object[0]);
    public static JFrame editFrame = null;
    public static ShowFrame showFrame = null;
    private boolean isOpen = false;
    public static PanelMain panelMain = null;
    public static PanelS57 panelS57 = null;
    public static MapImage rendering;
    public static S57map map;
    public DataSet data = null;
    private final DataSetListener dataSetListener = new DataSetListener(){

        public void dataChanged(DataChangedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void nodeMoved(NodeMovedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void otherDatasetChange(AbstractDatasetChangedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void primitivesAdded(PrimitivesAddedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void primitivesRemoved(PrimitivesRemovedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void relationMembersChanged(RelationMembersChangedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void tagsChanged(TagsChangedEvent e) {
            Smed2Action.this.makeMap();
        }

        public void wayNodesChanged(WayNodesChangedEvent e) {
            Smed2Action.this.makeMap();
        }
    };

    public Smed2Action() {
        super(editor, "Smed2", editor, null, true);
    }

    public void actionPerformed(ActionEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!Smed2Action.this.isOpen) {
                    Smed2Action.this.createFrame();
                } else {
                    editFrame.toFront();
                }
                Smed2Action.this.isOpen = true;
            }
        });
    }

    protected void createFrame() {
        editFrame = new JFrame(editor);
        editFrame.setDefaultCloseOperation(2);
        editFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Smed2Action.this.closeDialog();
            }
        });
        editFrame.setSize(new Dimension(480, 480));
        editFrame.setLocation(100, 200);
        editFrame.setResizable(true);
        editFrame.setAlwaysOnTop(true);
        editFrame.setVisible(true);
        panelMain = new PanelMain();
        editFrame.add(panelMain);
        panelS57 = new PanelS57();
        editFrame.add(panelS57);
        showFrame = new ShowFrame(I18n.tr((String)"Seamark Inspector", (Object[])new Object[0]));
        showFrame.setSize(new Dimension(300, 300));
        showFrame.setLocation(50, 400);
        showFrame.setResizable(false);
        showFrame.setAlwaysOnTop(true);
        showFrame.setEnabled(true);
        showFrame.setVisible(false);
        rendering = new MapImage(new ImageryInfo("OpenSeaMap"));
        rendering.setBackgroundLayer(true);
        Main.main.addLayer((Layer)rendering);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.editLayerChanged(Main.main.getEditLayer(), Main.main.getEditLayer());
    }

    public void closeDialog() {
        if (this.isOpen) {
            Main.main.removeLayer((Layer)rendering);
            MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
            editFrame.setVisible(false);
            editFrame.dispose();
            this.data = null;
            map = null;
        }
        this.isOpen = false;
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (oldLayer != null) {
            oldLayer.data.removeDataSetListener(this.dataSetListener);
        }
        if (newLayer != null) {
            newLayer.data.addDataSetListener(this.dataSetListener);
            this.data = newLayer.data;
            this.makeMap();
        } else {
            this.data = null;
            map = null;
        }
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> selection) {
        OsmPrimitive nextFeature = null;
        OsmPrimitive feature = null;
        showFrame.setVisible(false);
        panelMain.clearMark();
        if (map != null) {
            Iterator<? extends OsmPrimitive> i$ = selection.iterator();
            while (i$.hasNext()) {
                OsmPrimitive osm;
                nextFeature = osm = i$.next();
                if (selection.size() == 1) {
                    S57map.Feature id;
                    if (nextFeature.compareTo(feature) == 0 || (id = (S57map.Feature)Smed2Action.map.index.get((feature = nextFeature).getUniqueId())) == null) continue;
                    panelMain.parseMark(id);
                    showFrame.setVisible(true);
                    showFrame.showFeature(feature, map);
                    continue;
                }
                showFrame.setVisible(false);
                PanelMain.setStatus(I18n.tr((String)"Select only one object", (Object[])new Object[0]), Color.orange);
            }
            if (nextFeature == null) {
                feature = null;
                panelMain.clearMark();
                showFrame.setVisible(false);
                PanelMain.setStatus(I18n.tr((String)"Select a map object", (Object[])new Object[0]), Color.yellow);
            }
        }
    }

    void makeMap() {
        map = new S57map();
        if (this.data != null) {
            for (Node node : this.data.getNodes()) {
                map.addNode(node.getUniqueId(), node.getCoor().lat(), node.getCoor().lon());
                for (Map.Entry entry : node.getKeys().entrySet()) {
                    map.addTag((String)entry.getKey(), (String)entry.getValue());
                }
                map.tagsDone(node.getUniqueId());
            }
            for (Way way : this.data.getWays()) {
                if (way.getNodesCount() <= 0) continue;
                map.addEdge(way.getUniqueId());
                for (Node node : way.getNodes()) {
                    map.addToEdge(node.getUniqueId());
                }
                for (Map.Entry entry : way.getKeys().entrySet()) {
                    map.addTag((String)entry.getKey(), (String)entry.getValue());
                }
                map.tagsDone(way.getUniqueId());
            }
            for (Relation rel : this.data.getRelations()) {
                if (!rel.isMultipolygon() || rel.getMembersCount() <= 0) continue;
                map.addArea(rel.getUniqueId());
                for (RelationMember mem : rel.getMembers()) {
                    if (mem.getType() != OsmPrimitiveType.WAY) continue;
                    map.addToArea(mem.getUniqueId(), mem.getRole().equals("outer"));
                }
                for (Map.Entry entry : rel.getKeys().entrySet()) {
                    map.addTag((String)entry.getKey(), (String)entry.getValue());
                }
                map.tagsDone(rel.getUniqueId());
            }
            if (rendering != null) {
                rendering.zoomChanged();
            }
        }
    }

    static {
        map = null;
    }
}

