/*
 * Decompiled with CFR 0.152.
 */
package smed2;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import render.MapContext;
import render.Renderer;
import s57.S57map;
import smed2.Smed2Action;

public class MapImage
extends ImageryLayer
implements NavigatableComponent.ZoomChangeListener,
MapContext {
    double top;
    double bottom;
    double left;
    double right;
    double width;
    double height;
    int zoom;

    public MapImage(ImageryInfo info) {
        super(info);
        MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        this.zoomChanged();
    }

    public void destroy() {
        MapView.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        super.destroy();
    }

    public Action[] getMenuEntries() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bb) {
        Rectangle rect = Main.map.mapView.getBounds();
        g2.setPaint(Color.black);
        g2.setFont(new Font("Arial", 1, 20));
        g2.drawString("Z" + this.zoom, rect.x + rect.width - 40, rect.y + rect.height - 10);
        Renderer.reRender(g2, this.zoom, Math.pow(2.0, this.zoom - 12), Smed2Action.map, this);
    }

    public void zoomChanged() {
        if (Main.map != null && Main.map.mapView != null) {
            Bounds bounds = Main.map.mapView.getRealBounds();
            this.top = bounds.getMax().lat();
            this.bottom = bounds.getMin().lat();
            this.left = bounds.getMin().lon();
            this.right = bounds.getMax().lon();
            this.width = Main.map.mapView.getBounds().getWidth();
            this.height = Main.map.mapView.getBounds().getHeight();
            this.zoom = (int)Math.min(18L, Math.max(9L, Math.round(Math.floor(Math.log(1024.0 / bounds.asRect().height) / Math.log(2.0)))));
        }
    }

    @Override
    public Point2D.Double getPoint(S57map.Snode coord) {
        return (Point2D.Double)Main.map.mapView.getPoint2D(new LatLon(Math.toDegrees(coord.lat), Math.toDegrees(coord.lon)));
    }

    @Override
    public double mile(S57map.Feature feature) {
        return 185000.0 / Main.map.mapView.getDist100Pixel();
    }
}

