/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.io.FileInputStream;
import java.io.IOException;
import s57.S57dat;
import s57.S57map;

public class S57dec {
    public static S57map.MapBounds decodeFile(FileInputStream in, S57map map) throws IOException {
        S57dat.rnum = 0;
        byte[] leader = new byte[24];
        boolean ddr = false;
        boolean inFeature = false;
        double comf = 1.0;
        double somf = 1.0;
        long name = 0L;
        S57map.Nflag nflag = S57map.Nflag.ANON;
        S57map.Pflag pflag = S57map.Pflag.NOSP;
        long objl = 0L;
        S57map.MapBounds bounds = new S57map.MapBounds(map);
        while (in.read(leader) == 24) {
            int length = Integer.parseInt(new String(leader, 0, 5)) - 24;
            ddr = leader[6] == 76;
            int fields = Integer.parseInt(new String(leader, 12, 5)) - 24;
            int mapfl = leader[20] - 48;
            int mapfp = leader[21] - 48;
            int mapts = leader[23] - 48;
            int entry = mapfl + mapfp + mapts;
            byte[] record = new byte[length];
            if (in.read(record) != length) break;
            for (int idx = 0; idx < fields - 1; idx += entry) {
                String tag = new String(record, idx, mapts);
                int len = Integer.parseInt(new String(record, idx + mapts, mapfl));
                int pos = Integer.parseInt(new String(record, idx + mapts + mapfl, mapfp));
                if (!ddr) {
                    switch (S57dat.enumField(tag)) {
                        case I8RI: {
                            int i8rn = ((Long)S57dat.getSubf(record, fields + pos, S57dat.S57field.I8RI, S57dat.S57subf.I8RN)).intValue();
                            if (i8rn == ++S57dat.rnum) break;
                            System.err.println("Out of order record ID");
                            in.close();
                            System.exit(-1);
                            break;
                        }
                        case DSSI: {
                            S57dat.getSubf(record, fields + pos, S57dat.S57field.DSSI, S57dat.S57subf.AALL);
                            S57dat.getSubf(S57dat.S57subf.NALL);
                            break;
                        }
                        case DSPM: {
                            comf = ((Long)S57dat.getSubf(record, fields + pos, S57dat.S57field.DSPM, S57dat.S57subf.COMF)).longValue();
                            somf = ((Long)S57dat.getSubf(S57dat.S57subf.SOMF)).longValue();
                            break;
                        }
                        case FRID: {
                            inFeature = true;
                            switch (((Long)S57dat.getSubf(record, fields + pos, S57dat.S57field.FRID, S57dat.S57subf.PRIM)).intValue()) {
                                case 1: {
                                    pflag = S57map.Pflag.POINT;
                                    break;
                                }
                                case 2: {
                                    pflag = S57map.Pflag.LINE;
                                    break;
                                }
                                case 3: {
                                    pflag = S57map.Pflag.AREA;
                                    break;
                                }
                                default: {
                                    pflag = S57map.Pflag.NOSP;
                                }
                            }
                            objl = (Long)S57dat.getSubf(S57dat.S57subf.OBJL);
                            break;
                        }
                        case FOID: {
                            name = (Long)S57dat.getSubf(record, fields + pos, S57dat.S57field.FOID, S57dat.S57subf.LNAM);
                            map.newFeature(name, pflag, objl);
                            break;
                        }
                        case ATTF: {
                            S57dat.setField(record, fields + pos, S57dat.S57field.ATTF, len);
                            do {
                                long attl = (Long)S57dat.getSubf(S57dat.S57subf.ATTL);
                                String atvl = ((String)S57dat.getSubf(S57dat.S57subf.ATVL)).trim();
                                if (atvl.isEmpty()) continue;
                                map.newAtt(attl, atvl);
                            } while (S57dat.more());
                            break;
                        }
                        case FFPT: {
                            S57dat.setField(record, fields + pos, S57dat.S57field.FFPT, len);
                            do {
                                name = (Long)S57dat.getSubf(S57dat.S57subf.LNAM);
                                int rind = ((Long)S57dat.getSubf(S57dat.S57subf.RIND)).intValue();
                                S57dat.getSubf(S57dat.S57subf.COMT);
                                map.newObj(name, rind);
                            } while (S57dat.more());
                            break;
                        }
                        case FSPT: {
                            S57dat.setField(record, fields + pos, S57dat.S57field.FSPT, len);
                            do {
                                name = (Long)S57dat.getSubf(S57dat.S57subf.NAME) << 16;
                                map.newPrim(name, (Long)S57dat.getSubf(S57dat.S57subf.ORNT), (Long)S57dat.getSubf(S57dat.S57subf.USAG));
                                S57dat.getSubf(S57dat.S57subf.MASK);
                            } while (S57dat.more());
                            break;
                        }
                        case VRID: {
                            inFeature = false;
                            name = (Long)S57dat.getSubf(record, fields + pos, S57dat.S57field.VRID, S57dat.S57subf.RCNM);
                            switch ((int)name) {
                                case 110: {
                                    nflag = S57map.Nflag.ISOL;
                                    break;
                                }
                                case 120: {
                                    nflag = S57map.Nflag.CONN;
                                    break;
                                }
                                default: {
                                    nflag = S57map.Nflag.ANON;
                                }
                            }
                            name <<= 32;
                            name += ((Long)S57dat.getSubf(S57dat.S57subf.RCID)).longValue();
                            name <<= 16;
                            if (nflag != S57map.Nflag.ANON) break;
                            map.newEdge(name);
                            break;
                        }
                        case VRPT: {
                            S57dat.setField(record, fields + pos, S57dat.S57field.VRPT, len);
                            do {
                                long conn = (Long)S57dat.getSubf(S57dat.S57subf.NAME) << 16;
                                int topi = ((Long)S57dat.getSubf(S57dat.S57subf.TOPI)).intValue();
                                map.addConn(conn, topi);
                                S57dat.getSubf(S57dat.S57subf.MASK);
                            } while (S57dat.more());
                            break;
                        }
                        case SG2D: {
                            S57dat.setField(record, fields + pos, S57dat.S57field.SG2D, len);
                            do {
                                double lat = (double)((Long)S57dat.getSubf(S57dat.S57subf.YCOO)).longValue() / comf;
                                double lon = (double)((Long)S57dat.getSubf(S57dat.S57subf.XCOO)).longValue() / comf;
                                if (nflag == S57map.Nflag.ANON) {
                                    map.newNode(++name, lat, lon, nflag);
                                } else {
                                    map.newNode(name, lat, lon, nflag);
                                }
                                if (lat < bounds.minlat) {
                                    bounds.minlat = lat;
                                }
                                if (lat > bounds.maxlat) {
                                    bounds.maxlat = lat;
                                }
                                if (lon < bounds.minlon) {
                                    bounds.minlon = lon;
                                }
                                if (!(lon > bounds.maxlon)) continue;
                                bounds.maxlon = lon;
                            } while (S57dat.more());
                            break;
                        }
                        case SG3D: {
                            S57dat.setField(record, fields + pos, S57dat.S57field.SG3D, len);
                            do {
                                double lat = (double)((Long)S57dat.getSubf(S57dat.S57subf.YCOO)).longValue() / comf;
                                double lon = (double)((Long)S57dat.getSubf(S57dat.S57subf.XCOO)).longValue() / comf;
                                double depth = (double)((Long)S57dat.getSubf(S57dat.S57subf.VE3D)).longValue() / somf;
                                map.newNode(name++, lat, lon, depth);
                                if (lat < bounds.minlat) {
                                    bounds.minlat = lat;
                                }
                                if (lat > bounds.maxlat) {
                                    bounds.maxlat = lat;
                                }
                                if (lon < bounds.minlon) {
                                    bounds.minlon = lon;
                                }
                                if (!(lon > bounds.maxlon)) continue;
                                bounds.maxlon = lon;
                            } while (S57dat.more());
                            break;
                        }
                    }
                }
                if (!inFeature) continue;
                map.endFeature();
                inFeature = false;
            }
        }
        map.endFile();
        in.close();
        return bounds;
    }
}

