/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.EnumMap;
import render.Renderer;
import render.Rules;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;
import symbols.Beacons;
import symbols.Symbols;
import symbols.Topmarks;

public class Signals {
    static final EnumMap<S57val.ColCOL, Color> lightColours = new EnumMap(S57val.ColCOL.class);
    static final EnumMap<S57val.ColCOL, String> lightLetters;
    static final EnumMap<S57val.LitCHR, String> lightCharacters;
    static final EnumMap<S57val.CatFOG, String> fogSignals;

    public static void addSignals(S57map.Feature feature) {
        if (feature.objs.containsKey((Object)S57obj.Obj.FOGSIG)) {
            Signals.fogSignals(feature);
        }
        if (feature.objs.containsKey((Object)S57obj.Obj.RTPBCN)) {
            Signals.radarStations(feature);
        }
        if (feature.objs.containsKey((Object)S57obj.Obj.RADSTA)) {
            Signals.radarStations(feature);
        }
        if (feature.objs.containsKey((Object)S57obj.Obj.RDOSTA)) {
            Signals.radioStations(feature);
        }
        if (feature.objs.containsKey((Object)S57obj.Obj.LIGHTS)) {
            Signals.lights(feature);
        }
    }

    public static void fogSignals(S57map.Feature feature) {
        Renderer.symbol(feature, Beacons.FogSignal);
        S57map.AttMap atts = (S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)S57obj.Obj.FOGSIG)).get(0);
        String str = "";
        if (atts.containsKey((Object)S57att.Att.CATFOG)) {
            str = str + fogSignals.get(((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATFOG))).val);
        }
        str = atts.containsKey((Object)S57att.Att.SIGGRP) ? str + "(" + ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SIGGRP))).val + ")" : str + " ";
        if (atts.containsKey((Object)S57att.Att.SIGPER)) {
            str = str + ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SIGPER))).val + "s";
        }
        if (atts.containsKey((Object)S57att.Att.VALMXR)) {
            str = str + ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VALMXR))).val + "M";
        }
        if (Renderer.zoom >= 15 && !str.isEmpty()) {
            Renderer.labelText(feature, str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-60.0, -30.0)));
        }
    }

    public static void radarStations(S57map.Feature feature) {
        Renderer.symbol(feature, Beacons.RadarStation);
        String bstr = "";
        S57val.CatRTB cat = (S57val.CatRTB)((Object)Rules.getAttVal(feature, S57obj.Obj.RTPBCN, 0, S57att.Att.CATRTB));
        switch (cat) {
            case RTB_RAMK: {
                bstr = bstr + " Ramark";
                break;
            }
            case RTB_RACN: {
                bstr = bstr + " Racon";
                String astr = (String)Rules.getAttVal(feature, S57obj.Obj.RTPBCN, 0, S57att.Att.SIGGRP);
                if (!astr.isEmpty()) {
                    bstr = bstr + "(" + astr + ")";
                }
                Double per = (Double)Rules.getAttVal(feature, S57obj.Obj.RTPBCN, 0, S57att.Att.SIGPER);
                Double mxr = (Double)Rules.getAttVal(feature, S57obj.Obj.RTPBCN, 0, S57att.Att.VALMXR);
                if (per == 0.0 && mxr == 0.0) break;
                bstr = bstr + (astr.isEmpty() ? " " : "");
                bstr = bstr + (per != 0.0 ? per.toString() + "s" : "");
                bstr = bstr + (mxr != 0.0 ? mxr.toString() + "M" : "");
                break;
            }
        }
        if (Renderer.zoom >= 15 && !bstr.isEmpty()) {
            Renderer.labelText(feature, bstr, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-30.0, -70.0)));
        }
    }

    public static void radioStations(S57map.Feature feature) {
        Renderer.symbol(feature, Beacons.RadarStation);
        ArrayList cats = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.RDOSTA, 0, S57att.Att.CATROS);
        boolean vais = false;
        String bstr = "";
        for (S57val.CatROS ros : cats) {
            switch (ros) {
                case ROS_OMNI: {
                    bstr = bstr + " RC";
                    break;
                }
                case ROS_DIRL: {
                    bstr = bstr + " RD";
                    break;
                }
                case ROS_ROTP: {
                    bstr = bstr + " RW";
                    break;
                }
                case ROS_CNSL: {
                    bstr = bstr + " Consol";
                    break;
                }
                case ROS_RDF: {
                    bstr = bstr + " RG";
                    break;
                }
                case ROS_QTA: {
                    bstr = bstr + " R";
                    break;
                }
                case ROS_AERO: {
                    bstr = bstr + " AeroRC";
                    break;
                }
                case ROS_DECA: {
                    bstr = bstr + " Decca";
                    break;
                }
                case ROS_LORN: {
                    bstr = bstr + " Loran";
                    break;
                }
                case ROS_DGPS: {
                    bstr = bstr + " DGPS";
                    break;
                }
                case ROS_TORN: {
                    bstr = bstr + " Toran";
                    break;
                }
                case ROS_OMGA: {
                    bstr = bstr + " Omega";
                    break;
                }
                case ROS_SYLD: {
                    bstr = bstr + " Syledis";
                    break;
                }
                case ROS_CHKA: {
                    bstr = bstr + " Chiaka";
                    break;
                }
                case ROS_PCOM: 
                case ROS_COMB: 
                case ROS_FACS: 
                case ROS_TIME: {
                    break;
                }
                case ROS_PAIS: 
                case ROS_SAIS: {
                    bstr = bstr + " AIS";
                    break;
                }
                case ROS_VAIS: {
                    vais = true;
                    break;
                }
                case ROS_VANC: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopNorth, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VASC: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopSouth, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VAEC: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopEast, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VAWC: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopWest, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VAPL: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopCan, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VASL: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopCone, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VAID: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopIsol, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VASW: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopSphere, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VASP: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopX, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
                case ROS_VAWK: {
                    vais = true;
                    Renderer.symbol(feature, Topmarks.TopCross, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                    break;
                }
            }
        }
        if (Renderer.zoom >= 15) {
            if (vais) {
                Renderer.labelText(feature, "V-AIS", new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 70.0)));
            }
            if (!bstr.isEmpty()) {
                Renderer.labelText(feature, bstr, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-30.0, -110.0)));
            }
        }
    }

    public static void lights(S57map.Feature feature) {
        Enum col = null;
        Enum tcol = null;
        S57map.ObjTab objs = (S57map.ObjTab)feature.objs.get((Object)S57obj.Obj.LIGHTS);
        for (S57map.AttMap atts : objs.values()) {
            if (!atts.containsKey((Object)S57att.Att.COLOUR)) continue;
            ArrayList cols = (ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.COLOUR))).val;
            if (cols.size() == 1) {
                tcol = (Enum)cols.get(0);
                if (col == null) {
                    col = tcol;
                    continue;
                }
                if (tcol == col) continue;
                col = S57val.ColCOL.COL_MAG;
                break;
            }
            col = S57val.ColCOL.COL_MAG;
            break;
        }
        Renderer.symbol(feature, Beacons.LightFlare, new Symbols.Scheme(lightColours.get(col)), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getRotateInstance(Math.toRadians(120.0))));
        if (objs.get(1) != null) {
            for (S57map.AttMap atts : objs.values()) {
                ArrayList cats;
                Enum col1 = null;
                Enum col2 = null;
                double radius = 0.2;
                double s1 = 0.0;
                double s2 = 0.0;
                boolean dir = false;
                if (!atts.containsKey((Object)S57att.Att.COLOUR)) continue;
                ArrayList cols = (ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.COLOUR))).val;
                col1 = (Enum)cols.get(0);
                if (cols.size() > 1) {
                    col2 = (Enum)cols.get(1);
                }
                if (atts.containsKey((Object)S57att.Att.RADIUS)) {
                    radius = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.RADIUS))).val;
                }
                if (!atts.containsKey((Object)S57att.Att.SECTR1)) continue;
                s1 = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SECTR1))).val;
                if (!atts.containsKey((Object)S57att.Att.SECTR2)) continue;
                s2 = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SECTR2))).val;
                if (atts.containsKey((Object)S57att.Att.CATLIT) && (cats = (ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATLIT))).val).contains((Object)S57val.CatLIT.LIT_DIR)) {
                    dir = true;
                }
                String str = "";
                if (atts.containsKey((Object)S57att.Att.LITCHR)) {
                    str = str + lightCharacters.get(((S57val.AttVal)atts.get((Object)((Object)S57att.Att.LITCHR))).val);
                }
                if (atts.containsKey((Object)S57att.Att.SIGGRP)) {
                    str = str + "(" + ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SIGGRP))).val + ")";
                } else if (!str.isEmpty()) {
                    str = str + ".";
                }
                if (atts.containsKey((Object)S57att.Att.COLOUR)) {
                    ArrayList cols2 = (ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.COLOUR))).val;
                    str = str + lightLetters.get(cols2.get(0));
                    if (cols2.size() > 1) {
                        str = str + lightLetters.get(cols2.get(1));
                    }
                }
                if (dir && atts.containsKey((Object)S57att.Att.ORIENT)) {
                    double orient = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.ORIENT))).val;
                    str = str + " " + orient + "\u00b0";
                    s1 = (orient - 4.0 + 360.0) % 360.0;
                    s2 = (orient + 4.0) % 360.0;
                    double n1 = 360.0;
                    double n2 = 360.0;
                    for (S57map.AttMap sect : objs.values()) {
                        if (sect == atts) continue;
                    }
                }
                Renderer.lightSector(feature, lightColours.get(col1), lightColours.get(col2), radius, s1, s2, dir, str);
            }
        }
    }

    static {
        lightColours.put(S57val.ColCOL.COL_WHT, new Color(0xFFFF00));
        lightColours.put(S57val.ColCOL.COL_RED, new Color(0xFF0000));
        lightColours.put(S57val.ColCOL.COL_GRN, new Color(65280));
        lightColours.put(S57val.ColCOL.COL_BLU, new Color(255));
        lightColours.put(S57val.ColCOL.COL_YEL, new Color(0xFFFF00));
        lightColours.put(S57val.ColCOL.COL_AMB, new Color(0xFBF00F));
        lightColours.put(S57val.ColCOL.COL_VIO, new Color(0xEE82EE));
        lightColours.put(S57val.ColCOL.COL_ORG, Color.orange);
        lightColours.put(S57val.ColCOL.COL_MAG, Color.magenta);
        lightLetters = new EnumMap(S57val.ColCOL.class);
        lightLetters.put(S57val.ColCOL.COL_WHT, "W");
        lightLetters.put(S57val.ColCOL.COL_RED, "R");
        lightLetters.put(S57val.ColCOL.COL_GRN, "G");
        lightLetters.put(S57val.ColCOL.COL_BLU, "Bu");
        lightLetters.put(S57val.ColCOL.COL_YEL, "Y");
        lightLetters.put(S57val.ColCOL.COL_AMB, "Am");
        lightLetters.put(S57val.ColCOL.COL_VIO, "Vi");
        lightLetters.put(S57val.ColCOL.COL_ORG, "Or");
        lightCharacters = new EnumMap(S57val.LitCHR.class);
        lightCharacters.put(S57val.LitCHR.CHR_F, "W");
        lightCharacters.put(S57val.LitCHR.CHR_FL, "Fl");
        lightCharacters.put(S57val.LitCHR.CHR_LFL, "LFl");
        lightCharacters.put(S57val.LitCHR.CHR_Q, "Q");
        lightCharacters.put(S57val.LitCHR.CHR_VQ, "VQ");
        lightCharacters.put(S57val.LitCHR.CHR_UQ, "UQ");
        lightCharacters.put(S57val.LitCHR.CHR_ISO, "Iso");
        lightCharacters.put(S57val.LitCHR.CHR_OC, "Oc");
        lightCharacters.put(S57val.LitCHR.CHR_IQ, "IQ");
        lightCharacters.put(S57val.LitCHR.CHR_IVQ, "IVQ");
        lightCharacters.put(S57val.LitCHR.CHR_IUQ, "IUQ");
        lightCharacters.put(S57val.LitCHR.CHR_MO, "Mo");
        lightCharacters.put(S57val.LitCHR.CHR_FFL, "FFl");
        lightCharacters.put(S57val.LitCHR.CHR_FLLFL, "FlLFl");
        lightCharacters.put(S57val.LitCHR.CHR_OCFL, "OcFl");
        lightCharacters.put(S57val.LitCHR.CHR_FLFL, "FLFl");
        lightCharacters.put(S57val.LitCHR.CHR_ALOC, "Al.Oc");
        lightCharacters.put(S57val.LitCHR.CHR_ALLFL, "Al.LFl");
        lightCharacters.put(S57val.LitCHR.CHR_ALFL, "Al.Fl");
        lightCharacters.put(S57val.LitCHR.CHR_ALGR, "Al.Gr");
        lightCharacters.put(S57val.LitCHR.CHR_QLFL, "Q+LFl");
        lightCharacters.put(S57val.LitCHR.CHR_VQLFL, "VQ+LFl");
        lightCharacters.put(S57val.LitCHR.CHR_UQLFL, "UQ+LFl");
        lightCharacters.put(S57val.LitCHR.CHR_AL, "Al");
        lightCharacters.put(S57val.LitCHR.CHR_ALFFL, "Al.FFl");
        fogSignals = new EnumMap(S57val.CatFOG.class);
        fogSignals.put(S57val.CatFOG.FOG_EXPL, "Explos");
        fogSignals.put(S57val.CatFOG.FOG_DIA, "Dia");
        fogSignals.put(S57val.CatFOG.FOG_SIRN, "Siren");
        fogSignals.put(S57val.CatFOG.FOG_NAUT, "Horn");
        fogSignals.put(S57val.CatFOG.FOG_REED, "Horn");
        fogSignals.put(S57val.CatFOG.FOG_TYPH, "Horn");
        fogSignals.put(S57val.CatFOG.FOG_BELL, "Bell");
        fogSignals.put(S57val.CatFOG.FOG_WHIS, "Whis");
        fogSignals.put(S57val.CatFOG.FOG_GONG, "Gong");
        fogSignals.put(S57val.CatFOG.FOG_HORN, "Horn");
    }
}

