/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import render.Renderer;
import render.Signals;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;
import symbols.Areas;
import symbols.Beacons;
import symbols.Buoys;
import symbols.Facilities;
import symbols.Harbours;
import symbols.Landmarks;
import symbols.Notices;
import symbols.Symbols;
import symbols.Topmarks;

public class Rules {
    public static final Color Yland = new Color(5288191);
    public static final Color Mline = new Color(12878079);
    public static final Color Msymb = new Color(10682485);
    static final EnumMap<S57val.ColCOL, Color> bodyColours = new EnumMap(S57val.ColCOL.class);
    static final EnumMap<S57val.ColPAT, Symbols.Patt> pattMap;

    static String getName(S57map.Feature feature) {
        S57map.AttMap atts;
        S57val.AttVal name = (S57val.AttVal)feature.atts.get((Object)S57att.Att.OBJNAM);
        if (name == null && (atts = (S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)feature.type)).get(0)) != null) {
            name = (S57val.AttVal)atts.get((Object)S57att.Att.OBJNAM);
        }
        return name != null ? (String)name.val : null;
    }

    public static void addName(S57map.Feature feature, int z, Font font) {
        Rules.addName(feature, z, font, Color.black, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
    }

    public static void addName(S57map.Feature feature, int z, Font font, Color colour) {
        Rules.addName(feature, z, font, colour, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
    }

    public static void addName(S57map.Feature feature, int z, Font font, Symbols.Delta delta) {
        Rules.addName(feature, z, font, Color.black, delta);
    }

    public static void addName(S57map.Feature feature, int z, Font font, Color colour, Symbols.Delta delta) {
        String name;
        if (Renderer.zoom >= z && (name = Rules.getName(feature)) != null) {
            Renderer.labelText(feature, name, font, colour, delta);
        }
    }

    static S57map.AttMap getAtts(S57map.Feature feature, S57obj.Obj obj, int idx) {
        HashMap objs = (HashMap)feature.objs.get((Object)obj);
        if (objs == null) {
            return null;
        }
        return (S57map.AttMap)objs.get(idx);
    }

    public static Object getAttVal(S57map.Feature feature, S57obj.Obj obj, int idx, S57att.Att att) {
        HashMap atts = null;
        HashMap objs = (HashMap)feature.objs.get((Object)obj);
        if (objs != null) {
            atts = (S57map.AttMap)objs.get(idx);
        }
        if (atts == null) {
            return S57val.nullVal(att);
        }
        S57val.AttVal item = (S57val.AttVal)atts.get((Object)att);
        if (item == null) {
            return S57val.nullVal(att);
        }
        return item.val;
    }

    static Symbols.Scheme getScheme(S57map.Feature feature, S57obj.Obj obj) {
        ArrayList<Color> colours = new ArrayList<Color>();
        for (S57val.ColCOL col : (ArrayList)Rules.getAttVal(feature, obj, 0, S57att.Att.COLOUR)) {
            colours.add(bodyColours.get((Object)col));
        }
        ArrayList<Symbols.Patt> patterns = new ArrayList<Symbols.Patt>();
        for (S57val.ColPAT pat : (ArrayList)Rules.getAttVal(feature, obj, 0, S57att.Att.COLPAT)) {
            patterns.add(pattMap.get((Object)pat));
        }
        return new Symbols.Scheme(patterns, colours);
    }

    static boolean testAttribute(S57map.Feature feature, S57obj.Obj obj, int idx, S57att.Att att, Object val) {
        S57val.AttVal item;
        S57map.AttMap atts = Rules.getAtts(feature, obj, idx);
        if (atts != null && (item = (S57val.AttVal)atts.get((Object)att)) != null) {
            switch (item.conv) {
                case S: 
                case A: {
                    return ((String)item.val).equals(val);
                }
                case L: {
                    return ((ArrayList)item.val).contains(val);
                }
                case E: 
                case F: 
                case I: {
                    return item.val.equals(val);
                }
            }
        }
        return false;
    }

    public static void rules() {
        ArrayList objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SLCONS);
        if (objects != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.shoreline(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.PIPSOL)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.pipelines(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.CBLSUB)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.cables(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.PIPOHD)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.pipelines(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.CBLOHD)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.cables(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.TSEZNE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.TSSCRS)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.TSSRON)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.TSELNE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.TSSLPT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.TSSBND)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.ISTZNE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.separation(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SNDWAV)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.OSPARE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.FAIRWY)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.DRGARE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.RESARE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SPLARE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SEAARE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.OBSTRN)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.obstructions(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.UWTROC)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.obstructions(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.MARCUL)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.areas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.WTWAXS)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.waterways(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.RECTRC)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.transits(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.NAVLNE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.transits(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.HRBFAC)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.harbours(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.ACHARE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.harbours(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.ACHBRT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.harbours(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BERTHS)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.harbours(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LOKBSN)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.locks(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LKBSPT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.locks(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.GATCON)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.locks(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.DISMAR)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.distances(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.HULKES)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.ports(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.CRANES)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.ports(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LNDMRK)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.landmarks(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BUISGL)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.harbours(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.MORFAC)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.moorings(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.NOTMRK)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.notices(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SMCFAC)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.marinas(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BRIDGE)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.bridges(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.PILPNT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.lights(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LITMIN)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.lights(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LITMAJ)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.lights(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LIGHTS)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.lights(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SISTAT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.SISTAW)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.CGUSTA)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.RDOSTA)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.RADSTA)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.RSCSTA)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.PILBOP)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.stations(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.WTWGAG)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.gauges(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.OFSPLF)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.platforms(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.WRECKS)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.wrecks(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LITVES)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.floats(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.LITFLT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.floats(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYINB)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.floats(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYLAT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.buoys(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYCAR)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.buoys(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYISD)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.buoys(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYSAW)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.buoys(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYSPP)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.buoys(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BOYWTW)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.buoys(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BCNLAT)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.beacons(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BCNCAR)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.beacons(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BCNISD)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.beacons(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BCNSAW)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.beacons(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BCNSPP)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.beacons(feature);
            }
        }
        if ((objects = (ArrayList)Renderer.map.features.get((Object)S57obj.Obj.BCNWTW)) != null) {
            for (S57map.Feature feature : objects) {
                if (feature.reln != S57map.Rflag.MASTER) continue;
                Rules.beacons(feature);
            }
        }
    }

    private static void areas(S57map.Feature feature) {
        String name = Rules.getName(feature);
        block0 : switch (feature.type) {
            case DRGARE: {
                if (Renderer.zoom < 16) {
                    Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 8.0f, new float[]{25.0f, 25.0f}, new Color(0x40FFFFFF, true)));
                } else {
                    Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 8.0f, new float[]{25.0f, 25.0f}));
                }
                Rules.addName(feature, 12, new Font("Arial", 0, 100), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                break;
            }
            case FAIRWY: {
                if (feature.geom.area > 2.0) {
                    if (Renderer.zoom < 16) {
                        Renderer.lineVector(feature, new Symbols.LineStyle(Mline, 8.0f, new float[]{50.0f, 50.0f}, new Color(0x40FFFFFF, true)));
                        break;
                    }
                    Renderer.lineVector(feature, new Symbols.LineStyle(Mline, 8.0f, new float[]{50.0f, 50.0f}));
                    break;
                }
                if (Renderer.zoom < 14) break;
                Renderer.lineVector(feature, new Symbols.LineStyle(null, 0.0f, new Color(0x40FFFFFF, true)));
                break;
            }
            case MARCUL: {
                if (Renderer.zoom < 12) break;
                if (Renderer.zoom >= 14) {
                    Renderer.symbol(feature, Areas.MarineFarm);
                }
                if (!(feature.geom.area > 0.2 || feature.geom.area > 0.05 && Renderer.zoom >= 14) && (!(feature.geom.area > 0.005) || Renderer.zoom < 16)) break;
                Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 4.0f, new float[]{10.0f, 10.0f}));
                break;
            }
            case OSPARE: {
                if (!Rules.testAttribute(feature, feature.type, 0, S57att.Att.CATPRA, (Object)S57val.CatPRA.PRA_WFRM)) break;
                Renderer.symbol(feature, Areas.WindFarm);
                Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 20.0f, new float[]{40.0f, 40.0f}));
                Rules.addName(feature, 15, new Font("Arial", 1, 80), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 10.0)));
                break;
            }
            case RESARE: 
            case MIPARE: {
                if (Renderer.zoom < 12) break;
                Renderer.lineSymbols(feature, Areas.Restricted, 1.0, null, null, 0, Mline);
                if (!Rules.testAttribute(feature, feature.type, 0, S57att.Att.CATREA, (Object)S57val.CatREA.REA_NWAK)) break;
                Renderer.symbol(feature, Areas.NoWake);
                break;
            }
            case SEAARE: {
                switch ((S57val.CatSEA)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATSEA))) {
                    case SEA_RECH: {
                        if (Renderer.zoom < 10 || name == null) break block0;
                        if (feature.geom.prim == S57map.Pflag.LINE) {
                            Renderer.lineText(feature, name, new Font("Arial", 0, 150), Color.black, 0.5, -40.0);
                            break block0;
                        }
                        Renderer.labelText(feature, name, new Font("Arial", 0, 150), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -40.0)));
                        break block0;
                    }
                    case SEA_BAY: {
                        if (Renderer.zoom < 12 || name == null) break block0;
                        if (feature.geom.prim == S57map.Pflag.LINE) {
                            Renderer.lineText(feature, name, new Font("Arial", 0, 150), Color.black, 0.5, -40.0);
                            break block0;
                        }
                        Renderer.labelText(feature, name, new Font("Arial", 0, 150), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -40.0)));
                        break block0;
                    }
                    case SEA_SHOL: {
                        if (Renderer.zoom < 14) break block0;
                        if (feature.geom.prim == S57map.Pflag.AREA) {
                            Renderer.lineVector(feature, new Symbols.LineStyle(new Color(12878079), 4.0f, new float[]{25.0f, 25.0f}));
                            if (name == null) break block0;
                            Renderer.labelText(feature, name, new Font("Arial", 2, 75), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -40.0)));
                            Renderer.labelText(feature, "(Shoal)", new Font("Arial", 0, 60), Color.black, new Symbols.Delta(Symbols.Handle.BC));
                            break block0;
                        }
                        if (feature.geom.prim == S57map.Pflag.LINE) {
                            if (name == null) break block0;
                            Renderer.lineText(feature, name, new Font("Arial", 2, 75), Color.black, 0.5, -40.0);
                            Renderer.lineText(feature, "(Shoal)", new Font("Arial", 0, 60), Color.black, 0.5, 0.0);
                            break block0;
                        }
                        if (name == null) break block0;
                        Renderer.labelText(feature, name, new Font("Arial", 2, 75), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -40.0)));
                        Renderer.labelText(feature, "(Shoal)", new Font("Arial", 0, 60), Color.black, new Symbols.Delta(Symbols.Handle.BC));
                        break block0;
                    }
                    case SEA_GAT: 
                    case SEA_NRRW: {
                        Rules.addName(feature, 12, new Font("Arial", 0, 100));
                        break block0;
                    }
                }
                break;
            }
            case SNDWAV: {
                if (Renderer.zoom < 12) break;
                Renderer.fillPattern(feature, Areas.Sandwaves);
                break;
            }
            case SPLARE: {
                if (Renderer.zoom >= 12) {
                    Renderer.symbol(feature, Areas.Plane, new Symbols.Scheme(Msymb));
                    Renderer.lineSymbols(feature, Areas.Restricted, 0.5, Areas.LinePlane, null, 10, Mline);
                }
                Rules.addName(feature, 15, new Font("Arial", 1, 80), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -90.0)));
                break;
            }
        }
    }

    private static void beacons(S57map.Feature feature) {
        if (Renderer.zoom >= 14 || Renderer.zoom >= 12 && (feature.type == S57obj.Obj.BCNLAT || feature.type == S57obj.Obj.BCNCAR)) {
            S57val.BcnSHP shape = (S57val.BcnSHP)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.BCNSHP));
            if (shape == S57val.BcnSHP.BCN_WTHY && feature.type == S57obj.Obj.BCNLAT) {
                S57val.CatLAM cat = (S57val.CatLAM)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATLAM));
                switch (cat) {
                    case LAM_PORT: {
                        Renderer.symbol(feature, Beacons.WithyPort);
                        break;
                    }
                    case LAM_STBD: {
                        Renderer.symbol(feature, Beacons.WithyStarboard);
                        break;
                    }
                    default: {
                        Renderer.symbol(feature, Beacons.Stake, Rules.getScheme(feature, feature.type));
                        break;
                    }
                }
            } else if (shape == S57val.BcnSHP.BCN_PRCH && feature.type == S57obj.Obj.BCNLAT && !feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                S57val.CatLAM cat = (S57val.CatLAM)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATLAM));
                switch (cat) {
                    case LAM_PORT: {
                        Renderer.symbol(feature, Beacons.PerchPort);
                        break;
                    }
                    case LAM_STBD: {
                        Renderer.symbol(feature, Beacons.PerchStarboard);
                        break;
                    }
                    default: {
                        Renderer.symbol(feature, Beacons.Stake, Rules.getScheme(feature, feature.type));
                        break;
                    }
                }
            } else {
                Symbols.Symbol topmark;
                Renderer.symbol(feature, Beacons.Shapes.get((Object)shape), Rules.getScheme(feature, feature.type));
                if (feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                    Symbols.Symbol topmark2 = Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.TOPMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val);
                    if (topmark2 != null) {
                        Renderer.symbol(feature, Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.TOPMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val), Rules.getScheme(feature, S57obj.Obj.TOPMAR), Topmarks.BeaconDelta);
                    }
                } else if (feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmark = Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.DAYMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val)) != null) {
                    Renderer.symbol(feature, Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.DAYMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val), Rules.getScheme(feature, S57obj.Obj.DAYMAR), Topmarks.BeaconDelta);
                }
            }
            Signals.addSignals(feature);
        }
    }

    private static void buoys(S57map.Feature feature) {
        if (Renderer.zoom >= 14 || Renderer.zoom >= 12 && (feature.type == S57obj.Obj.BOYLAT || feature.type == S57obj.Obj.BOYCAR)) {
            Symbols.Symbol topmark;
            S57val.BoySHP shape = (S57val.BoySHP)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.BOYSHP));
            Renderer.symbol(feature, Buoys.Shapes.get((Object)shape), Rules.getScheme(feature, feature.type));
            if (feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                Symbols.Symbol topmark2 = Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.TOPMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val);
                if (topmark2 != null) {
                    Renderer.symbol(feature, topmark2, Rules.getScheme(feature, S57obj.Obj.TOPMAR), Topmarks.BuoyDeltas.get((Object)shape));
                }
            } else if (feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmark = Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.DAYMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val)) != null) {
                Renderer.symbol(feature, topmark, Rules.getScheme(feature, S57obj.Obj.DAYMAR), Topmarks.BuoyDeltas.get((Object)shape));
            }
            Signals.addSignals(feature);
        }
    }

    private static void bridges(S57map.Feature feature) {
        if (Renderer.zoom >= 16) {
            S57map.AttMap atts = (S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)S57obj.Obj.BRIDGE)).get(0);
            String vstr = "";
            String hstr = "";
            if (atts != null) {
                double vercop;
                if (atts.containsKey((Object)S57att.Att.HORCLR)) {
                    double horclr = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.HORCLR))).val;
                    hstr = String.valueOf(horclr);
                }
                double verclr = atts.containsKey((Object)S57att.Att.VERCLR) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCLR))).val : (atts.containsKey((Object)S57att.Att.VERCSA) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCSA))).val : 0.0);
                double verccl = atts.containsKey((Object)S57att.Att.VERCCL) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCCL))).val : 0.0;
                double d = vercop = atts.containsKey((Object)S57att.Att.VERCOP) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCOP))).val : 0.0;
                if (verclr > 0.0) {
                    vstr = vstr + String.valueOf(verclr);
                } else if (verccl > 0.0) {
                    vstr = vercop == 0.0 ? vstr + String.valueOf(verccl) + "/-" : vstr + String.valueOf(verccl) + "/" + String.valueOf(vercop);
                }
                if (hstr.isEmpty() && !vstr.isEmpty()) {
                    Renderer.labelText(feature, vstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.VCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.CC));
                } else if (!hstr.isEmpty() && !vstr.isEmpty()) {
                    Renderer.labelText(feature, vstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.VCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.BC));
                    Renderer.labelText(feature, hstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.HCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.TC));
                } else if (!hstr.isEmpty() && vstr.isEmpty()) {
                    Renderer.labelText(feature, hstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.HCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.CC));
                }
            }
        }
    }

    private static void cables(S57map.Feature feature) {
        if (Renderer.zoom >= 16 && feature.geom.length < 2.0) {
            if (feature.type == S57obj.Obj.CBLSUB) {
                Renderer.lineSymbols(feature, Areas.Cable, 0.0, null, null, 0, Mline);
            } else if (feature.type == S57obj.Obj.CBLOHD) {
                S57map.AttMap atts = (S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)S57obj.Obj.CBLOHD)).get(0);
                if (atts != null && atts.containsKey((Object)S57att.Att.CATCBL) && ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATCBL))).val == S57val.CatCBL.CBL_POWR) {
                    Renderer.lineSymbols(feature, Areas.CableDash, 0.0, Areas.CableDot, Areas.CableFlash, 2, Color.black);
                } else {
                    Renderer.lineSymbols(feature, Areas.CableDash, 0.0, Areas.CableDot, null, 2, Color.black);
                }
                if (atts != null) {
                    if (atts.containsKey((Object)S57att.Att.VERCLR)) {
                        Renderer.labelText(feature, String.valueOf((Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCLR))).val), new Font("Arial", 0, 50), Color.black, Renderer.LabelStyle.VCLR, Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 25.0)));
                    } else if (atts.containsKey((Object)S57att.Att.VERCSA)) {
                        Renderer.labelText(feature, String.valueOf((Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCSA))).val), new Font("Arial", 0, 50), Color.black, Renderer.LabelStyle.PCLR, Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 25.0)));
                    }
                }
            }
        }
    }

    private static void distances(S57map.Feature feature) {
        if (Renderer.zoom >= 14) {
            S57map.AttMap atts;
            if (!Rules.testAttribute(feature, S57obj.Obj.DISMAR, 0, S57att.Att.CATDIS, (Object)S57val.CatDIS.DIS_NONI)) {
                Renderer.symbol(feature, Harbours.DistanceI);
            } else {
                Renderer.symbol(feature, Harbours.DistanceU);
            }
            if (Renderer.zoom >= 15 && (atts = Rules.getAtts(feature, S57obj.Obj.DISMAR, 0)) != null && atts.containsKey((Object)S57att.Att.WTWDIS)) {
                Double dist = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.WTWDIS))).val;
                String str = "";
                if (atts.containsKey((Object)S57att.Att.HUNITS)) {
                    switch ((S57val.UniHLU)((Object)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.HUNITS))).val)) {
                        case HLU_METR: {
                            str = str + "m ";
                            break;
                        }
                        case HLU_FEET: {
                            str = str + "ft ";
                            break;
                        }
                        case HLU_HMTR: {
                            str = str + "hm ";
                            break;
                        }
                        case HLU_KMTR: {
                            str = str + "km ";
                            break;
                        }
                        case HLU_SMIL: {
                            str = str + "M ";
                            break;
                        }
                        case HLU_NMIL: {
                            str = str + "NM ";
                            break;
                        }
                    }
                }
                str = str + String.format("%1.0f", dist);
                Renderer.labelText(feature, str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(0.0, 45.0)));
            }
        }
    }

    private static void floats(S57map.Feature feature) {
        switch (feature.type) {
            case LITVES: {
                Renderer.symbol(feature, Buoys.Super, Rules.getScheme(feature, feature.type));
                break;
            }
            case LITFLT: {
                Renderer.symbol(feature, Buoys.Float, Rules.getScheme(feature, feature.type));
                break;
            }
            case BOYINB: {
                Renderer.symbol(feature, Buoys.Super, Rules.getScheme(feature, feature.type));
                break;
            }
        }
        if (feature.objs.get((Object)S57obj.Obj.TOPMAR) != null) {
            Renderer.symbol(feature, Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.TOPMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val), Rules.getScheme(feature, S57obj.Obj.TOPMAR), Topmarks.FloatDelta);
        }
        Signals.addSignals(feature);
    }

    private static void gauges(S57map.Feature feature) {
        if (Renderer.zoom >= 14) {
            Renderer.symbol(feature, Harbours.TideGauge);
            Signals.addSignals(feature);
        }
    }

    private static void harbours(S57map.Feature feature) {
        String name = Rules.getName(feature);
        block0 : switch (feature.type) {
            case ACHBRT: {
                double radius;
                if (Renderer.zoom >= 14) {
                    Renderer.symbol(feature, Harbours.Anchorage, new Symbols.Scheme(Mline));
                    if (Renderer.zoom >= 15) {
                        Renderer.labelText(feature, name == null ? "" : name, new Font("Arial", 0, 30), Msymb, Renderer.LabelStyle.RRCT, Mline, Color.white, new Symbols.Delta(Symbols.Handle.BC));
                    }
                }
                if ((radius = ((Double)Rules.getAttVal(feature, S57obj.Obj.ACHBRT, 0, S57att.Att.RADIUS)).doubleValue()) == 0.0) break;
                S57val.UniHLU units = (S57val.UniHLU)((Object)Rules.getAttVal(feature, S57obj.Obj.ACHBRT, 0, S57att.Att.HUNITS));
                Renderer.lineCircle(feature, new Symbols.LineStyle(Mline, 4.0f, new float[]{10.0f, 10.0f}, null), radius, units);
                break;
            }
            case ACHARE: {
                if (Renderer.zoom >= 12) {
                    if (feature.geom.prim != S57map.Pflag.AREA) {
                        Renderer.symbol(feature, Harbours.Anchorage, new Symbols.Scheme(Color.black));
                    } else {
                        Renderer.symbol(feature, Harbours.Anchorage, new Symbols.Scheme(Mline));
                        Renderer.lineSymbols(feature, Areas.Restricted, 1.0, Areas.LineAnchor, null, 10, Mline);
                    }
                    Rules.addName(feature, 15, new Font("Arial", 1, 60), Mline, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(70.0, 0.0)));
                    ArrayList sts = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.ACHARE, 0, S57att.Att.STATUS);
                    if (Renderer.zoom >= 15 && sts != null && sts.contains((Object)S57val.StsSTS.STS_RESV)) {
                        Renderer.labelText(feature, "Reserved", new Font("Arial", 0, 50), Mline, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 60.0)));
                    }
                }
                ArrayList cats = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.ACHARE, 0, S57att.Att.CATACH);
                int dy = (cats.size() - 1) * -30;
                for (S57val.CatACH cat : cats) {
                    switch (cat) {
                        case ACH_DEEP: {
                            Renderer.labelText(feature, "DW", new Font("Arial", 1, 50), Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_TANK: {
                            Renderer.labelText(feature, "Tanker", new Font("Arial", 1, 50), Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_H24P: {
                            Renderer.labelText(feature, "24h", new Font("Arial", 1, 50), Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_EXPL: {
                            Renderer.symbol(feature, Harbours.Explosives, new Symbols.Scheme(Msymb), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_QUAR: {
                            Renderer.symbol(feature, Harbours.Hospital, new Symbols.Scheme(Msymb), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_SEAP: {
                            Renderer.symbol(feature, Areas.Seaplane, new Symbols.Scheme(Msymb), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                    }
                }
                break;
            }
            case BERTHS: {
                if (Renderer.zoom < 14) break;
                Renderer.lineVector(feature, new Symbols.LineStyle(Mline, 6.0f, new float[]{20.0f, 20.0f}));
                Renderer.labelText(feature, name == null ? " " : name, new Font("Arial", 0, 40), Msymb, Renderer.LabelStyle.RRCT, Mline, Color.white);
                break;
            }
            case BUISGL: {
                if (Renderer.zoom < 16) break;
                ArrayList<Symbols.Symbol> symbols = new ArrayList<Symbols.Symbol>();
                ArrayList fncs = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.BUISGL, 0, S57att.Att.FUNCTN);
                for (S57val.FncFNC fnc : fncs) {
                    symbols.add(Landmarks.Funcs.get((Object)fnc));
                }
                if (feature.objs.containsKey((Object)S57obj.Obj.SMCFAC)) {
                    ArrayList scfs = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.SMCFAC, 0, S57att.Att.CATSCF);
                    for (S57val.CatSCF scf : scfs) {
                        symbols.add(Facilities.Cats.get((Object)scf));
                    }
                }
                Renderer.cluster(feature, symbols);
                break;
            }
            case HRBFAC: {
                if (Renderer.zoom < 12) break;
                ArrayList cathaf = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.HRBFAC, 0, S57att.Att.CATHAF);
                if (cathaf.size() == 1) {
                    switch ((S57val.CatHAF)((Object)cathaf.get(0))) {
                        case HAF_MRNA: {
                            Renderer.symbol(feature, Harbours.Marina);
                            break block0;
                        }
                        case HAF_MANF: {
                            Renderer.symbol(feature, Harbours.MarinaNF);
                            break block0;
                        }
                        case HAF_FISH: {
                            Renderer.symbol(feature, Harbours.Fishing);
                            break block0;
                        }
                    }
                    Renderer.symbol(feature, Harbours.Harbour);
                    break;
                }
                Renderer.symbol(feature, Harbours.Harbour);
                break;
            }
        }
    }

    private static void landmarks(S57map.Feature feature) {
        ArrayList cats = (ArrayList)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATLMK);
        Symbols.Symbol catSym = Landmarks.Shapes.get(cats.get(0));
        ArrayList fncs = (ArrayList)Rules.getAttVal(feature, feature.type, 0, S57att.Att.FUNCTN);
        Symbols.Symbol fncSym = Landmarks.Funcs.get(fncs.get(0));
        if (fncs.get(0) == S57val.FncFNC.FNC_CHCH && cats.get(0) == S57val.CatLMK.LMK_TOWR) {
            catSym = Landmarks.ChurchTower;
        }
        if (cats.get(0) == S57val.CatLMK.LMK_UNKN && fncs.get(0) == S57val.FncFNC.FNC_UNKN && feature.objs.get((Object)S57obj.Obj.LIGHTS) != null) {
            catSym = Beacons.LightMajor;
        }
        if (cats.get(0) == S57val.CatLMK.LMK_RADR) {
            fncSym = Landmarks.RadioTV;
        }
        Renderer.symbol(feature, catSym);
        Renderer.symbol(feature, fncSym);
        Rules.addName(feature, 15, new Font("Arial", 1, 80), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(60.0, -50.0)));
        Signals.addSignals(feature);
    }

    private static void lights(S57map.Feature feature) {
        Symbols.Symbol topmark;
        switch (feature.type) {
            case LITMAJ: {
                Renderer.symbol(feature, Beacons.LightMajor);
                break;
            }
            case LITMIN: 
            case LIGHTS: {
                Renderer.symbol(feature, Beacons.LightMinor);
                break;
            }
            case PILPNT: {
                if (feature.objs.containsKey((Object)S57obj.Obj.LIGHTS)) {
                    Renderer.symbol(feature, Beacons.LightMinor);
                    break;
                }
                Renderer.symbol(feature, Harbours.Post);
                break;
            }
        }
        if (feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
            Symbols.Symbol topmark2 = Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.TOPMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val);
            if (topmark2 != null) {
                Renderer.symbol(feature, Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.TOPMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val), Rules.getScheme(feature, S57obj.Obj.TOPMAR), Topmarks.LightDelta);
            }
        } else if (feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmark = Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.DAYMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val)) != null) {
            Renderer.symbol(feature, Topmarks.Shapes.get(((S57val.AttVal)((S57map.AttMap)((S57map.ObjTab)feature.objs.get((Object)((Object)S57obj.Obj.DAYMAR))).get((Object)Integer.valueOf((int)0))).get((Object)((Object)S57att.Att.TOPSHP))).val), Rules.getScheme(feature, S57obj.Obj.DAYMAR), Topmarks.LightDelta);
        }
        Signals.addSignals(feature);
    }

    private static void locks(S57map.Feature feature) {
    }

    private static void marinas(S57map.Feature feature) {
        if (Renderer.zoom >= 16) {
            ArrayList<Symbols.Symbol> symbols = new ArrayList<Symbols.Symbol>();
            ArrayList scfs = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.SMCFAC, 0, S57att.Att.CATSCF);
            for (S57val.CatSCF scf : scfs) {
                symbols.add(Facilities.Cats.get((Object)scf));
            }
            Renderer.cluster(feature, symbols);
        }
    }

    private static void moorings(S57map.Feature feature) {
        switch ((S57val.CatMOR)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATMOR))) {
            case MOR_DLPN: {
                Renderer.symbol(feature, Harbours.Dolphin);
                break;
            }
            case MOR_DDPN: {
                Renderer.symbol(feature, Harbours.DeviationDolphin);
                break;
            }
            case MOR_BLRD: 
            case MOR_POST: {
                Renderer.symbol(feature, Harbours.Bollard);
                break;
            }
            case MOR_BUOY: {
                S57val.BoySHP shape = (S57val.BoySHP)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.BOYSHP));
                if (shape == S57val.BoySHP.BOY_UNKN) {
                    shape = S57val.BoySHP.BOY_SPHR;
                }
                Renderer.symbol(feature, Buoys.Shapes.get((Object)shape), Rules.getScheme(feature, feature.type));
                Renderer.symbol(feature, Topmarks.TopMooring, Topmarks.BuoyDeltas.get((Object)shape));
            }
        }
        Signals.addSignals(feature);
    }

    private static void notices(S57map.Feature feature) {
        if (Renderer.zoom >= 14) {
            S57map.ObjTab objs;
            int n;
            double dx = 0.0;
            double dy = 0.0;
            switch (feature.type) {
                case BCNCAR: 
                case BCNISD: 
                case BCNLAT: 
                case BCNSAW: 
                case BCNSPP: 
                case BCNWTW: {
                    dy = 45.0;
                    break;
                }
                case NOTMRK: {
                    dy = 0.0;
                    break;
                }
                default: {
                    return;
                }
            }
            Symbols.Symbol s1 = null;
            Symbols.Symbol s2 = null;
            S57val.MarSYS sys = S57val.MarSYS.SYS_CEVN;
            S57val.BnkWTW bnk = S57val.BnkWTW.BWW_UNKN;
            S57val.AttVal att = (S57val.AttVal)feature.atts.get((Object)S57att.Att.MARSYS);
            if (att != null) {
                sys = (S57val.MarSYS)((Object)att.val);
            }
            if ((n = (objs = (S57map.ObjTab)feature.objs.get((Object)S57obj.Obj.NOTMRK)).size()) > 2) {
                s1 = Notices.Notice;
                n = 1;
            } else {
                for (S57map.AttMap atts : objs.values()) {
                    if (atts.get((Object)S57att.Att.MARSYS) != null) {
                        sys = (S57val.MarSYS)((Object)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.MARSYS))).val);
                    }
                    S57val.CatNMK cat = S57val.CatNMK.NMK_UNKN;
                    if (atts.get((Object)S57att.Att.CATNMK) != null) {
                        cat = (S57val.CatNMK)((Object)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATNMK))).val);
                    }
                    s2 = Notices.getNotice(cat, sys);
                }
            }
        }
    }

    private static void obstructions(S57map.Feature feature) {
        if (Renderer.zoom >= 12 && feature.type == S57obj.Obj.OBSTRN) {
            switch ((S57val.CatOBS)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATOBS))) {
                case OBS_BOOM: {
                    Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 5.0f, new float[]{20.0f, 20.0f}, null));
                    if (Renderer.zoom < 15) break;
                    Renderer.lineText(feature, "Boom", new Font("Arial", 0, 80), Color.black, 0.5, -20.0);
                }
            }
        }
        if (Renderer.zoom >= 14 && feature.type == S57obj.Obj.UWTROC) {
            S57val.WatLEV lvl = (S57val.WatLEV)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.WATLEV));
            switch (lvl) {
                case LEV_CVRS: {
                    Renderer.symbol(feature, Areas.RockC);
                    break;
                }
                case LEV_AWSH: {
                    Renderer.symbol(feature, Areas.RockA);
                    break;
                }
                default: {
                    Renderer.symbol(feature, Areas.Rock);
                    break;
                }
            }
        } else {
            Renderer.symbol(feature, Areas.Rock);
        }
    }

    private static void pipelines(S57map.Feature feature) {
        if (Renderer.zoom >= 16 && feature.geom.length < 2.0) {
            if (feature.type == S57obj.Obj.PIPSOL) {
                Renderer.lineSymbols(feature, Areas.Pipeline, 1.0, null, null, 0, Mline);
            } else if (feature.type == S57obj.Obj.PIPOHD) {
                Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 8.0f));
                S57map.AttMap atts = feature.atts;
                double verclr = 0.0;
                if (atts != null) {
                    if (atts.containsKey((Object)S57att.Att.VERCLR)) {
                        verclr = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCLR))).val;
                    } else {
                        double d = verclr = atts.containsKey((Object)S57att.Att.VERCSA) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCSA))).val : 0.0;
                    }
                    if (verclr > 0.0) {
                        Renderer.labelText(feature, String.valueOf(verclr), new Font("Arial", 0, 50), Color.black, Renderer.LabelStyle.VCLR, Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 25.0)));
                    }
                }
            }
        }
    }

    private static void platforms(S57map.Feature feature) {
        ArrayList cats = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.OFSPLF, 0, S57att.Att.CATOFP);
        if ((S57val.CatOFP)((Object)cats.get(0)) == S57val.CatOFP.OFP_FPSO) {
            Renderer.symbol(feature, Buoys.Storage);
        } else {
            Renderer.symbol(feature, Landmarks.Platform);
        }
        Rules.addName(feature, 15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(20.0, -50.0)));
        Signals.addSignals(feature);
    }

    private static void ports(S57map.Feature feature) {
        if (Renderer.zoom >= 14) {
            if (feature.type == S57obj.Obj.CRANES) {
                if ((S57val.CatCRN)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATCRN)) == S57val.CatCRN.CRN_CONT) {
                    Renderer.symbol(feature, Harbours.ContainerCrane);
                } else {
                    Renderer.symbol(feature, Harbours.PortCrane);
                }
            } else if (feature.type == S57obj.Obj.HULKES) {
                Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 4.0f, null, new Color(0xFFE000)));
                Rules.addName(feature, 15, new Font("Arial", 1, 80));
            }
        }
    }

    private static void separation(S57map.Feature feature) {
        switch (feature.type) {
            case TSEZNE: 
            case TSSCRS: 
            case TSSRON: {
                if (Renderer.zoom <= 15) {
                    Renderer.lineVector(feature, new Symbols.LineStyle(null, 0.0f, null, new Color(-2134605696, true)));
                } else {
                    Renderer.lineVector(feature, new Symbols.LineStyle(new Color(-2134605696, true), 20.0f, null, null));
                }
                Rules.addName(feature, 10, new Font("Arial", 1, 150), new Color(-2134605696, true));
                break;
            }
            case TSELNE: {
                Renderer.lineVector(feature, new Symbols.LineStyle(new Color(-2134605696, true), 20.0f, null, null));
                break;
            }
            case TSSLPT: {
                Renderer.lineSymbols(feature, Areas.LaneArrow, 0.5, null, null, 0, new Color(-2134605696, true));
                break;
            }
            case TSSBND: {
                Renderer.lineVector(feature, new Symbols.LineStyle(new Color(-2134605696, true), 20.0f, new float[]{40.0f, 40.0f}, null));
                break;
            }
            case ISTZNE: {
                Renderer.lineSymbols(feature, Areas.Restricted, 1.0, null, null, 0, new Color(-2134605696, true));
            }
        }
    }

    private static void shoreline(S57map.Feature feature) {
        if (Renderer.zoom >= 12) {
            switch ((S57val.CatSLC)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATSLC))) {
                case SLC_TWAL: {
                    S57val.WatLEV lev = (S57val.WatLEV)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.WATLEV));
                    if (lev == S57val.WatLEV.LEV_CVRS) {
                        Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 10.0f, new float[]{40.0f, 40.0f}, null));
                        if (Renderer.zoom >= 15) {
                            Renderer.lineText(feature, "(covers)", new Font("Arial", 0, 80), Color.black, 0.5, 80.0);
                        }
                    } else {
                        Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 10.0f, null, null));
                    }
                    if (Renderer.zoom < 15) break;
                    Renderer.lineText(feature, "Training Wall", new Font("Arial", 0, 80), Color.black, 0.5, -30.0);
                    break;
                }
                case SLC_SWAY: {
                    Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 2.0f, null, new Color(0xFFE000)));
                    if (Renderer.zoom < 16 || !feature.objs.containsKey((Object)S57obj.Obj.SMCFAC)) break;
                    ArrayList<Symbols.Symbol> symbols = new ArrayList<Symbols.Symbol>();
                    ArrayList scfs = (ArrayList)Rules.getAttVal(feature, S57obj.Obj.SMCFAC, 0, S57att.Att.CATSCF);
                    for (S57val.CatSCF scf : scfs) {
                        symbols.add(Facilities.Cats.get((Object)scf));
                    }
                    Renderer.cluster(feature, symbols);
                }
            }
        }
    }

    private static void stations(S57map.Feature feature) {
        if (Renderer.zoom >= 14) {
            String str = "";
            switch (feature.type) {
                case SISTAT: 
                case SISTAW: {
                    Renderer.symbol(feature, Harbours.SignalStation);
                    str = "SS";
                    break;
                }
                case RDOSTA: {
                    Renderer.symbol(feature, Harbours.SignalStation);
                    Renderer.symbol(feature, Beacons.RadarStation);
                    break;
                }
                case RADSTA: {
                    Renderer.symbol(feature, Harbours.SignalStation);
                    Renderer.symbol(feature, Beacons.RadarStation);
                    break;
                }
                case PILBOP: {
                    Renderer.symbol(feature, Harbours.Pilot);
                    break;
                }
                case CGUSTA: {
                    Renderer.symbol(feature, Harbours.SignalStation);
                    str = "CG";
                    break;
                }
                case RSCSTA: {
                    Renderer.symbol(feature, Harbours.Rescue);
                }
            }
            if (Renderer.zoom >= 15 && !str.isEmpty()) {
                Renderer.labelText(feature, str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(30.0, 0.0)));
            }
            Signals.addSignals(feature);
        }
    }

    private static void transits(S57map.Feature feature) {
        if (Renderer.zoom >= 12) {
            if (feature.type == S57obj.Obj.RECTRC) {
                Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 10.0f, null, null));
            } else if (feature.type == S57obj.Obj.NAVLNE) {
                Renderer.lineVector(feature, new Symbols.LineStyle(Color.black, 10.0f, new float[]{25.0f, 25.0f}, null));
            }
        }
        if (Renderer.zoom >= 15) {
            Double ort;
            String str = "";
            String name = Rules.getName(feature);
            if (name != null) {
                str = str + name + " ";
            }
            if ((ort = (Double)Rules.getAttVal(feature, feature.type, 0, S57att.Att.ORIENT)) != null) {
                str = str + ort.toString() + "\u0152";
            }
            if (!str.isEmpty()) {
                Renderer.lineText(feature, str, new Font("Arial", 0, 80), Color.black, 0.5, -20.0);
            }
        }
    }

    private static void waterways(S57map.Feature feature) {
    }

    private static void wrecks(S57map.Feature feature) {
        if (Renderer.zoom >= 14) {
            S57val.CatWRK cat = (S57val.CatWRK)((Object)Rules.getAttVal(feature, feature.type, 0, S57att.Att.CATWRK));
            switch (cat) {
                case WRK_DNGR: 
                case WRK_MSTS: {
                    Renderer.symbol(feature, Areas.WreckD);
                    break;
                }
                case WRK_HULS: {
                    Renderer.symbol(feature, Areas.WreckS);
                    break;
                }
                default: {
                    Renderer.symbol(feature, Areas.WreckND);
                }
            }
        }
    }

    static {
        bodyColours.put(S57val.ColCOL.COL_UNK, new Color(0, true));
        bodyColours.put(S57val.ColCOL.COL_WHT, new Color(0xFFFFFF));
        bodyColours.put(S57val.ColCOL.COL_BLK, new Color(0));
        bodyColours.put(S57val.ColCOL.COL_RED, new Color(0xD40000));
        bodyColours.put(S57val.ColCOL.COL_GRN, new Color(54272));
        bodyColours.put(S57val.ColCOL.COL_BLU, Color.blue);
        bodyColours.put(S57val.ColCOL.COL_YEL, new Color(16765952));
        bodyColours.put(S57val.ColCOL.COL_GRY, Color.gray);
        bodyColours.put(S57val.ColCOL.COL_BRN, new Color(9127187));
        bodyColours.put(S57val.ColCOL.COL_AMB, new Color(0xFBF00F));
        bodyColours.put(S57val.ColCOL.COL_VIO, new Color(0xEE82EE));
        bodyColours.put(S57val.ColCOL.COL_ORG, Color.orange);
        bodyColours.put(S57val.ColCOL.COL_MAG, new Color(0xF000F0));
        bodyColours.put(S57val.ColCOL.COL_PNK, Color.pink);
        pattMap = new EnumMap(S57val.ColPAT.class);
        pattMap.put(S57val.ColPAT.PAT_UNKN, Symbols.Patt.Z);
        pattMap.put(S57val.ColPAT.PAT_HORI, Symbols.Patt.H);
        pattMap.put(S57val.ColPAT.PAT_VERT, Symbols.Patt.V);
        pattMap.put(S57val.ColPAT.PAT_DIAG, Symbols.Patt.D);
        pattMap.put(S57val.ColPAT.PAT_BRDR, Symbols.Patt.B);
        pattMap.put(S57val.ColPAT.PAT_SQUR, Symbols.Patt.S);
        pattMap.put(S57val.ColPAT.PAT_CROS, Symbols.Patt.C);
        pattMap.put(S57val.ColPAT.PAT_SALT, Symbols.Patt.X);
        pattMap.put(S57val.ColPAT.PAT_STRP, Symbols.Patt.H);
    }
}

