/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import render.MapContext;
import render.Rules;
import s57.S57map;
import s57.S57val;
import symbols.Areas;
import symbols.Symbols;

public class Renderer {
    public static final double[] symbolScale = new double[]{256.0, 128.0, 64.0, 32.0, 16.0, 8.0, 4.0, 2.0, 1.0, 0.61, 0.372, 0.227, 0.138, 0.0843, 0.0514, 0.0313, 0.0191, 0.0117, 0.007};
    static MapContext context;
    static S57map map;
    static double sScale;
    static Graphics2D g2;
    static int zoom;

    public static void reRender(Graphics2D g, int z, double factor, S57map m, MapContext c) {
        g2 = g;
        zoom = z;
        context = c;
        map = m;
        sScale = symbolScale[zoom] * factor;
        if (map != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            g2.setStroke(new BasicStroke(0.0f, 0, 0));
            Rules.rules();
        }
    }

    public static void symbol(S57map.Feature feature, Symbols.Symbol symbol) {
        Point2D point = context.getPoint(feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), null, null);
    }

    public static void symbol(S57map.Feature feature, Symbols.Symbol symbol, Symbols.Scheme scheme) {
        Point2D point = context.getPoint(feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), scheme, null);
    }

    public static void symbol(S57map.Feature feature, Symbols.Symbol symbol, Symbols.Delta delta) {
        Point2D point = context.getPoint(feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), null, delta);
    }

    public static void symbol(S57map.Feature feature, Symbols.Symbol symbol, Symbols.Scheme scheme, Symbols.Delta delta) {
        Point2D point = context.getPoint(feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), scheme, delta);
    }

    public static void cluster(S57map.Feature feature, ArrayList<Symbols.Symbol> symbols) {
        Rectangle2D.Double bbox = null;
        if (symbols.size() > 4) {
            for (Symbols.Instr instr : symbols.get(0)) {
                if (instr.type != Symbols.Form.BBOX) continue;
                bbox = (Rectangle2D.Double)instr.params;
                break;
            }
            if (bbox == null) {
                return;
            }
        }
        switch (symbols.size()) {
            case 1: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                break;
            }
            case 2: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.RC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.LC, new AffineTransform()));
                break;
            }
            case 3: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.TR, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.TL, new AffineTransform()));
                break;
            }
            case 4: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.BL, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.TR, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(3), new Symbols.Delta(Symbols.Handle.TL, new AffineTransform()));
                break;
            }
            case 5: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.BL, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(3), new Symbols.Delta(Symbols.Handle.TC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(4), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                break;
            }
            case 6: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.BC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(3), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(4), new Symbols.Delta(Symbols.Handle.TC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(5), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                break;
            }
            case 7: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(3), new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(4), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(5), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(6), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, bbox.height / 2.0)));
                break;
            }
            case 8: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(3), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(4), new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(5), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(6), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(7), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, bbox.height / 2.0)));
                break;
            }
            case 9: {
                Renderer.symbol(feature, symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, -bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(1), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(2), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(bbox.width / 2.0, -bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(3), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(4), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                Renderer.symbol(feature, symbols.get(5), new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(feature, symbols.get(6), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(7), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, bbox.height / 2.0)));
                Renderer.symbol(feature, symbols.get(8), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, bbox.height / 2.0)));
            }
        }
    }

    private static Rectangle2D.Double symbolSize(Symbols.Symbol symbol) {
        Symbols.Symbol ssymb = symbol;
        while (ssymb != null) {
            for (Symbols.Instr item : symbol) {
                if (item.type == Symbols.Form.BBOX) {
                    return (Rectangle2D.Double)item.params;
                }
                if (item.type != Symbols.Form.SYMB) continue;
                ssymb = ((Symbols.SubSymbol)item.params).instr;
                break;
            }
            if (ssymb != symbol) continue;
            break;
        }
        return null;
    }

    public static void lineSymbols(S57map.Feature feature, Symbols.Symbol prisymb, double space, Symbols.Symbol secsymb, Symbols.Symbol tersymb, int ratio, Color col) {
        if (feature.geom.prim == S57map.Pflag.NOSP || feature.geom.prim == S57map.Pflag.POINT) {
            return;
        }
        Rectangle2D.Double prect = Renderer.symbolSize(prisymb);
        Rectangle2D.Double srect = Renderer.symbolSize(secsymb);
        Rectangle2D.Double trect = Renderer.symbolSize(tersymb);
        if (srect == null) {
            ratio = 0;
        }
        if (prect != null) {
            double psize = Math.abs(prect.getY()) * sScale;
            double ssize = srect != null ? Math.abs(srect.getY()) * sScale : 0.0;
            double tsize = trect != null ? Math.abs(srect.getY()) * sScale : 0.0;
            Point2D.Double prev = new Point2D.Double();
            Point2D next = new Point2D.Double();
            Point2D curr = new Point2D.Double();
            Point2D succ = new Point2D.Double();
            boolean gap = true;
            boolean piv = false;
            double len = 0.0;
            double angle = 0.0;
            int stcount = ratio;
            boolean stflag = false;
            Symbols.Symbol symbol = prisymb;
            S57map s57map = map;
            s57map.getClass();
            S57map.GeomIterator git = new S57map.GeomIterator(s57map, feature.geom);
            while (git.hasComp()) {
                git.nextComp();
                boolean first = true;
                while (git.hasEdge()) {
                    git.nextEdge();
                    while (git.hasNode()) {
                        prev = next;
                        next = context.getPoint(git.next());
                        angle = Math.atan2(next.getY() - ((Point2D)prev).getY(), next.getX() - ((Point2D)prev).getX());
                        piv = true;
                        if (first) {
                            curr = succ = next;
                            gap = space > 0.0;
                            stcount = ratio - 1;
                            symbol = prisymb;
                            len = gap ? psize * space * 0.5 : psize;
                            first = false;
                            continue;
                        }
                        while (curr.distance(next) >= len) {
                            if (piv) {
                                double rem = len;
                                double s = prev.distance(next);
                                double p = curr.distance(prev);
                                if (s > 0.0 && p > 0.0) {
                                    double n = curr.distance(next);
                                    double theta = Math.acos((s * s + p * p - n * n) / 2.0 / s / p);
                                    double phi = Math.asin(p / len * Math.sin(theta));
                                    rem = len * Math.sin(Math.PI - theta - phi) / Math.sin(theta);
                                }
                                succ = new Point2D.Double(((Point2D)prev).getX() + rem * Math.cos(angle), ((Point2D)prev).getY() + rem * Math.sin(angle));
                                piv = false;
                            } else {
                                succ = new Point2D.Double(curr.getX() + len * Math.cos(angle), curr.getY() + len * Math.sin(angle));
                            }
                            if (!gap) {
                                Symbols.drawSymbol(g2, symbol, sScale, curr.getX(), curr.getY(), new Symbols.Scheme(col), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getRotateInstance(Math.atan2(succ.getY() - curr.getY(), succ.getX() - curr.getX()) + Math.toRadians(90.0))));
                            }
                            if (space > 0.0) {
                                gap = !gap;
                            }
                            curr = succ;
                            double d = gap ? psize * space : (--stcount == 0 ? (stflag ? tsize : ssize) : (len = psize));
                            if (stcount == 0) {
                                Symbols.Symbol symbol2 = symbol = stflag ? tersymb : secsymb;
                                if (trect != null) {
                                    stflag = !stflag;
                                }
                                stcount = ratio;
                                continue;
                            }
                            symbol = prisymb;
                        }
                    }
                }
            }
        }
    }

    public static void lineVector(S57map.Feature feature, Symbols.LineStyle style) {
        Path2D.Double p = new Path2D.Double();
        p.setWindingRule(0);
        S57map s57map = map;
        s57map.getClass();
        S57map.GeomIterator git = new S57map.GeomIterator(s57map, feature.geom);
        while (git.hasComp()) {
            git.nextComp();
            while (git.hasEdge()) {
                git.nextEdge();
                Point2D point = context.getPoint(git.next());
                p.moveTo(point.getX(), point.getY());
                while (git.hasNode()) {
                    point = context.getPoint(git.next());
                    p.lineTo(point.getX(), point.getY());
                }
            }
        }
        if (style.line != null) {
            if (style.dash != null) {
                float[] dash = new float[style.dash.length];
                System.arraycopy(style.dash, 0, dash, 0, style.dash.length);
                int i = 0;
                while (i < style.dash.length) {
                    int n = i++;
                    dash[n] = dash[n] * (float)sScale;
                }
                g2.setStroke(new BasicStroke((float)((double)style.width * sScale), 0, 1, 1.0f, dash, 0.0f));
            } else {
                g2.setStroke(new BasicStroke((float)((double)style.width * sScale), 0, 1));
            }
            g2.setPaint(style.line);
            g2.draw(p);
        }
        if (style.fill != null) {
            g2.setPaint(style.fill);
            g2.fill(p);
        }
    }

    public static void lineCircle(S57map.Feature feature, Symbols.LineStyle style, double radius, S57val.UniHLU units) {
        switch (units) {
            case HLU_FEET: {
                radius /= 6076.0;
                break;
            }
            case HLU_KMTR: {
                radius /= 1.852;
                break;
            }
            case HLU_HMTR: {
                radius /= 18.52;
                break;
            }
            case HLU_SMIL: {
                radius /= 1.15078;
                break;
            }
            case HLU_NMIL: {
                break;
            }
            default: {
                radius /= 1852.0;
            }
        }
        radius *= context.mile(feature);
        Symbols.Symbol circle = new Symbols.Symbol();
        if (style.fill != null) {
            circle.add(new Symbols.Instr(Symbols.Form.FILL, style.fill));
            circle.add(new Symbols.Instr(Symbols.Form.RSHP, new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0)));
        }
        circle.add(new Symbols.Instr(Symbols.Form.FILL, style.line));
        circle.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(style.width, 0, 0, 1.0f, style.dash, 0.0f)));
        circle.add(new Symbols.Instr(Symbols.Form.ELPS, new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0)));
        Point2D point = context.getPoint(feature.geom.centre);
        Symbols.drawSymbol(g2, circle, 1.0, point.getX(), point.getY(), null, null);
    }

    public static void fillPattern(S57map.Feature feature, BufferedImage image) {
        Path2D.Double p = new Path2D.Double();
        p.setWindingRule(0);
        switch (feature.geom.prim) {
            case POINT: {
                Point2D point = context.getPoint(feature.geom.centre);
                g2.drawImage(image, new AffineTransformOp(AffineTransform.getScaleInstance(sScale, sScale), 1), (int)(point.getX() - 50.0 * sScale), (int)(point.getY() - 50.0 * sScale));
                break;
            }
            case AREA: {
                S57map s57map = map;
                s57map.getClass();
                S57map.GeomIterator git = new S57map.GeomIterator(s57map, feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    while (git.hasEdge()) {
                        git.nextEdge();
                        Point2D point = context.getPoint(git.next());
                        p.moveTo(point.getX(), point.getY());
                        while (git.hasNode()) {
                            point = context.getPoint(git.next());
                            p.lineTo(point.getX(), point.getY());
                        }
                    }
                }
                g2.setPaint(new TexturePaint(image, new Rectangle(0, 0, 1 + (int)(100.0 * sScale), 1 + (int)(100.0 * sScale))));
                g2.fill(p);
                break;
            }
        }
    }

    public static void labelText(S57map.Feature feature, String str, Font font, Color tc) {
        Renderer.labelText(feature, str, font, tc, LabelStyle.NONE, null, null, null);
    }

    public static void labelText(S57map.Feature feature, String str, Font font, Color tc, Symbols.Delta delta) {
        Renderer.labelText(feature, str, font, tc, LabelStyle.NONE, null, null, delta);
    }

    public static void labelText(S57map.Feature feature, String str, Font font, Color tc, LabelStyle style, Color fg) {
        Renderer.labelText(feature, str, font, tc, style, fg, null, null);
    }

    public static void labelText(S57map.Feature feature, String str, Font font, Color tc, LabelStyle style, Color fg, Color bg) {
        Renderer.labelText(feature, str, font, tc, style, fg, bg, null);
    }

    public static void labelText(S57map.Feature feature, String str, Font font, Color tc, LabelStyle style, Color fg, Symbols.Delta delta) {
        Renderer.labelText(feature, str, font, tc, style, fg, null, delta);
    }

    public static void labelText(S57map.Feature feature, String str, Font font, Color tc, LabelStyle style, Color fg, Color bg, Symbols.Delta delta) {
        double ty;
        double tx;
        if (delta == null) {
            delta = new Symbols.Delta(Symbols.Handle.CC);
        }
        if (bg == null) {
            bg = new Color(0, true);
        }
        if (str == null || str.isEmpty()) {
            str = " ";
        }
        FontRenderContext frc = g2.getFontRenderContext();
        GlyphVector gv = font.deriveFont((float)font.getSize()).createGlyphVector(frc, str.equals(" ") ? "!" : str);
        Rectangle2D bounds = gv.getVisualBounds();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Symbols.Symbol label = new Symbols.Symbol();
        switch (style) {
            case RRCT: {
                width += height * 1.0;
                height *= 1.5;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.34;
                ty = ly + height * 0.17;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(1 + (int)(height / 10.0), 0, 0)));
                label.add(new Symbols.Instr(Symbols.Form.RRCT, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                break;
            }
            case VCLR: {
                width += height * 1.0;
                height *= 2.0;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.27;
                ty = ly + height * 0.25;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                int sw = 1 + (int)(height / 10.0);
                double po = sw / 2;
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(sw, 0, 0)));
                Path2D.Double p = new Path2D.Double();
                p.moveTo(-height * 0.2, -ly - po);
                p.lineTo(height * 0.2, -ly - po);
                p.moveTo(0.0, -ly - po);
                p.lineTo(0.0, -ly - po - height * 0.15);
                p.moveTo(-height * 0.2, ly + po);
                p.lineTo(height * 0.2, ly + po);
                p.moveTo(0.0, ly + po);
                p.lineTo(0.0, ly + po + height * 0.15);
                label.add(new Symbols.Instr(Symbols.Form.PLIN, p));
                break;
            }
            case PCLR: {
                width += height * 1.0;
                height *= 2.0;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.27;
                ty = ly + height * 0.25;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                int sw = 1 + (int)(height / 10.0);
                double po = sw / 2;
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(sw, 0, 0)));
                Path2D.Double p = new Path2D.Double();
                p.moveTo(-height * 0.2, -ly - po);
                p.lineTo(height * 0.2, -ly - po);
                p.moveTo(0.0, -ly - po);
                p.lineTo(0.0, -ly - po - height * 0.15);
                p.moveTo(-height * 0.2, ly + po);
                p.lineTo(height * 0.2, ly + po);
                p.moveTo(0.0, ly + po);
                p.lineTo(0.0, ly + po + height * 0.15);
                label.add(new Symbols.Instr(Symbols.Form.PLIN, p));
                label.add(new Symbols.Instr(Symbols.Form.SYMB, new Symbols.SubSymbol(Areas.CableFlash, 1.0, 0.0, 0.0, null, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform(0.0, -1.0, 1.0, 0.0, -width / 2.0, 0.0)))));
                label.add(new Symbols.Instr(Symbols.Form.SYMB, new Symbols.SubSymbol(Areas.CableFlash, 1.0, 0.0, 0.0, null, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform(0.0, -1.0, 1.0, 0.0, width / 2.0, 0.0)))));
                break;
            }
            case HCLR: {
                width += height * 1.5;
                height *= 1.5;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.5;
                ty = ly + height * 0.17;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                int sw = 1 + (int)(height / 10.0);
                double vo = height / 4.0;
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(sw, 0, 0)));
                Path2D.Double p = new Path2D.Double();
                p.moveTo(-width * 0.4 - (double)sw, -ly - vo);
                p.lineTo(-width * 0.4 - (double)sw, ly + vo);
                p.moveTo(-width * 0.4 - (double)sw, 0.0);
                p.lineTo(-width * 0.4 + (double)sw, 0.0);
                p.moveTo(width * 0.4 + (double)sw, -ly - vo);
                p.lineTo(width * 0.4 + (double)sw, ly + vo);
                p.moveTo(width * 0.4 - (double)sw, 0.0);
                p.lineTo(width * 0.4 + (double)sw, 0.0);
                label.add(new Symbols.Instr(Symbols.Form.PLIN, p));
                break;
            }
            default: {
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx;
                ty = ly;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
            }
        }
        label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(str, font, tc, new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(tx, ty)))));
        Point2D point = context.getPoint(feature.geom.centre);
        Symbols.drawSymbol(g2, label, sScale, point.getX(), point.getY(), null, delta);
    }

    public static void lineText(S57map.Feature feature, String str, Font font, Color colour, double offset, double dy) {
        if (!str.isEmpty()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setPaint(colour);
            FontRenderContext frc = g2.getFontRenderContext();
            GlyphVector gv = font.deriveFont((float)((double)font.getSize() * sScale)).createGlyphVector(frc, " " + str);
            GeneralPath path = new GeneralPath();
            Point2D.Double prev = new Point2D.Double();
            Point2D next = new Point2D.Double();
            Point2D curr = new Point2D.Double();
            Point2D succ = new Point2D.Double();
            boolean piv = false;
            double angle = 0.0;
            int index = 0;
            double gwidth = offset * (feature.geom.length * context.mile(feature) - gv.getLogicalBounds().getWidth()) + (double)gv.getGlyphMetrics(0).getAdvance();
            S57map s57map = map;
            s57map.getClass();
            S57map.GeomIterator git = new S57map.GeomIterator(s57map, feature.geom);
            while (git.hasComp()) {
                git.nextComp();
                boolean first = true;
                while (git.hasEdge()) {
                    git.nextEdge();
                    while (git.hasNode()) {
                        prev = next;
                        next = context.getPoint(git.next());
                        angle = Math.atan2(next.getY() - ((Point2D)prev).getY(), next.getX() - ((Point2D)prev).getX());
                        piv = true;
                        if (first) {
                            curr = succ = next;
                            first = false;
                            continue;
                        }
                        while (curr.distance(next) >= gwidth) {
                            if (piv) {
                                double rem = gwidth;
                                double s = prev.distance(next);
                                double p = curr.distance(prev);
                                if (s > 0.0 && p > 0.0) {
                                    double n = curr.distance(next);
                                    double theta = Math.acos((s * s + p * p - n * n) / 2.0 / s / p);
                                    double phi = Math.asin(p / gwidth * Math.sin(theta));
                                    rem = gwidth * Math.sin(Math.PI - theta - phi) / Math.sin(theta);
                                }
                                succ = new Point2D.Double(((Point2D)prev).getX() + rem * Math.cos(angle), ((Point2D)prev).getY() + rem * Math.sin(angle));
                                piv = false;
                            } else {
                                succ = new Point2D.Double(curr.getX() + gwidth * Math.cos(angle), curr.getY() + gwidth * Math.sin(angle));
                            }
                            Shape shape = gv.getGlyphOutline(index);
                            Point2D point = gv.getGlyphPosition(index);
                            AffineTransform at = AffineTransform.getTranslateInstance(curr.getX(), curr.getY());
                            at.rotate(Math.atan2(succ.getY() - curr.getY(), succ.getX() - curr.getX()));
                            at.translate(-point.getX(), -point.getY() + dy * sScale);
                            path.append(at.createTransformedShape(shape), false);
                            curr = succ;
                            if (++index < gv.getNumGlyphs()) {
                                gwidth = gv.getGlyphMetrics(index).getAdvance();
                                continue;
                            }
                            g2.fill(path);
                            return;
                        }
                    }
                }
            }
        }
    }

    public static void lightSector(S57map.Feature feature, Color col1, Color col2, double radius, double s1, double s2, boolean dir, String str) {
        block9: {
            double arc;
            double offset;
            boolean hand;
            double gwidth;
            GlyphVector gv;
            GeneralPath path;
            double radial;
            Point2D.Double centre;
            double mid;
            block10: {
                if (zoom >= 16 && radius > 0.2) {
                    radius = 0.2 / Math.pow(2.0, zoom - 16);
                }
                mid = ((s1 + s2) / 2.0 + (double)(s1 > s2 ? 180 : 0)) % 360.0;
                g2.setStroke(new BasicStroke((float)(3.0 * sScale), 0, 1, 1.0f, new float[]{20.0f * (float)sScale, 20.0f * (float)sScale}, 0.0f));
                g2.setPaint(Color.black);
                centre = (Point2D.Double)context.getPoint(feature.geom.centre);
                radial = radius * context.mile(feature);
                if (dir) {
                    g2.draw(new Line2D.Double(centre.x, centre.y, centre.x - radial * Math.sin(Math.toRadians(mid)), centre.y + radial * Math.cos(Math.toRadians(mid))));
                } else {
                    g2.draw(new Line2D.Double(centre.x, centre.y, centre.x - radial * Math.sin(Math.toRadians(s1)), centre.y + radial * Math.cos(Math.toRadians(s1))));
                    g2.draw(new Line2D.Double(centre.x, centre.y, centre.x - radial * Math.sin(Math.toRadians(s2)), centre.y + radial * Math.cos(Math.toRadians(s2))));
                }
                double arcWidth = 10.0 * sScale;
                g2.setStroke(new BasicStroke((float)arcWidth, 0, 0, 1.0f));
                g2.setPaint(col1);
                g2.draw(new Arc2D.Double(centre.x - radial, centre.y - radial, 2.0 * radial, 2.0 * radial, -(s1 + 90.0), (s1 - s2 - 360.0) % 360.0, 0));
                if (col2 != null) {
                    g2.setPaint(col2);
                    g2.draw(new Arc2D.Double(centre.x - radial + arcWidth, centre.y - radial + arcWidth, 2.0 * (radial - arcWidth), 2.0 * (radial - arcWidth), -(s1 + 90.0), (s1 - s2 - 360.0) % 360.0, 0));
                }
                if (str == null || str.isEmpty()) break block9;
                g2.setPaint(Color.black);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                FontRenderContext frc = g2.getFontRenderContext();
                Font font = new Font("Arial", 0, 40);
                path = new GeneralPath();
                gv = font.deriveFont((float)((double)font.getSize() * sScale)).createGlyphVector(frc, " " + str);
                gwidth = gv.getLogicalBounds().getWidth();
                hand = false;
                offset = 0.0;
                arc = (s2 - s1 + 360.0) % 360.0;
                if (!dir) break block10;
                radial += 10.0 * sScale;
                if (mid < 180.0) {
                    radial += gwidth;
                    hand = true;
                }
                Point2D.Double origin = new Point2D.Double(centre.x - radial * Math.sin(Math.toRadians(mid)), centre.y + radial * Math.cos(Math.toRadians(mid)));
                int length = gv.getNumGlyphs();
                for (int i = 0; i < length; ++i) {
                    Shape shape = gv.getGlyphOutline(i);
                    Point2D point = gv.getGlyphPosition(i);
                    AffineTransform at = AffineTransform.getTranslateInstance(((Point2D)origin).getX(), ((Point2D)origin).getY());
                    at.rotate(Math.toRadians(mid + (double)(hand ? -90 : 90)));
                    at.translate(-point.getX() + offset, -point.getY() + 15.0 * sScale);
                    path.append(at.createTransformedShape(shape), false);
                    offset += (double)gv.getGlyphMetrics(i).getAdvance();
                    g2.fill(path);
                }
                break block9;
            }
            double awidth = Math.toRadians(arc) * radial;
            if (!(gwidth < awidth)) break block9;
            offset = 0.0;
            double phi = 0.0;
            if (mid > 270.0 || mid < 90.0) {
                hand = true;
                phi = Math.toRadians(s2) - (awidth - gwidth) / 2.0 / radial;
                radial -= 20.0 * sScale;
            } else {
                phi = Math.toRadians(s1) + (awidth - gwidth) / 2.0 / radial;
                radial += 20.0 * sScale;
            }
            Point2D.Double origin = new Point2D.Double(centre.x - radial * Math.sin(phi), centre.y + radial * Math.cos(phi));
            int length = gv.getNumGlyphs();
            for (int i = 0; i < length; ++i) {
                Shape shape = gv.getGlyphOutline(i);
                Point2D point = gv.getGlyphPosition(i);
                AffineTransform at = AffineTransform.getTranslateInstance(((Point2D)origin).getX(), ((Point2D)origin).getY());
                at.rotate(phi + (hand ? 0.0 : Math.toRadians(180.0)));
                at.translate(-point.getX() + offset, -point.getY());
                path.append(at.createTransformedShape(shape), false);
                double advance = gv.getGlyphMetrics(i).getAdvance();
                offset += advance;
                phi += (hand ? -0.5 : 0.5) * advance / radial;
                g2.fill(path);
            }
        }
    }

    public static enum LabelStyle {
        NONE,
        RRCT,
        RECT,
        ELPS,
        CIRC,
        VCLR,
        PCLR,
        HCLR;

    }
}

