/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import render.MapContext;
import render.Renderer;
import s57.S57map;

public class ShowFrame
extends JFrame {
    S57map showMap;
    Picture picture = new Picture();

    public ShowFrame(String title) {
        super(title);
        this.picture.setVisible(true);
        this.add(this.picture);
        this.pack();
    }

    public void showFeature(OsmPrimitive osm, S57map map) {
        this.picture.drawPicture(osm, map);
    }

    class Picture
    extends JPanel
    implements MapContext {
        Picture() {
        }

        public void drawPicture(OsmPrimitive osm, S57map map) {
            long id = osm.getUniqueId();
            S57map.Feature feature = (S57map.Feature)map.index.get(id);
            ShowFrame.this.showMap = new S57map();
            ShowFrame.this.showMap.nodes = map.nodes;
            ShowFrame.this.showMap.edges = map.edges;
            ShowFrame.this.showMap.index = map.index;
            if (feature != null) {
                ShowFrame.this.showMap.features.put(feature.type, new ArrayList());
                ((ArrayList)ShowFrame.this.showMap.features.get((Object)feature.type)).add(feature);
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(new Color(11915472));
            g2.clearRect(0, 0, 300, 300);
            Renderer.reRender(g2, 16, 32.0, ShowFrame.this.showMap, this);
        }

        @Override
        public Point2D getPoint(S57map.Snode coord) {
            return new Point2D.Double(150.0, 150.0);
        }

        @Override
        public double mile(S57map.Feature feature) {
            return 1000.0;
        }
    }
}

