/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import panels.PanelMain;
import s57.S57att;
import s57.S57dec;
import s57.S57map;
import s57.S57obj;
import s57.S57val;

public class PanelS57
extends JPanel {
    ArrayList<S57obj.Obj> types = new ArrayList();
    S57map map;
    HashMap<Long, Long> uids = new HashMap();

    public PanelS57() {
        this.setLayout(null);
        this.setSize(new Dimension(480, 480));
        this.setVisible(false);
    }

    public void startImport(File inf) throws IOException {
        String type;
        S57map.Feature feature;
        long id;
        FileInputStream in = new FileInputStream(inf);
        PanelMain.setStatus("Select OSM types file", Color.yellow);
        JFileChooser ifc = new JFileChooser(Main.pref.get("smed2plugin.typesfile"));
        ifc.setSelectedFile(new File(Main.pref.get("smed2plugin.typesfile")));
        int returnVal = ifc.showOpenDialog(Main.parent);
        if (returnVal == 0) {
            Main.pref.put("smed2plugin.typesfile", ifc.getSelectedFile().getPath());
            Scanner tin = new Scanner(new FileInputStream(ifc.getSelectedFile()));
            while (tin.hasNext()) {
                S57obj.Obj type2 = S57obj.enumType(tin.next());
                if (type2 == S57obj.Obj.UNKOBJ) continue;
                this.types.add(type2);
            }
            tin.close();
        }
        this.map = new S57map();
        S57map.MapBounds bounds = S57dec.decodeFile(in, this.map);
        in.close();
        DataSet data = new DataSet();
        data.setUploadDiscouraged(true);
        Iterator i$ = this.map.index.keySet().iterator();
        while (i$.hasNext()) {
            id = (Long)i$.next();
            feature = (S57map.Feature)this.map.index.get(id);
            type = S57obj.stringType(feature.type);
            if (type.isEmpty() || !this.types.isEmpty() && !this.types.contains((Object)feature.type) || feature.reln != S57map.Rflag.MASTER || feature.geom.prim != S57map.Pflag.POINT) continue;
            for (S57map.Prim prim : feature.geom.elems) {
                S57map.Snode snode;
                long ref = prim.id;
                while ((snode = (S57map.Snode)this.map.nodes.get(ref)) != null) {
                    if (!this.uids.containsKey(ref)) {
                        Node node = new Node(0L, 1);
                        node.setCoor(new LatLon(Math.toDegrees(snode.lat), Math.toDegrees(snode.lon)));
                        data.addPrimitive((OsmPrimitive)node);
                        this.addKeys((OsmPrimitive)node, feature, type);
                        this.uids.put(ref, node.getUniqueId());
                    }
                    ++ref;
                }
            }
        }
        i$ = this.map.index.keySet().iterator();
        while (i$.hasNext()) {
            Node node;
            S57map.GeomIterator git;
            id = (Long)i$.next();
            feature = (S57map.Feature)this.map.index.get(id);
            type = S57obj.stringType(feature.type);
            if (type.isEmpty() || !this.types.isEmpty() && !this.types.contains((Object)feature.type) || feature.reln != S57map.Rflag.MASTER) continue;
            if (feature.geom.prim == S57map.Pflag.LINE || feature.geom.prim == S57map.Pflag.AREA && feature.geom.outers == 1 && feature.geom.inners == 0) {
                S57map s57map = this.map;
                s57map.getClass();
                git = new S57map.GeomIterator(s57map, feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    while (git.hasEdge()) {
                        git.nextEdge();
                        while (git.hasNode()) {
                            long ref = git.nextRef();
                            S57map.Snode snode = (S57map.Snode)this.map.nodes.get(ref);
                            if (this.uids.containsKey(ref)) continue;
                            node = new Node(0L, 1);
                            node.setCoor(new LatLon(Math.toDegrees(snode.lat), Math.toDegrees(snode.lon)));
                            data.addPrimitive((OsmPrimitive)node);
                            this.uids.put(ref, node.getUniqueId());
                        }
                    }
                }
                S57map s57map2 = this.map;
                s57map2.getClass();
                git = new S57map.GeomIterator(s57map2, feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    Way way = new Way(0L, 1);
                    data.addPrimitive((OsmPrimitive)way);
                    while (git.hasEdge()) {
                        git.nextEdge();
                        while (git.hasNode()) {
                            long ref = git.nextRef();
                            way.addNode((Node)data.getPrimitiveById(this.uids.get(ref).longValue(), OsmPrimitiveType.NODE));
                        }
                    }
                    this.addKeys((OsmPrimitive)way, feature, type);
                }
                continue;
            }
            if (feature.geom.prim != S57map.Pflag.AREA) continue;
            S57map s57map = this.map;
            s57map.getClass();
            git = new S57map.GeomIterator(s57map, feature.geom);
            while (git.hasComp()) {
                git.nextComp();
                while (git.hasEdge()) {
                    git.nextEdge();
                    while (git.hasNode()) {
                        long ref = git.nextRef();
                        S57map.Snode snode = (S57map.Snode)this.map.nodes.get(ref);
                        if (this.uids.containsKey(ref)) continue;
                        node = new Node(0L, 1);
                        node.setCoor(new LatLon(Math.toDegrees(snode.lat), Math.toDegrees(snode.lon)));
                        data.addPrimitive((OsmPrimitive)node);
                        this.uids.put(ref, node.getUniqueId());
                    }
                }
            }
            S57map s57map3 = this.map;
            s57map3.getClass();
            git = new S57map.GeomIterator(s57map3, feature.geom);
            while (git.hasComp()) {
                long ref = git.nextComp();
                Way way = new Way(0L, 1);
                this.uids.put(ref, way.getUniqueId());
                data.addPrimitive((OsmPrimitive)way);
                while (git.hasEdge()) {
                    git.nextEdge();
                    while (git.hasNode()) {
                        ref = git.nextRef();
                        way.addNode((Node)data.getPrimitiveById(this.uids.get(ref).longValue(), OsmPrimitiveType.NODE));
                    }
                }
            }
            Relation rel = new Relation(0L, 1);
            data.addPrimitive((OsmPrimitive)rel);
            S57map s57map4 = this.map;
            s57map4.getClass();
            git = new S57map.GeomIterator(s57map4, feature.geom);
            int outers = feature.geom.outers;
            while (git.hasComp()) {
                long ref = git.nextComp();
                if (outers-- > 0) {
                    rel.addMember(new RelationMember("outer", (OsmPrimitive)((Way)data.getPrimitiveById(this.uids.get(ref).longValue(), OsmPrimitiveType.WAY))));
                    continue;
                }
                rel.addMember(new RelationMember("inner", (OsmPrimitive)((Way)data.getPrimitiveById(this.uids.get(ref).longValue(), OsmPrimitiveType.WAY))));
            }
            this.addKeys((OsmPrimitive)rel, feature, type);
        }
        OsmDataLayer layer = new OsmDataLayer(data, "S-57 Import", null);
        Main.map.mapView.addLayer((Layer)layer);
        Main.map.mapView.zoomTo(new Bounds(bounds.minlat, bounds.minlon, bounds.maxlat, bounds.maxlon));
        PanelMain.setStatus("Import done", Color.green);
    }

    void addKeys(OsmPrimitive prim, S57map.Feature feature, String type) {
        HashMap<String, String> keys = new HashMap<String, String>();
        if (prim instanceof Relation) {
            keys.put("type", "multipolygon");
        }
        keys.put("seamark:type", type);
        if (feature.type == S57obj.Obj.SOUNDG) {
            S57map.Snode snode = (S57map.Snode)this.map.nodes.get(feature.geom.elems.get((int)0).id);
            if (snode.flg == S57map.Nflag.DPTH) {
                keys.put("seamark:sounding:depth", Double.valueOf(((S57map.Dnode)snode).val).toString());
            }
        }
        for (Map.Entry item : feature.atts.entrySet()) {
            String attstr = S57att.stringAttribute((S57att.Att)((Object)item.getKey()));
            String valstr = S57val.stringValue((S57val.AttVal)item.getValue());
            if (attstr.isEmpty() || valstr.isEmpty()) continue;
            keys.put("seamark:" + type + ":" + attstr, valstr);
        }
        for (S57obj.Obj obj : feature.objs.keySet()) {
            S57map.ObjTab tab = (S57map.ObjTab)feature.objs.get((Object)obj);
            Iterator i$ = tab.keySet().iterator();
            while (i$.hasNext()) {
                int ix = (Integer)i$.next();
                type = S57obj.stringType(obj);
                S57map.AttMap atts = (S57map.AttMap)tab.get(ix);
                for (Map.Entry item : atts.entrySet()) {
                    String attstr = S57att.stringAttribute((S57att.Att)((Object)item.getKey()));
                    String valstr = S57val.stringValue((S57val.AttVal)item.getValue());
                    if (attstr.isEmpty() || valstr.isEmpty()) continue;
                    if (ix == 0 && tab.size() == 1) {
                        keys.put("seamark:" + type + ":" + attstr, valstr);
                        continue;
                    }
                    keys.put("seamark:" + type + ":" + (ix + 1) + ":" + attstr, valstr);
                }
            }
        }
        prim.setKeys(keys);
    }

    public void startExport(File outf) throws IOException {
    }
}

