/*
 * Decompiled with CFR 0.152.
 */
package panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import messages.Messages;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import render.Renderer;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;
import smed2.Smed2Action;

public class PanelMain
extends JPanel {
    BufferedImage img;
    int w;
    int h;
    int z;
    int f;
    JTextField wt;
    JTextField ht;
    JTextField zt;
    JTextField ft;
    public static JTextArea decode = null;
    public static JTextField messageBar = null;
    public JButton saveButton = null;
    private ActionListener alSave = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelMain.this.dumpMap();
        }
    };
    private JButton importButton = null;
    JFileChooser ifc = new JFileChooser(Main.pref.get("smed2plugin.encinpfile"));
    private ActionListener alImport = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelMain.this.importButton) {
                Smed2Action.panelS57.setVisible(true);
                PanelMain.setStatus("Select S-57 ENC file for import", Color.yellow);
                int returnVal = PanelMain.this.ifc.showOpenDialog(Main.parent);
                if (returnVal == 0) {
                    try {
                        Main.pref.put("smed2plugin.encinpfile", PanelMain.this.ifc.getSelectedFile().getPath());
                        Smed2Action.panelS57.startImport(PanelMain.this.ifc.getSelectedFile());
                    }
                    catch (IOException e1) {
                        Smed2Action.panelS57.setVisible(false);
                        PanelMain.setStatus("IO Exception", Color.red);
                    }
                } else {
                    Smed2Action.panelS57.setVisible(false);
                    PanelMain.clrStatus();
                }
            }
        }
    };
    private JButton exportButton = null;
    final JFileChooser efc = new JFileChooser();
    private ActionListener alExport = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelMain.this.exportButton) {
                Smed2Action.panelS57.setVisible(true);
                PanelMain.setStatus("Select S-57 ENC file for export", Color.yellow);
                int returnVal = PanelMain.this.efc.showOpenDialog(Main.parent);
                if (returnVal == 0) {
                    try {
                        Smed2Action.panelS57.startExport(PanelMain.this.efc.getSelectedFile());
                    }
                    catch (IOException e1) {
                        Smed2Action.panelS57.setVisible(false);
                        PanelMain.setStatus("IO Exception", Color.red);
                    }
                } else {
                    Smed2Action.panelS57.setVisible(false);
                    PanelMain.clrStatus();
                }
            }
        }
    };

    public PanelMain() {
        this.setLayout(null);
        this.setSize(new Dimension(480, 480));
        this.f = 0;
        this.z = 0;
        this.h = 0;
        this.w = 0;
        this.wt = new JTextField("0");
        this.wt.setBounds(10, 400, 40, 20);
        this.add(this.wt);
        this.ht = new JTextField("0");
        this.ht.setBounds(60, 400, 40, 20);
        this.add(this.ht);
        this.zt = new JTextField("0");
        this.zt.setBounds(110, 400, 40, 20);
        this.add(this.zt);
        this.ft = new JTextField("0");
        this.ft.setBounds(160, 400, 40, 20);
        this.add(this.ft);
        messageBar = new JTextField();
        messageBar.setBounds(70, 430, 290, 20);
        messageBar.setEditable(false);
        messageBar.setBackground(Color.WHITE);
        this.add(messageBar);
        this.importButton = new JButton(new ImageIcon(this.getClass().getResource("/images/importButton.png")));
        this.importButton.setBounds(10, 430, 20, 20);
        this.add(this.importButton);
        this.importButton.addActionListener(this.alImport);
        this.exportButton = new JButton(new ImageIcon(this.getClass().getResource("/images/exportButton.png")));
        this.exportButton.setBounds(40, 430, 20, 20);
        this.add(this.exportButton);
        this.exportButton.addActionListener(this.alExport);
        this.saveButton = new JButton();
        this.saveButton.setBounds(370, 430, 100, 20);
        this.saveButton.setText(I18n.tr((String)"Save", (Object[])new Object[0]));
        this.add(this.saveButton);
        this.saveButton.addActionListener(this.alSave);
        decode = new JTextArea();
        decode.setBounds(0, 0, 480, 420);
        decode.setTabSize(1);
        this.add(decode);
    }

    public void dumpMap() {
        this.img = new BufferedImage(Integer.parseInt(this.wt.getText()), Integer.parseInt(this.ht.getText()), 2);
        Graphics2D g2 = this.img.createGraphics();
        Renderer.reRender(g2, Integer.parseInt(this.zt.getText()), Integer.parseInt(this.ft.getText()), Smed2Action.map, Smed2Action.rendering);
        try {
            ImageIO.write((RenderedImage)this.img, "png", new File(System.getProperty("user.home") + "/Desktop/export.png"));
        }
        catch (Exception x) {
            System.out.println("Exception");
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(new Color(11915472));
        if (this.img != null) {
            g2.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
        }
        g2.drawImage((Image)this.img, 0, 0, null);
    }

    public static void setStatus(String text, Color bg) {
        messageBar.setBackground(bg);
        messageBar.setText(text);
    }

    public static void clrStatus() {
        messageBar.setBackground(Color.white);
        messageBar.setText("");
    }

    public void parseMark(S57map.Feature feature) {
        decode.setText("Selected object:\n");
        decode.append("\t" + I18n.tr((String)"Type", (Object[])new Object[0]) + ": " + Messages.getString(feature.type.name()) + "\n");
        if (feature.atts.get((Object)S57att.Att.OBJNAM) != null) {
            decode.append("\t" + I18n.tr((String)"Name", (Object[])new Object[0]) + ": " + ((S57val.AttVal)feature.atts.get((Object)((Object)S57att.Att.OBJNAM))).val + "\n");
        }
        decode.append("\tObjects:\n");
        for (S57obj.Obj obj : feature.objs.keySet()) {
            decode.append("\t\t" + Messages.getString(obj.name()) + "\n");
            if (((S57map.ObjTab)feature.objs.get((Object)obj)).size() == 0) continue;
            for (S57map.AttMap atts : ((S57map.ObjTab)feature.objs.get((Object)obj)).values()) {
                block6: for (S57att.Att att : atts.keySet()) {
                    S57val.AttVal item = (S57val.AttVal)atts.get((Object)att);
                    switch (item.conv) {
                        case E: {
                            decode.append("\t\t\t" + Messages.getString(att.name()) + ": " + Messages.getString(((Enum)item.val).name()) + "\n");
                            continue block6;
                        }
                        case L: {
                            decode.append("\t\t\t" + Messages.getString(att.name()) + ": ");
                            boolean first = true;
                            for (Object val : (ArrayList)item.val) {
                                if (!first) {
                                    decode.append(", ");
                                } else {
                                    first = false;
                                }
                                decode.append(Messages.getString(((Enum)val).name()));
                            }
                            decode.append("\n");
                            continue block6;
                        }
                    }
                    decode.append("\t\t\t" + Messages.getString(att.name()) + ": " + item.val + "\n");
                }
            }
        }
    }

    public void clearMark() {
        decode.setText(I18n.tr((String)"No object selected", (Object[])new Object[0]));
    }
}

