/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParseException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleListParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ReadRemoteModuleInformationTask
extends PleaseWaitRunnable
implements OdConstants {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<ModuleInformation> availableModules;

    protected void init(Collection<String> sites) {
        this.sites = sites;
        if (sites == null) {
            this.sites = Collections.emptySet();
        }
        this.availableModules = new LinkedList<ModuleInformation>();
    }

    public ReadRemoteModuleInformationTask(Collection<String> sites) {
        super(I18n.tr((String)"Download module list...", (Object[])new Object[0]), false);
        this.init(sites);
    }

    public ReadRemoteModuleInformationTask(ProgressMonitor monitor, Collection<String> sites) {
        super(I18n.tr((String)"Download module list...", (Object[])new Object[0]), monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        this.init(sites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        ReadRemoteModuleInformationTask readRemoteModuleInformationTask = this;
        synchronized (readRemoteModuleInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    protected void finish() {
    }

    protected File createSiteCacheFile(File moduleDir, String site, CacheType type) {
        String name;
        try {
            site = site.replaceAll("%<(.*)>", "");
            URL url = new URL(site);
            StringBuilder sb = new StringBuilder();
            sb.append("site-");
            sb.append(url.getHost()).append("-");
            if (url.getPort() != -1) {
                sb.append(url.getPort()).append("-");
            }
            String path = url.getPath();
            for (int i = 0; i < path.length() - 4; ++i) {
                char c = path.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append("_");
            }
            switch (type) {
                case PLUGIN_LIST: {
                    sb.append(".txt");
                    break;
                }
                case ICON_LIST: {
                    sb.append("-icons.zip");
                }
            }
            name = sb.toString();
        }
        catch (MalformedURLException e) {
            name = "site-unknown.txt";
        }
        return new File(moduleDir, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String downloadModuleList(String site, ProgressMonitor monitor) {
        ReadRemoteModuleInformationTask readRemoteModuleInformationTask;
        String string;
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            String printsite = site.replaceAll("%<(.*)>", "");
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr((String)"Downloading module list from ''{0}''", (Object[])new Object[]{printsite}));
            URL url = new URL(printsite);
            ReadRemoteModuleInformationTask readRemoteModuleInformationTask2 = this;
            synchronized (readRemoteModuleInformationTask2) {
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", url.getHost());
                this.connection.setRequestProperty("Accept-Charset", "utf-8");
            }
            in = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
            string = sb.toString();
            readRemoteModuleInformationTask = this;
        }
        catch (MalformedURLException e) {
            block33: {
                if (!this.canceled) break block33;
                String string2 = null;
                return string2;
            }
            e.printStackTrace();
            String string3 = null;
            return string3;
        }
        catch (IOException e2) {
            block34: {
                if (!this.canceled) break block34;
                String string4 = null;
                return string4;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            e2.printStackTrace();
            String string5 = null;
            return string5;
        }
        finally {
            ReadRemoteModuleInformationTask readRemoteModuleInformationTask3 = this;
            synchronized (readRemoteModuleInformationTask3) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            Utils.close(in);
            monitor.finishTask();
        }
        synchronized (readRemoteModuleInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.connection = null;
        }
        Utils.close((Closeable)in);
        monitor.finishTask();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void downloadModuleIcons(String site, File destFile, ProgressMonitor monitor) {
        Object url;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            site = site.replaceAll("%<(.*)>", "");
            monitor.beginTask("");
            monitor.indeterminateSubTask(I18n.tr((String)"Downloading module list from ''{0}''", (Object[])new Object[]{site}));
            url = new URL(site);
            ReadRemoteModuleInformationTask readRemoteModuleInformationTask = this;
            synchronized (readRemoteModuleInformationTask) {
                this.connection = (HttpURLConnection)((URL)url).openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", ((URL)url).getHost());
            }
            in = this.connection.getInputStream();
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int read = in.read(buffer);
            while (read != -1) {
                ((OutputStream)out).write(buffer, 0, read);
                read = in.read(buffer);
            }
            ((OutputStream)out).close();
            in.close();
            url = this;
        }
        catch (MalformedURLException e) {
            block34: {
                if (!this.canceled) break block34;
                return;
            }
            e.printStackTrace();
            return;
        }
        catch (IOException e2) {
            block35: {
                if (!this.canceled) break block35;
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            e2.printStackTrace();
            return;
        }
        finally {
            ReadRemoteModuleInformationTask buffer = this;
            synchronized (buffer) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            Utils.close(in);
            monitor.finishTask();
        }
        synchronized (url) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.connection = null;
        }
        Utils.close((Closeable)in);
        monitor.finishTask();
        for (ModuleInformation pi : this.availableModules) {
            if (pi.icon != null || pi.iconPath == null) continue;
            pi.icon = new ImageProvider(pi.name + ".jar/" + pi.iconPath).setArchive(destFile).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheModuleList(String site, String list) {
        PrintWriter writer = null;
        try {
            File moduleDir = OdPlugin.getInstance().getModulesDirectory();
            if (!moduleDir.exists() && !moduleDir.mkdirs()) {
                System.err.println(I18n.tr((String)"Warning: failed to create module directory ''{0}''. Cannot cache module list from module site ''{1}''.", (Object[])new Object[]{moduleDir.toString(), site}));
            }
            File cacheFile = this.createSiteCacheFile(moduleDir, site, CacheType.PLUGIN_LIST);
            this.getProgressMonitor().subTask(I18n.tr((String)"Writing module list to local cache ''{0}''", (Object[])new Object[]{cacheFile.toString()}));
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "utf-8"));
            writer.write(list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    protected void parseModuleListDocument(String site, String doc) {
        try {
            this.getProgressMonitor().subTask(I18n.tr((String)"Parsing module list from site ''{0}''", (Object[])new Object[]{site}));
            ByteArrayInputStream in = new ByteArrayInputStream(doc.getBytes("UTF-8"));
            this.availableModules.addAll(new ModuleListParser().parse(in));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(I18n.tr((String)"Failed to parse module list document from site ''{0}''. Skipping site. Exception was: {1}", (Object[])new Object[]{site, e.toString()}));
            e.printStackTrace();
        }
        catch (ModuleListParseException e) {
            System.err.println(I18n.tr((String)"Failed to parse module list document from site ''{0}''. Skipping site. Exception was: {1}", (Object[])new Object[]{site, e.toString()}));
            e.printStackTrace();
        }
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        LinkedList<File> siteCacheFiles = new LinkedList<File>();
        for (String location : ModuleInformation.getModuleLocations()) {
            File[] f = new File(location).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("^([0-9]+-)?site.*\\.txt$") || name.matches("^([0-9]+-)?site.*-icons\\.zip$");
                }
            });
            if (f == null || f.length <= 0) continue;
            siteCacheFiles.addAll(Arrays.asList(f));
        }
        for (String site : this.sites) {
            String printsite = site.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr((String)"Processing module list from site ''{0}''", (Object[])new Object[]{printsite}));
            String list = this.downloadModuleList(site, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            siteCacheFiles.remove(this.createSiteCacheFile(moduleDir, site, CacheType.PLUGIN_LIST));
            siteCacheFiles.remove(this.createSiteCacheFile(moduleDir, site, CacheType.ICON_LIST));
            if (list != null) {
                this.getProgressMonitor().worked(1);
                this.cacheModuleList(site, list);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                this.parseModuleListDocument(site, list);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
            }
            this.downloadModuleIcons(site.replace(".txt", "") + "-icons.zip", this.createSiteCacheFile(moduleDir, site, CacheType.ICON_LIST), this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        for (File file : siteCacheFiles) {
            file.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<ModuleInformation> getAvailableModules() {
        return this.availableModules;
    }

    protected static enum CacheType {
        PLUGIN_LIST,
        ICON_LIST;

    }
}

