/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.RelationMemberTable;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedEditorPanel
extends JPanel {
    private TurnRestrictionEditorModel model;
    private TagEditorPanel pnlTagEditor;
    private JPanel pnlRelationMemberEditor;
    private JTable tblRelationMemberEditor;
    private JSplitPane spEditors;

    protected JPanel buildTagEditorPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel msg = new HtmlPanel();
        msg.setText("<html><body>" + I18n.tr((String)"In the following table you can edit the <strong>raw tags</strong> of the OSM relation representing this turn restriction.", (Object[])new Object[0]) + "</body></html>");
        pnl.add((Component)msg, "North");
        this.pnlTagEditor = new TagEditorPanel(this.model.getTagEditorModel(), null);
        this.pnlTagEditor.initAutoCompletion(this.model.getLayer());
        pnl.add((Component)this.pnlTagEditor, "Center");
        return pnl;
    }

    protected JPanel buildMemberEditorPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        HtmlPanel msg = new HtmlPanel();
        msg.setText("<html><body>" + I18n.tr((String)"In the following table you can edit the <strong>raw members</strong> of the OSM relation representing this turn restriction.", (Object[])new Object[0]) + "</body></html>");
        pnl.add((Component)msg, "North");
        this.tblRelationMemberEditor = new RelationMemberTable(this.model);
        JScrollPane pane = new JScrollPane(this.tblRelationMemberEditor);
        pane.setVerticalScrollBarPolicy(20);
        pane.setHorizontalScrollBarPolicy(31);
        pnl.add(pane);
        return pnl;
    }

    protected JSplitPane buildSplitPane() {
        this.spEditors = new JSplitPane(0);
        this.spEditors.setTopComponent(this.buildTagEditorPanel());
        this.spEditors.setBottomComponent(this.buildMemberEditorPanel());
        this.spEditors.setOneTouchExpandable(false);
        this.spEditors.setDividerSize(5);
        this.spEditors.addHierarchyListener(new SplitPaneDividerInitializer());
        return this.spEditors;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildSplitPane(), "Center");
    }

    public AdvancedEditorPanel(TurnRestrictionEditorModel model) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        this.model = model;
        this.build();
        HelpUtil.setHelpContext((JComponent)this, (String)HelpUtil.ht((String)"/Plugin/TurnRestrictions#AdvancedEditor"));
    }

    class SplitPaneDividerInitializer
    implements HierarchyListener {
        SplitPaneDividerInitializer() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (AdvancedEditorPanel.this.isShowing()) {
                AdvancedEditorPanel.this.spEditors.setDividerLocation(0.5);
                AdvancedEditorPanel.this.spEditors.removeHierarchyListener(this);
            }
        }
    }
}

