/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service.value;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class BugType
implements Serializable {
    private static final long serialVersionUID = 4022464908172242274L;
    private String key;
    private String value;
    private static HashMap<String, BugType> table = null;
    public static final BugType WRONG_TURN = new BugType("wrong_turn", "Wrong turn");
    public static final BugType BAD_ROUTING = new BugType("bad_routing", "Bad routing");
    public static final BugType ONEWAY_ROAD = new BugType("oneway_road", "Oneway road");
    public static final BugType BLOCKED_STREET = new BugType("blocked_street", "Blocked street");
    public static final BugType MISSING_STREET = new BugType("missing_street", "Missing street");
    public static final BugType WRONG_ROUNDABOUT = new BugType("wrong_roundabout", "Wrong roundabout");
    public static final BugType MISSING_SPEEDLIMIT = new BugType("missing_speedlimit", "Missing speedlimit");
    public static final BugType OTHER = new BugType("other", "Other");

    public BugType() {
    }

    public BugType(String key, String value) {
        this.key = key;
        this.value = value;
        if (table == null) {
            table = new HashMap();
        }
        table.put(key, this);
    }

    public static BugType getType(String value) throws IllegalStateException {
        BugType type = table.get(value);
        if (type == null) {
            type = OTHER;
        }
        return type;
    }

    public static BugType getTypeFromValue(String value) {
        BugType type = null;
        for (BugType obj : table.values()) {
            if (!obj.getValue().equals(value)) continue;
            type = obj;
            break;
        }
        return type;
    }

    public static BugType[] getTypes() {
        Collection<BugType> collection = table.values();
        return collection.toArray(new BugType[0]);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

