/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;

public class MapdustCommentsPanel
extends JPanel {
    private static final long serialVersionUID = 5730420562553912697L;

    public MapdustCommentsPanel(MapdustComment[] comments) {
        this.setLayout(new BorderLayout());
        this.addComponents(comments);
    }

    public void updateComponents(MapdustComment[] comments) {
        this.removeAll();
        this.addComponents(comments);
    }

    private void addComponents(MapdustComment[] comments) {
        String name = "Bug Comments (";
        name = name + comments.length + " )";
        this.setName(name);
        JTextArea txt = new JTextArea();
        txt.setAutoscrolls(true);
        txt.setEditable(false);
        String line = "";
        DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
        int index = comments.length;
        for (MapdustComment com : comments) {
            line = line + "Comment " + index + ":";
            line = line + "\n";
            line = line + "  " + com.getCommentText();
            line = line + "\n ";
            line = line + " added by [" + com.getNickname() + "]";
            line = line + " on ";
            line = line + "[ " + df.format(com.getDateCreated()) + " ";
            line = line + "] \n\n";
            --index;
        }
        txt.setText(line);
        txt.setFont(new Font("Times New Roman", 1, 12));
        txt.setCaretPosition(0);
        JScrollPane sp = ComponentUtil.createJScrollPane(txt, null, Color.white, true, true);
        sp.setPreferredSize(new Dimension(100, 100));
        this.add(sp);
    }
}

