/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png.chunks;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.ZLibUtils;
import org.apache.sanselan.formats.png.PngText;
import org.apache.sanselan.formats.png.chunks.PNGTextChunk;

public class PNGChunkzTXt
extends PNGTextChunk {
    public final String keyword;
    public final String text;

    public PNGChunkzTXt(int length, int chunkType, int crc, byte[] bytes) throws ImageReadException, IOException {
        super(length, chunkType, crc, bytes);
        int index = this.findNull(bytes);
        if (index < 0) {
            throw new ImageReadException("PNG zTXt chunk keyword is unterminated.");
        }
        this.keyword = new String(bytes, 0, index, "ISO-8859-1");
        int n = ++index;
        ++index;
        byte compressionMethod = bytes[n];
        if (compressionMethod != 0) {
            throw new ImageReadException("PNG zTXt chunk has unexpected compression method: " + compressionMethod);
        }
        int compressedTextLength = bytes.length - index;
        byte[] compressedText = new byte[compressedTextLength];
        System.arraycopy(bytes, index, compressedText, 0, compressedTextLength);
        this.text = new String(new ZLibUtils().inflate(compressedText), "ISO-8859-1");
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public PngText getContents() {
        return new PngText.zTXt(this.keyword, this.text);
    }
}

