/*
 * Decompiled with CFR 0.152.
 */
package reverter.corehacks;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangesetParser;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;
import reverter.corehacks.ChangesetDataSet;
import reverter.corehacks.OsmChangesetContentParser;

public class OsmServerChangesetReader
extends OsmServerReader {
    public OsmServerChangesetReader() {
        this.setDoAuthenticate(false);
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Changeset> queryChangesets(ChangesetQuery query, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull((Object)query, (String)"query");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            List changesets;
            monitor.beginTask(I18n.tr((String)"Reading changesets...", (Object[])new Object[0]));
            StringBuffer sb = new StringBuffer();
            sb.append("changesets?").append(query.getQueryString());
            InputStream in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
            if (in == null) {
                List<Changeset> list = null;
                return list;
            }
            monitor.indeterminateSubTask(I18n.tr((String)"Downloading changesets ...", (Object[])new Object[0]));
            List list = changesets = OsmChangesetParser.parse((InputStream)in, (ProgressMonitor)monitor.createSubTaskMonitor(1, true));
            return list;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public Changeset readChangeset(long id, ProgressMonitor monitor) throws OsmTransferException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", id));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr((String)"Reading changeset {0} ...", (Object[])new Object[]{id}));
            StringBuffer sb = new StringBuffer();
            sb.append("changeset/").append(id);
            InputStream in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
            if (in == null) {
                Changeset changeset = null;
                return changeset;
            }
            monitor.indeterminateSubTask(I18n.tr((String)"Downloading changeset {0} ...", (Object[])new Object[]{id}));
            List changesets = OsmChangesetParser.parse((InputStream)in, (ProgressMonitor)monitor.createSubTaskMonitor(1, true));
            if (changesets == null || changesets.isEmpty()) {
                Changeset changeset = null;
                return changeset;
            }
            Changeset changeset = (Changeset)changesets.get(0);
            return changeset;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public List<Changeset> readChangesets(Collection<Integer> ids, ProgressMonitor monitor) throws OsmTransferException {
        if (ids == null) {
            return Collections.emptyList();
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.trn((String)"Downloading {0} changeset ...", (String)"Downloading {0} changesets ...", (long)ids.size(), (Object[])new Object[]{ids.size()}));
            monitor.setTicksCount(ids.size());
            ArrayList<Changeset> ret = new ArrayList<Changeset>();
            int i = 0;
            for (int id : ids) {
                if (id <= 0) continue;
                ++i;
                StringBuffer sb = new StringBuffer();
                sb.append("changeset/").append(id);
                InputStream in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
                if (in == null) {
                    List<Changeset> list = null;
                    return list;
                }
                monitor.indeterminateSubTask(I18n.tr((String)"({0}/{1}) Downloading changeset {2} ...", (Object[])new Object[]{i, ids.size(), id}));
                List changesets = OsmChangesetParser.parse((InputStream)in, (ProgressMonitor)monitor.createSubTaskMonitor(1, true));
                if (changesets == null || changesets.isEmpty()) continue;
                ret.addAll(changesets);
                monitor.worked(1);
            }
            ArrayList<Changeset> arrayList = ret;
            return arrayList;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public ChangesetDataSet downloadChangeset(int id, ProgressMonitor monitor) throws IllegalArgumentException, OsmTransferException {
        if (id <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type integer > 0 for parameter ''{0}'', got {1}", "id", id));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ChangesetDataSet ds;
            monitor.beginTask(I18n.tr((String)"Downloading changeset content", (Object[])new Object[0]));
            StringBuffer sb = new StringBuffer();
            sb.append("changeset/").append(id).append("/download");
            InputStream in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
            if (in == null) {
                ChangesetDataSet changesetDataSet = null;
                return changesetDataSet;
            }
            monitor.setCustomText(I18n.tr((String)"Downloading content for changeset {0} ...", (Object[])new Object[]{id}));
            OsmChangesetContentParser parser = new OsmChangesetContentParser(in);
            ChangesetDataSet changesetDataSet = ds = parser.parse(monitor.createSubTaskMonitor(1, true));
            return changesetDataSet;
        }
        catch (UnsupportedEncodingException e) {
            throw new OsmTransferException((Throwable)e);
        }
        catch (XmlParsingException e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            monitor.finishTask();
        }
    }
}

