/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import poly.PolyType;

public class PolyImporter
extends OsmImporter {
    public PolyImporter() {
        super(PolyType.FILE_FILTER);
    }

    protected DataSet parseDataSet(String source) throws IOException, SAXException, IllegalDataException {
        return this.parseDataSet((InputStream)new MirroredInputStream(source), NullProgressMonitor.INSTANCE);
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull((Object)in, (String)"in");
        BufferedReader reader = null;
        try {
            progressMonitor.beginTask(I18n.tr((String)"Reading polygon filter file...", (Object[])new Object[0]), 2);
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Reading polygon filter file...", (Object[])new Object[0]));
            reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
            List<Area> areas = this.loadPolygon(reader);
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Preparing data set...", (Object[])new Object[0]));
            DataSet ds = this.constructDataSet(areas);
            progressMonitor.worked(1);
            DataSet dataSet = ds;
            return dataSet;
        }
        catch (IOException e) {
            throw new IllegalDataException(I18n.tr((String)"Error reading poly file: {0}", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
            progressMonitor.finishTask();
        }
    }

    private List<Area> loadPolygon(BufferedReader reader) throws IllegalDataException, IOException {
        String name = reader.readLine();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalDataException(I18n.tr((String)"The file must begin with a polygon name", (Object[])new Object[0]));
        }
        ArrayList<Area> areas = new ArrayList<Area>();
        Area area = null;
        boolean parsingSection = false;
        int fixedCoords = 0;
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) {
                throw new IllegalDataException("File ended prematurely without END record");
            }
            if ((line = line.trim()).length() == 0) continue;
            if (line.equals("END")) {
                if (!parsingSection) break;
                if (area.getNodeCount() < 2) {
                    throw new IllegalDataException(I18n.tr((String)"There are less than 2 points in an area", (Object[])new Object[0]));
                }
                areas.add(area);
                if (areas.size() == 1) {
                    ((Area)areas.get(0)).setPolygonName(name);
                }
                parsingSection = false;
                continue;
            }
            if (!parsingSection) {
                area = new Area(line);
                parsingSection = true;
                continue;
            }
            String[] tokens = line.split("\\s+");
            double[] coords = new double[2];
            int tokenCount = 0;
            for (String token : tokens) {
                if (token.length() <= 0) continue;
                if (tokenCount > 2) {
                    throw new IllegalDataException(I18n.tr((String)"A polygon coordinate line must contain exactly 2 numbers", (Object[])new Object[0]));
                }
                try {
                    coords[tokenCount++] = Double.parseDouble(token);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(I18n.tr((String)"Unable to parse {0} as a number", (Object[])new Object[]{token}));
                }
            }
            if (tokenCount < 2) {
                throw new IllegalDataException(I18n.tr((String)"A polygon coordinate line must contain exactly 2 numbers", (Object[])new Object[0]));
            }
            LatLon coord = new LatLon(coords[1], coords[0]);
            if (!coord.isValid()) {
                double lat = coord.lat();
                double lon = coord.lon();
                if (lon < -180.0 && lon > -185.0) {
                    lon = -180.0;
                }
                if (lon > 180.0 && lon < 185.0) {
                    lon = 180.0;
                }
                if (lat < -90.0 && lat > -95.0) {
                    lat = -90.0;
                }
                if (lat > 90.0 && lat < 95.0) {
                    lat = 90.0;
                }
                ++fixedCoords;
                coord = new LatLon(lat, lon);
                if (!coord.isValid()) {
                    throw new IllegalDataException(I18n.tr((String)"Invalid coordinates were found: {0}, {1}", (Object[])new Object[]{coord.lat(), coord.lon()}));
                }
            }
            area.addNode(coord);
        }
        if (fixedCoords > 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"{0} points were outside world bounds and were moved", (Object[])new Object[]{fixedCoords}), "Import poly", 2);
        }
        return areas;
    }

    private DataSet constructDataSet(List<Area> areas) {
        DataSet ds = new DataSet();
        ds.setUploadDiscouraged(true);
        boolean foundInner = false;
        for (Area area : areas) {
            if (!area.isOuter()) {
                foundInner = true;
            }
            area.constructWay(ds);
        }
        if (foundInner) {
            Relation mp = new Relation();
            mp.put("type", "multipolygon");
            for (Area area : areas) {
                mp.addMember(new RelationMember(area.isOuter() ? "outer" : "inner", (OsmPrimitive)area.getWay()));
            }
            ds.addPrimitive((OsmPrimitive)mp);
        }
        return ds;
    }

    private class Area {
        private String name;
        private String polygonName;
        private List<LatLon> nodes;
        private boolean outer;
        private Way way;

        public Area(String name) {
            this.name = name;
            boolean bl = this.outer = name.charAt(0) != '!';
            if (!this.outer) {
                this.name = this.name.substring(1);
            }
            this.nodes = new ArrayList<LatLon>();
            this.way = null;
            this.polygonName = null;
        }

        public void setPolygonName(String polygonName) {
            this.polygonName = polygonName;
        }

        public void addNode(LatLon node) {
            if (this.nodes.isEmpty() || !this.nodes.get(this.nodes.size() - 1).equals((Object)node) && !this.nodes.get(0).equals((Object)node)) {
                this.nodes.add(node);
            }
        }

        public boolean isOuter() {
            return this.outer;
        }

        public int getNodeCount() {
            return this.nodes.size();
        }

        public Way getWay() {
            return this.way;
        }

        public void constructWay(DataSet ds) {
            this.way = new Way();
            for (LatLon coord : this.nodes) {
                Node node = new Node(coord);
                ds.addPrimitive((OsmPrimitive)node);
                this.way.addNode(node);
            }
            this.way.addNode(this.way.getNode(0));
            if (this.polygonName != null) {
                this.way.put("name", this.polygonName);
            }
            ds.addPrimitive((OsmPrimitive)this.way);
        }
    }
}

