/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.xobject.CompositeImage;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDJpeg
extends PDXObjectImage {
    private static final List<String> DCT_FILTERS = new ArrayList<String>();

    public PDJpeg(PDStream jpeg) {
        super(jpeg, "jpg");
    }

    public PDJpeg(PDDocument doc, InputStream is) throws IOException {
        super(new PDStream(doc, is, true), "jpg");
        COSStream dic = this.getCOSStream();
        dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
        BufferedImage image = this.getRGBImage();
        if (image != null) {
            this.setBitsPerComponent(8);
            this.setColorSpace(PDDeviceRGB.INSTANCE);
            this.setHeight(image.getHeight());
            this.setWidth(image.getWidth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDJpeg(PDDocument doc, BufferedImage bi) throws IOException {
        super(new PDStream(doc), "jpg");
        BufferedImage alpha = null;
        if (bi.getColorModel().hasAlpha()) {
            alpha = new BufferedImage(bi.getWidth(), bi.getHeight(), 10);
            Graphics2D g = alpha.createGraphics();
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, bi.getWidth(), bi.getHeight());
            g.setColor(Color.WHITE);
            g.drawImage((Image)bi, 0, 0, null);
            int alphaHeight = alpha.getHeight();
            int alphaWidth = alpha.getWidth();
            int whiteRGB = Color.WHITE.getRGB();
            for (int y = 0; y < alphaHeight; ++y) {
                for (int x = 0; x < alphaWidth; ++x) {
                    Color color = new Color(alpha.getRGB(x, y));
                    if (color.getRed() == 0 || color.getGreen() == 0 || color.getBlue() == 0) continue;
                    alpha.setRGB(x, y, whiteRGB);
                }
            }
            BufferedImage image = new BufferedImage(bi.getWidth(), bi.getHeight(), 8);
            g = image.createGraphics();
            g.drawImage((Image)bi, 0, 0, null);
            bi = image;
        }
        OutputStream os = this.getCOSStream().createFilteredStream();
        try {
            ImageIO.write((RenderedImage)bi, "jpeg", os);
            COSStream dic = this.getCOSStream();
            dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
            dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
            dic.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
            PDJpeg alphaPdImage = null;
            if (alpha != null) {
                alphaPdImage = new PDJpeg(doc, alpha);
                dic.setItem(COSName.SMASK, (COSObjectable)alphaPdImage);
            }
            this.setBitsPerComponent(8);
            if (bi.getColorModel().getNumComponents() == 3) {
                this.setColorSpace(PDDeviceRGB.INSTANCE);
            } else if (bi.getColorModel().getNumComponents() == 1) {
                this.setColorSpace(new PDDeviceGray());
            } else {
                throw new IllegalStateException();
            }
            this.setHeight(bi.getHeight());
            this.setWidth(bi.getWidth());
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getRGBImage() throws IOException {
        File imgFile = null;
        BufferedImage bi = null;
        boolean readError = false;
        try {
            imgFile = File.createTempFile("pdjpeg", ".jpeg");
            this.write2file(imgFile);
            try {
                bi = ImageIO.read(imgFile);
            }
            catch (IIOException iioe) {
                readError = true;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (bi == null && readError) {
                int read;
                byte[] newImage = this.replaceHeader(imgFile);
                ByteArrayInputStream bai = new ByteArrayInputStream(newImage);
                FileOutputStream o = new FileOutputStream(imgFile);
                byte[] buffer = new byte[512];
                while ((read = bai.read(buffer)) > 0) {
                    o.write(buffer, 0, read);
                }
                bai.close();
                o.close();
                bi = ImageIO.read(imgFile);
            }
        }
        finally {
            if (imgFile != null) {
                imgFile.delete();
            }
        }
        PDXObjectImage smask = this.getSMaskImage();
        if (smask != null) {
            BufferedImage smaskBI = smask.getRGBImage();
            COSArray decodeArray = smask.getDecode();
            CompositeImage compositeImage = new CompositeImage(bi, smaskBI);
            BufferedImage rgbImage = compositeImage.createMaskedImage(decodeArray);
            return rgbImage;
        }
        return bi;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        InputStream data = this.getPDStream().getPartiallyFilteredStream(DCT_FILTERS);
        byte[] buf = new byte[1024];
        int amountRead = -1;
        while ((amountRead = data.read(buf)) != -1) {
            out.write(buf, 0, amountRead);
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File is tooo large");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private int getHeaderEndPos(byte[] image) {
        for (int i = 0; i < image.length; ++i) {
            byte b = image[i];
            if (b != -37) continue;
            return i - 2;
        }
        return 0;
    }

    private byte[] replaceHeader(File jpegFile) throws IOException {
        byte[] image = PDJpeg.getBytesFromFile(jpegFile);
        int pos = this.getHeaderEndPos(image);
        byte[] header = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 1, 0, 96, 0, 96, 0, 0};
        byte[] newImage = new byte[image.length - pos + header.length - 1];
        System.arraycopy(header, 0, newImage, 0, header.length);
        System.arraycopy(image, pos + 1, newImage, header.length, image.length - pos - 1);
        return newImage;
    }

    static {
        DCT_FILTERS.add(COSName.DCT_DECODE.getName());
        DCT_FILTERS.add(COSName.DCT_DECODE_ABBREVIATION.getName());
    }
}

