/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SdsDiskAccessAction
extends DiskAccessAction {
    public SdsDiskAccessAction(String name, String iconName, String tooltip, Shortcut shortcut) {
        super(name, iconName, tooltip, shortcut);
    }

    public static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple, String title) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        if (title != null) {
            fc.setDialogTitle(title);
        }
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(multiple);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".sds") || pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return I18n.tr((String)"SDS data file", (Object[])new Object[0]);
            }
        });
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && (file = fc.getSelectedFile()) != null && file.exists()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Overwrite", (Object[])new Object[0]), new String[]{I18n.tr((String)"Overwrite", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
            dialog.setContent(I18n.tr((String)"File exists. Overwrite?", (Object[])new Object[0]));
            dialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                return null;
            }
        }
        return fc;
    }

    public static File createAndOpenSaveFileChooser(String title) {
        File file;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        if (title != null) {
            fc.setDialogTitle(title);
        }
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".sds") || pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return I18n.tr((String)"SDS data file", (Object[])new Object[0]);
            }
        });
        int answer = fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!SdsDiskAccessAction.confirmOverwrite(file = fc.getSelectedFile())) {
            return null;
        }
        return file;
    }

    public static boolean confirmOverwrite(File file) {
        if (file == null || file.exists()) {
            ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Overwrite", (Object[])new Object[0]), new String[]{I18n.tr((String)"Overwrite", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
            dialog.setContent(I18n.tr((String)"File exists. Overwrite?", (Object[])new Object[0]));
            dialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            dialog.showDialog();
            return dialog.getValue() == 1;
        }
        return true;
    }
}

