/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import public_transport.StopImporterDialog;
import public_transport.TrackReference;
import public_transport.TransText;

public class TrackStoplistNameCommand
extends Command {
    private int workingLine = 0;
    private TrackReference trackref = null;
    private String oldName = null;
    private String name = null;
    private String oldTime = null;
    private String time = null;
    private String oldShelter = null;
    private TransText shelter = null;
    private LatLon oldLatLon = null;

    public TrackStoplistNameCommand(TrackReference trackref, int workingLine) {
        this.trackref = trackref;
        this.workingLine = workingLine;
        Node node = trackref.stoplistTM.nodeAt(workingLine);
        if (node != null) {
            this.oldName = node.get("name");
            this.oldTime = trackref.stoplistTM.timeAt(workingLine);
            this.oldShelter = node.get("shelter");
            this.oldLatLon = node.getCoor();
        }
        this.time = (String)trackref.stoplistTM.getValueAt(workingLine, 0);
        this.name = (String)trackref.stoplistTM.getValueAt(workingLine, 1);
        this.shelter = (TransText)trackref.stoplistTM.getValueAt(workingLine, 2);
        if ("".equals(this.shelter.text)) {
            this.shelter = null;
        }
    }

    public boolean executeCommand() {
        Node node = this.trackref.stoplistTM.nodeAt(this.workingLine);
        if (node != null) {
            node.put("name", this.name);
            node.put("shelter", this.shelter.text);
            double dTime = StopImporterDialog.parseTime(this.time);
            node.setCoor(this.trackref.computeCoor(dTime));
        }
        this.trackref.inEvent = true;
        if (this.time == null) {
            this.trackref.stoplistTM.setValueAt("", this.workingLine, 0);
        } else {
            this.trackref.stoplistTM.setValueAt(this.time, this.workingLine, 0);
        }
        if (this.name == null) {
            this.trackref.stoplistTM.setValueAt("", this.workingLine, 1);
        } else {
            this.trackref.stoplistTM.setValueAt(this.name, this.workingLine, 1);
        }
        this.trackref.stoplistTM.setValueAt(this.shelter, this.workingLine, 2);
        this.trackref.inEvent = false;
        return true;
    }

    public void undoCommand() {
        Node node = this.trackref.stoplistTM.nodeAt(this.workingLine);
        if (node != null) {
            node.put("name", this.oldName);
            node.put("shelter", this.oldShelter);
            node.setCoor(this.oldLatLon);
        }
        this.trackref.inEvent = true;
        if (this.oldTime == null) {
            this.trackref.stoplistTM.setValueAt("", this.workingLine, 0);
        } else {
            this.trackref.stoplistTM.setValueAt(this.oldTime, this.workingLine, 0);
        }
        if (this.oldName == null) {
            this.trackref.stoplistTM.setValueAt("", this.workingLine, 1);
        } else {
            this.trackref.stoplistTM.setValueAt(this.oldName, this.workingLine, 1);
        }
        this.trackref.stoplistTM.setValueAt(new TransText(this.oldShelter), this.workingLine, 2);
        this.trackref.inEvent = false;
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Edit track stop list", (Object[])new Object[0]);
    }
}

