/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.directdownload.DownloadDataGui;
import org.openstreetmap.josm.plugins.directdownload.UserTrack;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DirectDownload
extends Plugin {
    private DownloadAction openaction = new DownloadAction();

    public DirectDownload(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)Main.main.menu.gpsMenu, (JosmAction)this.openaction);
    }

    class DownloadAction
    extends JosmAction {
        public DownloadAction() {
            super(I18n.tr((String)"Download Track ...", (Object[])new Object[0]), "DownloadAction", I18n.tr((String)"Download GPX track from openstreetmap.org", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent event) {
            DownloadDataGui go = new DownloadDataGui();
            go.setVisible(true);
            UserTrack track = go.getSelectedUserTrack();
            if (go.getValue() == 1 && track != null) {
                String urlString = OsmApi.getOsmApi().getBaseUrl() + "gpx/" + track.id + "/data";
                try {
                    URL trackDataUrl = new URL(urlString);
                    InputStream is = Utils.openURLAndDecompress((URL)trackDataUrl, (boolean)true);
                    GpxReader r = new GpxReader(is);
                    boolean parsedProperly = r.parse(true);
                    GpxLayer gpxLayer = new GpxLayer(r.getGpxData(), track.filename, true);
                    if (r.getGpxData().hasRoutePoints() || r.getGpxData().hasTrackPoints()) {
                        Main.main.addLayer((Layer)gpxLayer);
                    }
                    if (Main.pref.getBoolean("marker.makeautomarkers", true) && !r.getGpxData().waypoints.isEmpty()) {
                        MarkerLayer ml = new MarkerLayer(r.getGpxData(), I18n.tr((String)"Markers from {0}", (Object[])new Object[]{track.filename}), null, gpxLayer);
                        if (ml.data.size() > 0) {
                            Main.main.addLayer((Layer)ml);
                        }
                    }
                    if (!parsedProperly) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error occurred while parsing gpx file {0}. Only a part of the file will be available.", (Object[])new Object[]{urlString}));
                    }
                }
                catch (MalformedURLException e) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Invalid URL {0}", (Object[])new Object[]{urlString}));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error fetching URL {0}", (Object[])new Object[]{urlString}));
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error parsing data from URL {0}", (Object[])new Object[]{urlString}));
                }
            }
        }
    }
}

