/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.j7zip.SevenZip.Archive.IInArchive;
import org.j7zip.SevenZip.Archive.SevenZip.Handler;
import org.j7zip.SevenZip.ArchiveExtractCallback;
import org.j7zip.SevenZip.MyRandomAccessFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ArchiveReader;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class SevenZipReader
extends ArchiveReader {
    private final IInArchive archive = new Handler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SevenZipReader(InputStream in, AbstractDataSetHandler handler, boolean promptUser) throws IOException {
        super(handler, handler != null ? handler.getArchiveHandler() : null, promptUser);
        FileOutputStream out = null;
        try {
            File tmpFile = File.createTempFile("7z_", ".7z", OdUtils.createTempDir());
            out = new FileOutputStream(tmpFile);
            Utils.copyStream((InputStream)in, (OutputStream)out);
            Utils.close((Closeable)out);
            out = null;
            MyRandomAccessFile random = new MyRandomAccessFile(tmpFile.getPath(), "r");
            if (this.archive.Open(random) != 0) {
                String message = "Unable to open 7z archive: " + tmpFile.getPath();
                Main.warn((String)message);
                ((InputStream)random).close();
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
                throw new IOException(message);
            }
        }
        catch (Throwable throwable) {
            Utils.close(out);
            throw throwable;
        }
        Utils.close((Closeable)out);
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance, boolean promptUser) throws IOException, XMLStreamException, FactoryConfigurationError, JAXBException {
        return new SevenZipReader(in, handler, promptUser).parseDoc(instance);
    }

    @Override
    protected String getTaskMessage() {
        return I18n.tr((String)"Reading 7Zip file...", (Object[])new Object[0]);
    }

    @Override
    protected void extractArchive(File temp, List<File> candidates) throws IOException, FileNotFoundException {
        this.archive.Extract(null, -1, 0, new ExtractCallback(this.archive, temp, candidates));
    }

    private class ExtractCallback
    extends ArchiveExtractCallback {
        private final List<File> candidates;

        public ExtractCallback(IInArchive archive, File tempDir, List<File> candidates) {
            this.Init(archive);
            this.outputDir = tempDir.getPath();
            this.candidates = candidates;
        }

        @Override
        public int GetStream(int index, OutputStream[] outStream, int askExtractMode) throws IOException {
            int res = super.GetStream(index, outStream, askExtractMode);
            if (res == 0) {
                SevenZipReader.this.lookForCandidate(this._filePath, this.candidates, this.file);
            }
            return res;
        }
    }
}

