/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Element;
import org.jdom.Namespace;

public class ChildCreator {
    private final Element content;
    private final List<Element> elemsOrder;

    protected ChildCreator(Element element, List<Element> list) {
        if (element == null) {
            throw new NullPointerException("null content");
        }
        this.content = element;
        this.elemsOrder = new ArrayList<Element>(list);
    }

    public final Element getElement() {
        return this.content;
    }

    public final Element getChild(Namespace namespace, String string) {
        return this.getChild(namespace, string, false);
    }

    private final int indexOf(Namespace namespace, String string) {
        for (int i = 0; i < this.elemsOrder.size(); ++i) {
            Element element = this.elemsOrder.get(i);
            if (!element.getNamespace().equals((Object)namespace) || !element.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private final int indexOf(Element element) {
        return this.indexOf(element.getNamespace(), element.getName());
    }

    private final int findInsertIndex(Namespace namespace, String string) {
        int n = this.indexOf(namespace, string);
        if (n == -1) {
            throw new IllegalArgumentException(string + " is unknown.");
        }
        Element element = this.getChild(namespace, string);
        if (element != null) {
            return this.getElement().getChildren().indexOf(element) + 1;
        }
        List list = this.getElement().getChildren();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            if (this.indexOf(element2) <= n) continue;
            return listIterator.previousIndex();
        }
        return list.size();
    }

    private final void insertChild(Element element) {
        this.getElement().getChildren().add(this.findInsertIndex(element.getNamespace(), element.getName()), element);
    }

    public final Element getChild(Namespace namespace, String string, boolean bl) {
        Element element = this.getElement().getChild(string, namespace);
        if (bl && element == null) {
            element = new Element(string, namespace);
            this.insertChild(element);
        }
        return element;
    }
}

