/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.media.jai.BorderExtender;
import javax.media.jai.PlanarImage;
import org.jaitools.numeric.NumberOperations;

public class RandomBorderExtender
extends BorderExtender {
    private final Number minValueN;
    private final Number maxValueN;
    private final Random rand;

    public RandomBorderExtender(Number minValue, Number maxValue) {
        this.minValueN = NumberOperations.newInstance(minValue, minValue.getClass());
        this.maxValueN = NumberOperations.newInstance(maxValue, maxValue.getClass());
        this.rand = new Random();
    }

    public void extend(WritableRaster raster, PlanarImage sourceImage) {
        int dataType = raster.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                this.extendAsByte(raster, sourceImage);
                break;
            }
            case 2: {
                this.extendAsShort(raster, sourceImage);
                break;
            }
            case 1: {
                this.extendAsUShort(raster, sourceImage);
                break;
            }
            case 3: {
                this.extendAsInt(raster, sourceImage);
                break;
            }
            case 4: {
                this.extendAsFloat(raster, sourceImage);
                break;
            }
            case 5: {
                this.extendAsDouble(raster, sourceImage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type");
            }
        }
    }

    private void extendAsByte(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        int minValue = NumberOperations.intValue(this.minValueN);
        int maxValue = NumberOperations.intValue(this.maxValueN);
        int range = maxValue - minValue;
        for (int b = 0; b < raster.getNumBands(); ++b) {
            int y = raster.getMinY();
            for (int ny = 0; ny < raster.getHeight(); ++ny) {
                int x = raster.getMinX();
                for (int nx = 0; nx < raster.getWidth(); ++nx) {
                    if (!bounds.contains(x, y)) {
                        int value = (int)this.clamp(this.rand.nextInt(range) + minValue, 0L, 255L);
                        raster.setSample(x, y, b, value);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private void extendAsShort(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        int minValue = NumberOperations.intValue(this.minValueN);
        int maxValue = NumberOperations.intValue(this.maxValueN);
        int range = maxValue - minValue;
        for (int b = 0; b < raster.getNumBands(); ++b) {
            int y = raster.getMinY();
            for (int ny = 0; ny < raster.getHeight(); ++ny) {
                int x = raster.getMinX();
                for (int nx = 0; nx < raster.getWidth(); ++nx) {
                    if (!bounds.contains(x, y)) {
                        int value = (int)this.clamp(this.rand.nextInt(range) + minValue, -32768L, 32767L);
                        raster.setSample(x, y, b, value);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private void extendAsUShort(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        int minValue = NumberOperations.intValue(this.minValueN);
        int maxValue = NumberOperations.intValue(this.maxValueN);
        int range = maxValue - minValue;
        for (int b = 0; b < raster.getNumBands(); ++b) {
            int y = raster.getMinY();
            for (int ny = 0; ny < raster.getHeight(); ++ny) {
                int x = raster.getMinX();
                for (int nx = 0; nx < raster.getWidth(); ++nx) {
                    if (!bounds.contains(x, y)) {
                        int value = (int)this.clamp(this.rand.nextInt(range) + minValue, 0L, 65535L);
                        raster.setSample(x, y, b, value);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private void extendAsInt(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        int minValue = NumberOperations.intValue(this.minValueN);
        int maxValue = NumberOperations.intValue(this.maxValueN);
        int range = maxValue - minValue;
        for (int b = 0; b < raster.getNumBands(); ++b) {
            int y = raster.getMinY();
            for (int ny = 0; ny < raster.getHeight(); ++ny) {
                int x = raster.getMinX();
                for (int nx = 0; nx < raster.getWidth(); ++nx) {
                    if (!bounds.contains(x, y)) {
                        int value = (int)this.clamp(this.rand.nextInt(range) + minValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        raster.setSample(x, y, b, value);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private void extendAsFloat(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        float minValue = NumberOperations.floatValue(this.minValueN);
        float maxValue = NumberOperations.floatValue(this.maxValueN);
        float range = maxValue - minValue;
        for (int b = 0; b < raster.getNumBands(); ++b) {
            int y = raster.getMinY();
            for (int ny = 0; ny < raster.getHeight(); ++ny) {
                int x = raster.getMinX();
                for (int nx = 0; nx < raster.getWidth(); ++nx) {
                    if (!bounds.contains(x, y)) {
                        float value = this.rand.nextFloat() * range + minValue;
                        raster.setSample(x, y, b, value);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private void extendAsDouble(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        double minValue = NumberOperations.doubleValue(this.minValueN);
        double maxValue = NumberOperations.doubleValue(this.maxValueN);
        double range = maxValue - minValue;
        for (int b = 0; b < raster.getNumBands(); ++b) {
            int y = raster.getMinY();
            for (int ny = 0; ny < raster.getHeight(); ++ny) {
                int x = raster.getMinX();
                for (int nx = 0; nx < raster.getWidth(); ++nx) {
                    if (!bounds.contains(x, y)) {
                        double value = this.rand.nextDouble() * range + minValue;
                        raster.setSample(x, y, b, value);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    private long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }
}

