/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Date;
import org.geotools.temporal.object.DefaultTemporalCoordinate;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalCoordinateSystem
extends DefaultTemporalReferenceSystem
implements TemporalCoordinateSystem {
    private Date origin;
    private InternationalString interval;

    public DefaultTemporalCoordinateSystem(ReferenceIdentifier name, Extent domainOfValidity, Date origin, InternationalString interval) {
        super(name, domainOfValidity);
        this.origin = origin;
        this.interval = interval;
    }

    public void setOrigin(Date origin) {
        this.origin = origin;
    }

    public void setInterval(InternationalString interval) {
        this.interval = interval;
    }

    @Override
    public Date getOrigin() {
        return this.origin;
    }

    @Override
    public InternationalString getInterval() {
        return this.interval;
    }

    @Override
    public Date transformCoord(TemporalCoordinate c_value) {
        long yearMS = 31536000000L;
        long monthMS = 2628000000L;
        long weekMS = 604800000L;
        long dayMS = 86400000L;
        long hourMS = 3600000L;
        long minMS = 60000L;
        long secondMS = 1000L;
        DefaultTemporalCoordinate value = (DefaultTemporalCoordinate)c_value;
        Number f = 0;
        if (value.getFrame() != null && value.getFrame() instanceof TemporalCoordinateSystem) {
            if (value.getCoordinateValue() != null) {
                float n = value.getCoordinateValue().floatValue();
                if (((Object)this.interval).toString().equals("year")) {
                    f = Float.valueOf(n * 3.1536E10f);
                } else if (((Object)this.interval).toString().equals("month")) {
                    f = Float.valueOf(n * 2.628E9f);
                } else if (((Object)this.interval).toString().equals("week")) {
                    f = Float.valueOf(n * 6.048E8f);
                } else if (((Object)this.interval).toString().equals("day")) {
                    f = Float.valueOf(n * 8.64E7f);
                } else if (((Object)this.interval).toString().equals("hour")) {
                    f = Float.valueOf(n * 3600000.0f);
                } else if (((Object)this.interval).toString().equals("minute")) {
                    f = Float.valueOf(n * 60000.0f);
                } else if (((Object)this.interval).toString().equals("second")) {
                    f = Float.valueOf(n * 1000.0f);
                } else if (((Object)this.interval).toString().equals("millisecond")) {
                    f = Float.valueOf(n);
                } else {
                    throw new IllegalArgumentException("The name of a single unit of measure used as the base interval for the scale in this current TemporalCoordinateSystem is not supported !");
                }
                Date response = new Date(this.origin.getTime() + f.longValue());
                return response;
            }
            return null;
        }
        throw new IllegalArgumentException("The TemporalCoordinate argument must be a TemporalCoordinate ! ");
    }

    @Override
    public TemporalCoordinate transformDateTime(Date dateTime) {
        long yearMS = 31536000000L;
        long monthMS = 2628000000L;
        long weekMS = 604800000L;
        long dayMS = 86400000L;
        long hourMS = 3600000L;
        long minMS = 60000L;
        long secondMS = 1000L;
        Number coordinateValue = Math.abs(dateTime.getTime() - this.origin.getTime());
        if (((Object)this.interval).toString().equals("year")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 3.1536E10f);
        } else if (((Object)this.interval).toString().equals("month")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 2.628E9f);
        } else if (((Object)this.interval).toString().equals("week")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 6.048E8f);
        } else if (((Object)this.interval).toString().equals("day")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 8.64E7f);
        } else if (((Object)this.interval).toString().equals("hour")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 3600000.0f);
        } else if (((Object)this.interval).toString().equals("minute")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 60000.0f);
        } else if (((Object)this.interval).toString().equals("second")) {
            coordinateValue = Float.valueOf((float)coordinateValue.longValue() / 1000.0f);
        }
        DefaultTemporalCoordinate response = new DefaultTemporalCoordinate(this, null, coordinateValue);
        return response;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultTemporalCoordinateSystem && super.equals(object) && object instanceof DefaultTemporalCoordinateSystem) {
            DefaultTemporalCoordinateSystem that = (DefaultTemporalCoordinateSystem)object;
            return Utilities.equals(this.interval, that.interval) && Utilities.equals(this.origin, that.origin);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.interval != null ? this.interval.hashCode() : 0);
        hash = 37 * hash + (this.origin != null ? this.origin.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("TemporalCoordinateSystem:").append('\n');
        if (this.interval != null) {
            s.append("interval:").append(this.interval).append('\n');
        }
        if (this.origin != null) {
            s.append("origin:").append(this.origin).append('\n');
        }
        return s.toString();
    }
}

