/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Literal;

public class EnvFunction
extends FunctionExpressionImpl {
    private static final LocalLookup localLookup = new LocalLookup();
    private static ConcurrentMap<String, Object> globalLookup = new ConcurrentHashMap<String, Object>();
    public static FunctionName NAME = new FunctionNameImpl("env", FunctionNameImpl.parameter("value", Object.class), FunctionNameImpl.parameter("variable", String.class));

    public EnvFunction() {
        super(NAME);
    }

    public static void setLocalValues(Map<String, Object> values) {
        Map<String, Object> table = localLookup.getTable();
        table.clear();
        if (values != null) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                table.put(e.getKey().toUpperCase(), e.getValue());
            }
        }
    }

    public static void clearLocalValues() {
        localLookup.getTable().clear();
        localLookup.remove();
    }

    public static void setGlobalValues(Map<String, Object> values) {
        globalLookup.clear();
        if (values != null) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                globalLookup.put(e.getKey().toUpperCase(), e.getValue());
            }
        }
    }

    public static void clearGlobalValues() {
        globalLookup.clear();
    }

    public static void setLocalValue(String name, Object value) {
        localLookup.getTable().put(name.toUpperCase(), value);
    }

    public static void setGlobalValue(String name, Object value) {
        globalLookup.put(name.toUpperCase(), value);
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    @Override
    public Object evaluate(Object feature) {
        int paramSize;
        String varName = this.getExpression(0).evaluate(feature, String.class);
        Object value = localLookup.getTable().get(varName.toUpperCase());
        if (value == null) {
            value = globalLookup.get(varName.toUpperCase());
        }
        if (value == null && (paramSize = this.getParameters().size()) > this.getArgCount()) {
            value = this.getExpression(paramSize - 1).evaluate(feature);
        }
        return value;
    }

    @Override
    public void setParameters(List params) {
        if (params == null) {
            throw new NullPointerException("params can't be null");
        }
        int argCount = this.getArgCount();
        int paramsSize = params.size();
        if (paramsSize < argCount || paramsSize > argCount + 1) {
            throw new IllegalArgumentException(String.format("Function %s expected %d or %d arguments but got %d", this.name, argCount, argCount + 1, paramsSize));
        }
        this.params = new ArrayList(params);
    }

    @Override
    public void setFallbackValue(Literal fallback) {
        Logger logger = Logger.getLogger(EnvFunction.class.getName());
        logger.log(Level.WARNING, "The setFallbackValue is not supported by this function.Use a second argument when calling the function to provide a default value.");
    }

    private static class LocalLookup
    extends ThreadLocal<Map<String, Object>> {
        private LocalLookup() {
        }

        @Override
        protected Map<String, Object> initialValue() {
            return new LinkedHashMap<String, Object>();
        }

        public Map<String, Object> getTable() {
            return (Map)super.get();
        }
    }
}

