/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.measure.DecimalMeasure;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;

public abstract class MeasureFormat
extends Format {
    static final NumberUnit DEFAULT = new NumberUnit(NumberFormat.getInstance(), UnitFormat.getInstance());

    public static MeasureFormat getInstance() {
        return DEFAULT;
    }

    public static MeasureFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new NumberUnit(numberFormat, unitFormat);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NumberUnit
    extends MeasureFormat {
        private final NumberFormat _numberFormat;
        private final UnitFormat _unitFormat;
        private static final long serialVersionUID = 1L;

        private NumberUnit(NumberFormat numberFormat, UnitFormat unitFormat) {
            this._numberFormat = numberFormat;
            this._unitFormat = unitFormat;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Measure measure = (Measure)obj;
            Object value = measure.getValue();
            Unit unit = measure.getUnit();
            if (value instanceof Number) {
                if (unit instanceof CompoundUnit) {
                    return this.formatCompound(((Number)value).doubleValue(), (CompoundUnit)unit, toAppendTo, pos);
                }
                this._numberFormat.format(value, toAppendTo, pos);
            } else {
                toAppendTo.append(value);
            }
            if (!measure.getUnit().equals(Unit.ONE)) {
                toAppendTo.append(' ');
                this._unitFormat.format(unit, toAppendTo, pos);
            }
            return toAppendTo;
        }

        StringBuffer formatCompound(double value, Unit<?> unit, StringBuffer toAppendTo, FieldPosition pos) {
            if (!(unit instanceof CompoundUnit)) {
                toAppendTo.append((long)value);
                return this._unitFormat.format(unit, toAppendTo, pos);
            }
            Unit high = ((CompoundUnit)unit).getHigher();
            Unit low = ((CompoundUnit)unit).getLower();
            long highValue = (long)low.getConverterTo(high).convert(value);
            double lowValue = value - high.getConverterTo(low).convert(highValue);
            this.formatCompound(highValue, high, toAppendTo, pos);
            this.formatCompound(lowValue, low, toAppendTo, pos);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            int start = pos.getIndex();
            try {
                boolean isCompound;
                int i = start;
                Number value = this._numberFormat.parse(source, pos);
                if (i == pos.getIndex()) {
                    return null;
                }
                i = pos.getIndex();
                if (i >= source.length()) {
                    return NumberUnit.measureOf(value, Unit.ONE);
                }
                boolean bl = isCompound = !Character.isWhitespace(source.charAt(i));
                if (isCompound) {
                    return this.parseCompound(value, source, pos);
                }
                if (++i >= source.length()) {
                    return NumberUnit.measureOf(value, Unit.ONE);
                }
                pos.setIndex(i);
                Unit<? extends Quantity> unit = this._unitFormat.parseProductUnit(source, pos);
                return NumberUnit.measureOf(value, unit);
            }
            catch (ParseException e) {
                pos.setIndex(start);
                pos.setErrorIndex(e.getErrorOffset());
                return null;
            }
        }

        private Object parseCompound(Number highValue, String source, ParsePosition pos) throws ParseException {
            Unit<? extends Quantity> high = this._unitFormat.parseSingleUnit(source, pos);
            int i = pos.getIndex();
            if (i >= source.length() || Character.isWhitespace(source.charAt(i))) {
                return NumberUnit.measureOf(highValue, high);
            }
            Measure lowMeasure = (Measure)this.parseObject(source, pos);
            Unit unit = lowMeasure.getUnit();
            long l = lowMeasure.longValue(unit) + (long)high.getConverterTo(unit).convert(highValue.longValue());
            return Measure.valueOf(l, unit);
        }

        private static Measure measureOf(Number value, Unit unit) {
            if (value instanceof Double) {
                return Measure.valueOf(value.doubleValue(), unit);
            }
            if (value instanceof Long) {
                return Measure.valueOf(value.longValue(), unit);
            }
            if (value instanceof Float) {
                return Measure.valueOf(value.floatValue(), unit);
            }
            if (value instanceof Integer) {
                return Measure.valueOf(value.intValue(), unit);
            }
            if (value instanceof BigDecimal) {
                return DecimalMeasure.valueOf((BigDecimal)value, unit);
            }
            return Measure.valueOf(value.doubleValue(), unit);
        }
    }
}

