/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.Constants;
import org.openstreetmap.josm.plugins.turnlanes.model.GenericCommand;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.I18n;

public final class Turn {
    private final Relation relation;
    private final Lane from;
    private final List<Road> via;
    private final Road.End to;

    static Set<Turn> load(ModelContainer c, String role, OsmPrimitive primitive) {
        HashSet<Turn> result = new HashSet<Turn>();
        for (Relation r : OsmPrimitive.getFilteredList((Collection)primitive.getReferrers(), Relation.class)) {
            if (!r.isUsable() || !r.get("type").equals("turnlanes:turns")) continue;
            for (RelationMember m : r.getMembers()) {
                if (!m.getRole().equals(role) || !m.getMember().equals((Object)primitive)) continue;
                result.addAll(Turn.load(c, r));
            }
        }
        return result;
    }

    static Set<Turn> load(ModelContainer c, Relation r) {
        for (RelationMember m : r.getMembers()) {
            if (!m.getRole().equals("via")) continue;
            if (m.isNode()) {
                return Turn.loadWithViaNode(c, r);
            }
            if (!m.isWay()) continue;
            return Turn.loadWithViaWays(c, r);
        }
        throw new IllegalArgumentException("No via node or way(s).");
    }

    private static Set<Turn> loadWithViaWays(ModelContainer c, Relation r) {
        Way from = Utils.getMemberWay(r, "from");
        Way to = Utils.getMemberWay(r, "to");
        if (!c.hasRoad(from) || !c.hasRoad(to)) {
            return Collections.emptySet();
        }
        List<Way> tmp = Utils.getMemberWays(r, "via");
        LinkedList<Road> via = new LinkedList<Road>();
        Road.End fromRoadEnd = c.getJunction(Utils.lineUp(from, tmp.get(0))).getRoadEnd(from);
        Node n = fromRoadEnd.getJunction().getNode();
        Iterator<Way> it = tmp.iterator();
        while (it.hasNext()) {
            Way w = it.next();
            if (!c.hasRoad(w)) {
                return Collections.emptySet();
            }
            Road v = c.getRoad(w);
            via.add(v);
            n = Utils.getOppositeEnd(w, n);
            if (!v.isPrimary()) {
                throw new IllegalStateException("The road is not part of the junction.");
            }
            Iterator<Route.Segment> it2 = (v.getRoute().getFirstSegment().getWay().equals((Object)w) ? v.getRoute().getSegments() : CollectionUtils.reverse(v.getRoute().getSegments())).iterator();
            it2.next();
            while (it2.hasNext()) {
                Way w2 = it2.next().getWay();
                n = Utils.getOppositeEnd(w2, n);
                if (it.hasNext() && w2.equals((Object)it.next())) continue;
                throw new IllegalStateException("The via ways of the relation do not form a road.");
            }
        }
        Road.End toRoadEnd = c.getJunction(n).getRoadEnd(to);
        n = Utils.getOppositeEnd(to, n);
        HashSet<Turn> result = new HashSet<Turn>();
        for (int i : Turn.indices(r, "lanes")) {
            result.add(new Turn(r, fromRoadEnd.getLane(Lane.Kind.REGULAR, i), via, toRoadEnd));
        }
        for (int i : Turn.indices(r, "lanes:extra")) {
            result.add(new Turn(r, fromRoadEnd.getExtraLane(i), via, toRoadEnd));
        }
        return result;
    }

    static List<Integer> indices(Relation r, String key) {
        String joined = r.get(key);
        if (joined == null) {
            return new ArrayList<Integer>(1);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String lane : Constants.SPLIT_PATTERN.split(joined)) {
            result.add(Integer.parseInt(lane));
        }
        return result;
    }

    private static Set<Turn> loadWithViaNode(ModelContainer c, Relation r) {
        Way from = Utils.getMemberWay(r, "from");
        Node via = Utils.getMemberNode(r, "via");
        Way to = Utils.getMemberWay(r, "to");
        if (!(c.hasRoad(from) && c.hasJunction(via) && c.hasRoad(to))) {
            return Collections.emptySet();
        }
        Junction j = c.getJunction(via);
        Road.End fromRoadEnd = j.getRoadEnd(from);
        Road.End toRoadEnd = j.getRoadEnd(to);
        HashSet<Turn> result = new HashSet<Turn>();
        for (int i : Turn.indices(r, "lanes")) {
            result.add(new Turn(r, fromRoadEnd.getLane(Lane.Kind.REGULAR, i), Collections.<Road>emptyList(), toRoadEnd));
        }
        for (int i : Turn.indices(r, "lanes:extra")) {
            result.add(new Turn(r, fromRoadEnd.getExtraLane(i), Collections.<Road>emptyList(), toRoadEnd));
        }
        return result;
    }

    static String join(List<Integer> list) {
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(list.size() * (2 + ";".length()));
        for (int e : list) {
            builder.append(e).append(";");
        }
        builder.setLength(builder.length() - ";".length());
        return builder.toString();
    }

    public Turn(Relation relation, Lane from, List<Road> via, Road.End to) {
        this.relation = relation;
        this.from = from;
        this.via = via;
        this.to = to;
    }

    public Lane getFrom() {
        return this.from;
    }

    public List<Road> getVia() {
        return this.via;
    }

    public Road.End getTo() {
        return this.to;
    }

    Relation getRelation() {
        return this.relation;
    }

    public void remove() {
        GenericCommand cmd = new GenericCommand(this.relation.getDataSet(), I18n.tr((String)"Delete turn.", (Object[])new Object[0]));
        this.remove(cmd);
        Main.main.undoRedo.add((Command)cmd);
    }

    void remove(GenericCommand cmd) {
        List<Integer> lanes = Turn.indices(this.relation, "lanes");
        List<Integer> extraLanes = Turn.indices(this.relation, "lanes:extra");
        if (lanes.size() + extraLanes.size() == 1 && this.from.isExtra() ^ !lanes.isEmpty()) {
            cmd.backup((OsmPrimitive)this.relation).setDeleted(true);
        } else if (this.from.isExtra()) {
            extraLanes.remove((Object)this.from.getIndex());
        } else {
            lanes.remove((Object)this.from.getIndex());
        }
        cmd.backup((OsmPrimitive)this.relation).put("lanes", lanes.isEmpty() ? null : Turn.join(lanes));
        cmd.backup((OsmPrimitive)this.relation).put("lanes:extra", extraLanes.isEmpty() ? null : Turn.join(extraLanes));
    }

    void fixReferences(GenericCommand cmd, boolean left, int index) {
        ArrayList<Integer> fixed = new ArrayList<Integer>();
        for (int i : Turn.indices(this.relation, "lanes:extra")) {
            if (left ? i < index : i > index) {
                fixed.add(left ? i + 1 : i - 1);
                continue;
            }
            fixed.add(i);
        }
        cmd.backup((OsmPrimitive)this.relation).put("lanes:extra", Turn.join(fixed));
    }
}

