/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.preset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.tageditor.preset.Group;
import org.openstreetmap.josm.plugins.tageditor.preset.io.Parser;
import org.openstreetmap.josm.plugins.tageditor.preset.io.PresetIOException;
import org.openstreetmap.josm.tools.I18n;

public class Presets {
    private static Logger logger = Logger.getLogger(Presets.class.getName());
    private static Presets presets = null;
    private List<Group> groups = new ArrayList<Group>();

    public static void initPresets() {
        presets = new Presets();
        LinkedList<String> sources = new LinkedList<String>();
        if (Main.pref.getBoolean("taggingpreset.enable-defaults", true)) {
            sources.add("resource://data/defaultpresets.xml");
        }
        sources.addAll(Main.pref.getCollection("taggingpreset.sources", new LinkedList()));
        File zipIconArchive = null;
        for (String source : sources) {
            try {
                InputStreamReader r;
                MirroredInputStream s = new MirroredInputStream(source);
                InputStream zip = s.findZipEntryInputStream("xml", "preset");
                if (zip != null) {
                    zipIconArchive = s.getFile();
                }
                try {
                    r = new InputStreamReader((InputStream)s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader((InputStream)s);
                }
                presets = Presets.loadPresets(r, presets, zipIconArchive);
            }
            catch (PresetIOException e) {
                logger.log(Level.SEVERE, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}), e);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read tagging preset source: {0}", (Object[])new Object[]{source}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
    }

    public static Presets loadPresets(URL from) throws PresetIOException {
        try {
            URLConnection con = from.openConnection();
            con.connect();
            InputStreamReader reader = new InputStreamReader(con.getInputStream());
            return Presets.loadPresets(reader, null, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception caught while loading preset file", e);
            throw new PresetIOException(e);
        }
    }

    public static Presets loadPresets(Reader reader, Presets p, File zipIconArchive) throws PresetIOException {
        try {
            Parser parser = new Parser();
            parser.setReader(reader);
            parser.setPresets(p);
            parser.parse();
            return parser.getPresets();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception caught while loading presets", e);
            throw new PresetIOException(e);
        }
    }

    public static Presets getPresets() {
        if (presets == null) {
            Presets.initPresets();
        }
        return presets;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public List<Group> getGroups() {
        return this.groups;
    }
}

