/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.xml.sax.SAXException;

public class ValidatingImageryReader
extends ImageryReader
implements XmlBoundsConstants {
    public ValidatingImageryReader(String source) throws SAXException, IOException {
        this(source, true);
    }

    public ValidatingImageryReader(String source, boolean validateFirst) throws SAXException, IOException {
        super(source);
        if (validateFirst) {
            ValidatingImageryReader.validate(source);
        }
    }

    public static void validate(String source) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource((InputStream)new MirroredInputStream("resource://data/maps.xsd")));
        schema.newValidator().validate(new StreamSource(source));
    }
}

