/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;

public class CreateRelationAction
extends JosmAction {
    private static final String PREF_LASTTYPE = "reltoolbox.createrelation.lasttype";
    protected ChosenRelation chRel;
    private static final List<String> RELATION_TYPES = Arrays.asList("multipolygon", "boundary", "route", "site", "restriction", "associatedStreet", "public_transport", "street", "collection", "address", "enforcement", "destination_sign", "route_master", "junction", "waterway", "bridge", "tunnel", "surveillance");

    public CreateRelationAction(ChosenRelation chRel) {
        super(I18n.tr((String)"New", (Object[])new Object[0]), "data/relation", I18n.tr((String)"Create a relation from selected objects", (Object[])new Object[0]), Shortcut.registerShortcut((String)"reltoolbox:create", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Create a new relation", (Object[])new Object[0])}), (int)78, (int)5008), false);
        this.chRel = chRel;
        this.updateEnabledState();
    }

    public CreateRelationAction() {
        this(null);
    }

    public void actionPerformed(ActionEvent e) {
        String type = this.askForType();
        if (type == null) {
            return;
        }
        Relation rel = new Relation();
        if (type.length() > 0) {
            rel.put("type", type);
        }
        for (OsmPrimitive selected : CreateRelationAction.getCurrentDataSet().getSelected()) {
            rel.addMember(new RelationMember("", selected));
        }
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)rel));
        if (this.chRel != null) {
            this.chRel.set(rel);
        }
    }

    protected void updateEnabledState() {
        if (CreateRelationAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateRelationAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private String askForType() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Choose a type for the relation:", (Object[])new Object[0])), GBC.eol().insets(0, 0, 0, 5));
        final AutoCompletingComboBox keys = new AutoCompletingComboBox();
        keys.setPossibleItems(RELATION_TYPES);
        keys.setEditable(true);
        keys.getEditor().setItem(Main.pref.get(PREF_LASTTYPE, "multipolygon"));
        panel.add((Component)new JLabel(I18n.tr((String)"Type", (Object[])new Object[0])), GBC.std());
        panel.add(Box.createHorizontalStrut(10), GBC.std());
        panel.add((Component)keys, GBC.eol().fill(2));
        final JOptionPane optionPane = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                keys.requestFocusInWindow();
                keys.getEditor().selectAll();
            }
        };
        final JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Create a new relation", (Object[])new Object[0]));
        dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        keys.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                optionPane.setValue(0);
            }
        });
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            return null;
        }
        String result = keys.getEditor().getItem().toString().trim();
        Main.pref.put(PREF_LASTTYPE, result);
        return result;
    }
}

