/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.formats.pnm.FileInfo;
import org.apache.sanselan.formats.pnm.WhiteSpaceReader;

public class PGMFileInfo
extends FileInfo {
    private final int max;

    public PGMFileInfo(int width, int height, boolean RAWBITS, int max) {
        super(width, height, RAWBITS);
        this.max = max;
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public int getBitDepth() {
        return 8;
    }

    @Override
    public ImageFormat getImageType() {
        return ImageFormat.IMAGE_FORMAT_PPM;
    }

    @Override
    public String getImageTypeDescription() {
        return "PGM: portable pixmap file\tformat";
    }

    @Override
    public String getMIMEType() {
        return "image/x-portable-pixmap";
    }

    @Override
    public int getColorType() {
        return 2;
    }

    @Override
    public int getRGB(InputStream is) throws IOException {
        int sample = is.read();
        if (sample < 0) {
            throw new IOException("PGM: Unexpected EOF");
        }
        int alpha = 255;
        int rgb = (0xFF & alpha) << 24 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & sample) << 0;
        return rgb;
    }

    @Override
    public int getRGB(WhiteSpaceReader wsr) throws IOException {
        int sample = Integer.parseInt(wsr.readtoWhiteSpace());
        int alpha = 255;
        int rgb = (0xFF & alpha) << 24 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & sample) << 0;
        return rgb;
    }
}

