/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.ButtonDescription;
import at.dallermassl.josm.plugin.surveyor.SurveyorActionDescription;
import at.dallermassl.josm.plugin.surveyor.SurveyorComponent;
import at.dallermassl.josm.plugin.surveyor.SurveyorPlugin;
import at.dallermassl.josm.plugin.surveyor.util.ResourceLoader;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import livegps.LiveGpsPlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public class SurveyorShowAction
extends JosmAction {
    private static final long serialVersionUID = 2184570223633094734L;
    private static final String DEFAULT_SOURCE = "resource://resources/surveyor.xml";
    private JFrame surveyorFrame;
    private LiveGpsPlugin gpsPlugin;

    public SurveyorShowAction(LiveGpsPlugin gpsPlugin) {
        super(I18n.tr((String)"Surveyor...", (Object[])new Object[0]), "surveyormenu.png", I18n.tr((String)"Open surveyor tool.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"surveyor:open", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Surveyor...", (Object[])new Object[0])}), (int)82, (int)5009), true);
        this.gpsPlugin = gpsPlugin;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.surveyorFrame == null) {
            this.surveyorFrame = new JFrame();
            SurveyorComponent comp = this.createComponent();
            this.gpsPlugin.addPropertyChangeListener((PropertyChangeListener)comp);
            ActionMap actionMap = comp.getActionMap();
            InputMap inputMap = comp.getInputMap();
            actionMap.put("zoomout", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Main.map != null && Main.map.mapView != null) {
                        Main.map.mapView.zoomToFactor(2.0);
                    }
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(33, 0), "zoomout");
            actionMap.put("zoomin", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Main.map != null && Main.map.mapView != null) {
                        Main.map.mapView.zoomToFactor(0.0);
                    }
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(34, 0), "zoomin");
            actionMap.put("autocenter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SurveyorShowAction.this.gpsPlugin.setAutoCenter(!SurveyorShowAction.this.gpsPlugin.isAutoCenter());
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(36, 0), "autocenter");
            this.surveyorFrame.add(comp);
            this.surveyorFrame.pack();
            this.surveyorFrame.setDefaultCloseOperation(1);
            this.surveyorFrame.setTitle(I18n.tr((String)"Surveyor", (Object[])new Object[0]));
            SurveyorPlugin.setSurveyorFrame(this.surveyorFrame);
        }
        this.surveyorFrame.setAlwaysOnTop(true);
        this.surveyorFrame.setVisible(true);
    }

    public SurveyorComponent createComponent() {
        InputStream in = null;
        String source = Main.pref.get("surveyor.source");
        if (source == null || source.length() == 0) {
            source = DEFAULT_SOURCE;
            Main.pref.put("surveyor.source", DEFAULT_SOURCE);
        }
        SurveyorComponent component = null;
        try {
            in = ResourceLoader.getInputStream(source);
            component = this.createComponent(in);
            in.close();
            return component;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read surveyor definition: {0}", (Object[])new Object[]{source}));
        }
        catch (SAXException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error parsing {0}: {1}", (Object[])new Object[]{source, e.getMessage()}));
        }
        return component;
    }

    public SurveyorComponent createComponent(InputStream in) throws SAXException {
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("surveyor", SurveyorComponent.class);
        parser.map("button", ButtonDescription.class);
        parser.map("action", SurveyorActionDescription.class);
        SurveyorComponent surveyorComponent = null;
        parser.start((Reader)new BufferedReader(new InputStreamReader(in)));
        ArrayList<SurveyorActionDescription> actions = new ArrayList<SurveyorActionDescription>();
        while (parser.hasNext()) {
            Object object = parser.next();
            if (object instanceof SurveyorComponent) {
                surveyorComponent = (SurveyorComponent)object;
                continue;
            }
            if (object instanceof ButtonDescription) {
                ((ButtonDescription)object).setActions(actions);
                surveyorComponent.addButton((ButtonDescription)object);
                actions = new ArrayList();
                continue;
            }
            if (object instanceof SurveyorActionDescription) {
                actions.add((SurveyorActionDescription)object);
                continue;
            }
            System.err.println("surveyor: unknown xml element: " + object);
        }
        return surveyorComponent;
    }
}

