/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IElevationModel;
import org.openstreetmap.josm.plugins.elevation.IElevationModelListener;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.ElevationModel;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfileLayer;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationProfilePanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ElevationProfileDialog
extends ToggleDialog
implements MapView.LayerChangeListener,
ComponentListener {
    private static final String EMPTY_DATA_STRING = "-";
    private static final long serialVersionUID = -868463893732535577L;
    private IElevationModel model;
    private GpxLayer activeLayer = null;
    private final HashMap<GpxLayer, ElevationModel> layerMap = new HashMap();
    private final ElevationProfilePanel profPanel;
    private final JLabel minHeightLabel;
    private final JLabel maxHeightLabel;
    private final JLabel avrgHeightLabel;
    private final JLabel elevationGainLabel;
    private final JLabel totalTimeLabel;
    private final JLabel distLabel;
    private final JComboBox trackCombo;
    private final JButton zoomButton;
    private final List<IElevationModelListener> listeners = new ArrayList<IElevationModelListener>();
    private ElevationProfileLayer profileLayer;

    public ElevationProfileDialog() {
        this(I18n.tr((String)"Elevation Profile", (Object[])new Object[0]), "elevation", I18n.tr((String)"Open the elevation profile window.", (Object[])new Object[0]), null, 200, true);
    }

    public ElevationProfileDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        this(name, iconName, tooltip, shortcut, preferredHeight, false);
    }

    public ElevationProfileDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow) {
        super(name, iconName, tooltip, shortcut, preferredHeight, defShow);
        this.model = new ElevationModel();
        JPanel rootPanel = new JPanel();
        GridLayout gridLayout1 = new GridLayout(2, 1);
        rootPanel.setLayout(gridLayout1);
        JPanel statPanel = new JPanel();
        GridLayout gridLayoutStat = new GridLayout(2, 6);
        statPanel.setLayout(gridLayoutStat);
        String[] labels = new String[]{I18n.tr((String)"Min", (Object[])new Object[0]), I18n.tr((String)"Avrg", (Object[])new Object[0]), I18n.tr((String)"Max", (Object[])new Object[0]), I18n.tr((String)"Dist", (Object[])new Object[0]), I18n.tr((String)"Gain", (Object[])new Object[0]), I18n.tr((String)"Time", (Object[])new Object[0])};
        for (int i = 0; i < labels.length; ++i) {
            JLabel lbl = new JLabel(labels[i]);
            lbl.setFont(this.getFont().deriveFont(1));
            statPanel.add(lbl);
        }
        this.minHeightLabel = new JLabel("0 m");
        statPanel.add(this.minHeightLabel);
        this.avrgHeightLabel = new JLabel("0 m");
        statPanel.add(this.avrgHeightLabel);
        this.maxHeightLabel = new JLabel("0 m");
        statPanel.add(this.maxHeightLabel);
        this.distLabel = new JLabel("0 km");
        statPanel.add(this.distLabel);
        this.elevationGainLabel = new JLabel("0 m");
        statPanel.add(this.elevationGainLabel);
        this.totalTimeLabel = new JLabel("0");
        statPanel.add(this.totalTimeLabel);
        JPanel trackPanel = new JPanel();
        FlowLayout fl = new FlowLayout(0);
        trackPanel.setLayout(fl);
        JLabel lbTrack = new JLabel(I18n.tr((String)"Tracks", (Object[])new Object[0]));
        lbTrack.setFont(this.getFont().deriveFont(1));
        trackPanel.add(lbTrack);
        this.zoomButton = new JButton(I18n.tr((String)"Zoom", (Object[])new Object[0]));
        this.zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IElevationProfile profile;
                if (ElevationProfileDialog.this.model != null && (profile = ElevationProfileDialog.this.model.getCurrentProfile()) != null) {
                    Main.map.mapView.zoomTo(profile.getBounds());
                }
            }
        });
        this.zoomButton.setEnabled(false);
        this.trackCombo = new JComboBox(new TrackModel());
        this.trackCombo.setPreferredSize(new Dimension(200, 24));
        this.trackCombo.setEnabled(false);
        trackPanel.add(this.trackCombo);
        trackPanel.add(this.zoomButton);
        rootPanel.add(statPanel);
        rootPanel.add(trackPanel);
        this.add(rootPanel, "Last");
        this.profPanel = new ElevationProfilePanel(null);
        this.add(this.profPanel, "Center");
        this.profPanel.addComponentListener(this);
        this.dock();
    }

    public void showNotify() {
        Layer layer;
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        if (Main.isDisplayingMapView() && (layer = Main.map.mapView.getActiveLayer()) instanceof GpxLayer) {
            this.setActiveLayer((GpxLayer)layer);
        }
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public IElevationModel getModel() {
        return this.model;
    }

    public void setModel(IElevationModel model) {
        if (this.model != model) {
            this.model = model;
            this.profPanel.setElevationModel(model);
            this.updateView();
        }
    }

    public ElevationProfileLayer getProfileLayer() {
        return this.profileLayer;
    }

    public void setProfileLayer(ElevationProfileLayer profileLayer) {
        if (this.profileLayer != profileLayer) {
            if (this.profileLayer != null) {
                this.profPanel.removeSelectionListener(this.profileLayer);
            }
            this.profileLayer = profileLayer;
            this.profPanel.addSelectionListener(this.profileLayer);
        }
    }

    private void updateView() {
        if (this.model == null) {
            this.disableView();
            return;
        }
        IElevationProfile profile = this.model.getCurrentProfile();
        if (profile != null) {
            this.setTitle(String.format("%s: %s", I18n.tr((String)"Elevation Profile", (Object[])new Object[0]), profile.getName()));
            if (profile.hasElevationData()) {
                this.minHeightLabel.setText(ElevationHelper.getElevationText(profile.getMinHeight()));
                this.maxHeightLabel.setText(ElevationHelper.getElevationText(profile.getMaxHeight()));
                this.avrgHeightLabel.setText(ElevationHelper.getElevationText(profile.getAverageHeight()));
                this.elevationGainLabel.setText(ElevationHelper.getElevationText(profile.getGain()));
            }
            long diff = profile.getTimeDifference();
            long minutes = diff / 60000L;
            long hours = minutes / 60L;
            double dist = profile.getDistance();
            this.totalTimeLabel.setText(String.format("%d:%02d h", hours, minutes %= 60L));
            this.distLabel.setText(NavigatableComponent.getSystemOfMeasurement().getDistText(dist));
            this.trackCombo.setEnabled(this.model.profileCount() > 1);
            this.trackCombo.setModel(new TrackModel());
            this.zoomButton.setEnabled(true);
        } else {
            this.disableView();
        }
        this.fireModelChanged();
        this.repaint();
    }

    private void disableView() {
        this.setTitle(String.format("%s: (No data)", I18n.tr((String)"Elevation Profile", (Object[])new Object[0])));
        this.minHeightLabel.setText(EMPTY_DATA_STRING);
        this.maxHeightLabel.setText(EMPTY_DATA_STRING);
        this.avrgHeightLabel.setText(EMPTY_DATA_STRING);
        this.elevationGainLabel.setText(EMPTY_DATA_STRING);
        this.totalTimeLabel.setText(EMPTY_DATA_STRING);
        this.distLabel.setText(EMPTY_DATA_STRING);
        this.trackCombo.setEnabled(false);
        this.zoomButton.setEnabled(false);
    }

    protected void fireModelChanged() {
        for (IElevationModelListener listener : this.listeners) {
            listener.elevationProfileChanged(this.getModel().getCurrentProfile());
        }
    }

    public void addModelListener(IElevationModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IElevationModelListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof GpxLayer) {
            this.setActiveLayer((GpxLayer)newLayer);
        }
    }

    private void setActiveLayer(GpxLayer newLayer) {
        if (this.activeLayer != newLayer) {
            this.activeLayer = newLayer;
            if (!this.layerMap.containsKey(newLayer)) {
                GpxData gpxData = newLayer.data;
                ElevationModel newEM = new ElevationModel(newLayer.getName(), gpxData);
                this.layerMap.put(newLayer, newEM);
            }
            ElevationModel em = this.layerMap.get(newLayer);
            this.setModel(em);
        }
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof GpxLayer) {
            GpxLayer gpxLayer = (GpxLayer)newLayer;
            this.setActiveLayer(gpxLayer);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (this.layerMap.containsKey(oldLayer)) {
            this.layerMap.remove(oldLayer);
        }
        if (this.layerMap.size() == 0) {
            this.setModel(null);
            if (this.profileLayer != null) {
                this.profileLayer.setProfile(null);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    class TrackModel
    implements ComboBoxModel {
        private Collection<ListDataListener> listeners;

        TrackModel() {
        }

        @Override
        public void addListDataListener(ListDataListener arg0) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ListDataListener>();
            }
            this.listeners.add(arg0);
        }

        @Override
        public IElevationProfile getElementAt(int index) {
            if (ElevationProfileDialog.this.model == null) {
                return null;
            }
            IElevationProfile ep = ElevationProfileDialog.this.model.getProfiles().get(index);
            return ep;
        }

        @Override
        public int getSize() {
            if (ElevationProfileDialog.this.model == null) {
                return 0;
            }
            return ElevationProfileDialog.this.model.profileCount();
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        @Override
        public Object getSelectedItem() {
            if (ElevationProfileDialog.this.model == null) {
                return null;
            }
            return ElevationProfileDialog.this.model.getCurrentProfile();
        }

        @Override
        public void setSelectedItem(Object selectedObject) {
            if (ElevationProfileDialog.this.model != null && selectedObject instanceof IElevationProfile) {
                ElevationProfileDialog.this.model.setCurrentProfile((IElevationProfile)selectedObject);
                ElevationProfileDialog.this.profileLayer.setProfile(ElevationProfileDialog.this.model.getCurrentProfile());
                ElevationProfileDialog.this.repaint();
            }
        }
    }
}

