/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import public_transport.TransText;
import public_transport.WaypointTableModel;

public class WaypointsNameCommand
extends Command {
    private int workingLine = 0;
    private WaypointTableModel waypointTM = null;
    private String oldName = null;
    private String name = null;
    private String oldShelter = null;
    private TransText shelter;

    public WaypointsNameCommand(WaypointTableModel waypointTM, int workingLine, String name, TransText shelter) {
        this.waypointTM = waypointTM;
        this.workingLine = workingLine;
        if (waypointTM.nodes.elementAt(workingLine) != null) {
            this.oldName = waypointTM.nodes.elementAt(workingLine).get("name");
            this.oldShelter = waypointTM.nodes.elementAt(workingLine).get("shelter");
        }
        this.name = name;
        this.shelter = shelter;
    }

    public boolean executeCommand() {
        if (this.waypointTM.nodes.elementAt(this.workingLine) != null) {
            this.waypointTM.nodes.elementAt(this.workingLine).put("name", this.name);
            this.waypointTM.nodes.elementAt(this.workingLine).put("shelter", this.shelter.text);
        }
        this.waypointTM.inEvent = true;
        if (this.name == null) {
            this.waypointTM.setValueAt("", this.workingLine, 1);
        } else {
            this.waypointTM.setValueAt(this.name, this.workingLine, 1);
        }
        this.waypointTM.setValueAt(this.shelter, this.workingLine, 2);
        this.waypointTM.inEvent = false;
        return true;
    }

    public void undoCommand() {
        if (this.waypointTM.nodes.elementAt(this.workingLine) != null) {
            this.waypointTM.nodes.elementAt(this.workingLine).put("name", this.oldName);
            this.waypointTM.nodes.elementAt(this.workingLine).put("shelter", this.oldShelter);
        }
        this.waypointTM.inEvent = true;
        if (this.oldName == null) {
            this.waypointTM.setValueAt("", this.workingLine, 1);
        } else {
            this.waypointTM.setValueAt(this.oldName, this.workingLine, 1);
        }
        this.waypointTM.setValueAt(new TransText(this.oldShelter), this.workingLine, 2);
        this.waypointTM.inEvent = false;
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Edit waypoint name", (Object[])new Object[0]);
    }
}

