/*
 * Decompiled with CFR 0.152.
 */
package CommandLine;

import CommandLine.Relay;
import CommandLine.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class Parameter {
    public boolean required = false;
    public Type type;
    public String name;
    public String description;
    private Object value = "";
    private ArrayList<OsmPrimitive> valueList = new ArrayList();
    protected float maxVal = 0.0f;
    protected float minVal = 0.0f;
    protected int maxInstances = 1;

    public String getValue() {
        String out = "";
        switch (this.type) {
            case POINT: {
                out = (String)this.value;
                break;
            }
            case LENGTH: {
                out = String.valueOf(this.value);
                break;
            }
            case NATURAL: {
                out = String.valueOf(this.value);
                break;
            }
            case STRING: {
                out = String.valueOf(this.value);
                break;
            }
            case RELAY: {
                out = String.valueOf(((Relay)this.value).getValue());
                break;
            }
            case NODE: {
                out = String.valueOf(this.valueList.size()) + " " + I18n.tr((String)"nodes", (Object[])new Object[0]);
                break;
            }
            case WAY: {
                out = String.valueOf(this.valueList.size()) + " " + I18n.tr((String)"ways", (Object[])new Object[0]);
                break;
            }
            case RELATION: {
                out = String.valueOf(this.valueList.size()) + " " + I18n.tr((String)"relations", (Object[])new Object[0]);
                break;
            }
            case ANY: {
                out = String.valueOf(this.valueList.size()) + " " + I18n.tr((String)"OSM objects", (Object[])new Object[0]);
                break;
            }
            case USERNAME: {
                out = String.valueOf(this.value);
                break;
            }
            case IMAGERYURL: {
                out = String.valueOf(this.value);
                break;
            }
            case IMAGERYOFFSET: {
                out = String.valueOf(this.value);
            }
        }
        return out;
    }

    public Object getRawValue() {
        return this.value;
    }

    public ArrayList<OsmPrimitive> getValueList() {
        return this.valueList;
    }

    public void setValue(Object obj) {
        if (this.type == Type.RELAY && obj instanceof String && this.value instanceof Relay) {
            ((Relay)this.value).setValue((String)obj);
        } else {
            this.value = obj;
        }
    }

    public Collection<OsmPrimitive> getParameterObjects() {
        ArrayList<OsmPrimitive> pObjects = new ArrayList<OsmPrimitive>();
        if (this.isOsm()) {
            if (this.maxInstances == 1) {
                pObjects.add((OsmPrimitive)this.value);
            } else {
                return this.valueList;
            }
        }
        return pObjects;
    }

    public boolean isOsm() {
        return this.type == Type.NODE || this.type == Type.WAY || this.type == Type.RELATION || this.type == Type.ANY;
    }
}

