/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParserJavacc;
import com.google.gson.ParseException;
import com.google.gson.TokenMgrError;
import java.io.EOFException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonParserJavacc parser;
    private final Object lock;
    private JsonElement nextElement;

    public JsonStreamParser(String json) {
        this(new StringReader(json));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonParserJavacc(reader);
        this.lock = new Object();
        this.nextElement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement next() throws JsonParseException {
        Object object = this.lock;
        synchronized (object) {
            if (this.nextElement != null) {
                JsonElement returnValue = this.nextElement;
                this.nextElement = null;
                return returnValue;
            }
        }
        try {
            return this.parser.parse();
        }
        catch (TokenMgrError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (ParseException e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
        catch (JsonParseException e) {
            if (e.getCause() instanceof EOFException) {
                throw new NoSuchElementException();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.nextElement = this.next();
                return true;
            }
            catch (NoSuchElementException e) {
                this.nextElement = null;
                return false;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

