/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.widgets.HistoryChangedListener;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.api.CloseAction;
import org.openstreetmap.josm.plugins.osb.api.EditAction;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.dialogs.TextInputDialog;
import org.openstreetmap.josm.tools.I18n;

public class CloseIssueAction
extends OsbAction {
    private static final long serialVersionUID = 1L;
    private CloseAction closeAction = new CloseAction();
    private EditAction commentAction = new EditAction();
    private String comment;
    private Node node;

    public CloseIssueAction(OsbDialog dialog) {
        super(I18n.tr((String)"Mark as done", (Object[])new Object[0]), dialog);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) throws Exception {
        LinkedList<String> history = new LinkedList<String>(Main.pref.getCollection("osb.comment.history", new LinkedList()));
        HistoryChangedListener l = new HistoryChangedListener(){

            public void historyChanged(List<String> history) {
                Main.pref.putCollection("osb.comment.history", history);
            }
        };
        this.node = this.dialog.getSelectedNode();
        this.comment = TextInputDialog.showDialog((JComponent)Main.map, I18n.tr((String)"Really close?", (Object[])new Object[0]), I18n.tr((String)"<html>Really mark this issue as ''done''?<br><br>You may add an optional comment:</html>", (Object[])new Object[0]), OsbPlugin.loadIcon("icon_valid22.png"), history, l);
        if (this.comment == null) {
            this.canceled = true;
        }
    }

    @Override
    public void execute() throws IOException {
        this.comment = this.addMesgInfo(this.comment);
        this.commentAction.execute(this.node, this.comment);
        this.closeAction.execute(this.node);
    }

    public String toString() {
        return I18n.tr((String)("Close: " + this.node.get("note") + " - Comment: " + this.comment), (Object[])new Object[0]);
    }

    @Override
    public CloseIssueAction clone() {
        CloseIssueAction action = new CloseIssueAction(this.dialog);
        action.canceled = this.canceled;
        action.comment = this.comment;
        action.node = this.node;
        return action;
    }
}

