/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.multitagger;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class MultiTaggerTableModel
extends AbstractTableModel
implements SelectionChangedListener {
    ArrayList<OsmPrimitive> list = new ArrayList(50);
    String[] mainTags = new String[0];
    boolean[] isSpecialTag = new boolean[0];

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.mainTags.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.isSpecialTag[columnIndex]) {
            return this.list.get(rowIndex).get(this.mainTags[columnIndex]);
        }
        String var = this.mainTags[columnIndex];
        OsmPrimitive p = this.list.get(rowIndex);
        if (var.equals("id")) {
            return String.valueOf(p.getUniqueId());
        }
        if (var.equals("type")) {
            return OsmPrimitiveType.from((IPrimitive)p).toString().substring(0, 1);
        }
        if (var.equals("area")) {
            if (p.getType() == OsmPrimitiveType.CLOSEDWAY) {
                return String.format("%.1f", Geometry.closedWayArea((Way)((Way)p)));
            }
            return I18n.tr((String)"not closed", (Object[])new Object[0]);
        }
        if (var.equals("length") && p instanceof Way) {
            return String.format("%.1f", ((Way)p).getLength());
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        Main.info((String)("new selection: n=" + newSelection.size()));
        this.list.clear();
        this.list.addAll(newSelection);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.isSpecialTag[columnIndex];
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String key;
        if (this.isSpecialTag[columnIndex]) {
            return;
        }
        if (columnIndex >= this.getColumnCount() || rowIndex >= this.getRowCount()) {
            return;
        }
        String val = ((String)value).trim();
        OsmPrimitive sel = this.list.get(rowIndex);
        String newValue = sel.get(key = this.mainTags[columnIndex]);
        if (newValue == null) {
            newValue = "";
        }
        if (!val.equals(newValue)) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand(sel, key, (String)value));
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.mainTags[column];
    }

    public OsmPrimitive getPrimitiveAt(int number) {
        if (number < 0 || number >= this.list.size()) {
            return null;
        }
        return this.list.get(number);
    }

    public void setupColumnsFromText(String txt) {
        String[] tags = txt.trim().split("[\\s,]+");
        this.mainTags = new String[tags.length];
        this.isSpecialTag = new boolean[tags.length];
        int i = 0;
        for (String t : tags) {
            if (t.startsWith("${") && t.endsWith("}")) {
                this.mainTags[i] = t.substring(2, t.length() - 1).trim();
                this.isSpecialTag[i] = true;
            } else {
                this.mainTags[i] = t;
                this.isSpecialTag[i] = false;
            }
            ++i;
        }
    }

    public String getSearchExpression() {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (int i = 0; i < this.mainTags.length; ++i) {
            if (this.isSpecialTag[i]) continue;
            if (notFirst) {
                sb.append(" | ");
            }
            sb.append("\"");
            sb.append(this.mainTags[i]);
            sb.append("\":");
            notFirst = true;
        }
        return sb.toString();
    }
}

