/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.multitagger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.plugins.utilsplugin2.multitagger.MultiTaggerTableModel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MultiTagDialog
extends ExtendedDialog
implements SelectionChangedListener {
    private final MultiTaggerTableModel tableModel = new MultiTaggerTableModel();
    private final JTable tbl = new JTable(this.tableModel);
    private final HighlightHelper highlightHelper = new HighlightHelper();
    private final HistoryComboBox tagSetSelector = new HistoryComboBox();
    private static final String HISTORY_KEY = "utilsplugin2.multitaghistory";
    String[] defaultHistory = new String[]{"addr:street, addr:housenumber, building", "highway, name, ${id}, ${length}, ${type}", "name name:en name:ru name:de"};
    private final StringProperty LAST_TAGS = new StringProperty("utilsplugin2.multitag.last", this.defaultHistory[0]);
    TagCellEditor cellEditor;
    private final MouseAdapter tableMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                AutoScaleAction.zoomTo(Collections.singletonList(MultiTagDialog.this.getSelectedPrimitive()));
            }
        }
    };
    private final ListSelectionListener selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            OsmPrimitive p = MultiTagDialog.this.getSelectedPrimitive();
            if (p != null && Main.isDisplayingMapView() && MultiTagDialog.this.highlightHelper.highlightOnly(p)) {
                Main.map.mapView.repaint();
            }
        }
    };
    private final TagSetChanger tagSetChanger = new TagSetChanger();

    public MultiTagDialog() {
        super(Main.parent, I18n.tr((String)"Edit tags", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, false);
        JPanel pnl = new JPanel(new GridBagLayout());
        this.tbl.setFillsViewportHeight(true);
        this.tbl.setSelectionMode(0);
        this.tbl.addMouseListener(this.tableMouseAdapter);
        this.tbl.setRowSelectionAllowed(true);
        this.tbl.setColumnSelectionAllowed(true);
        this.tbl.setSelectionMode(1);
        this.loadHistory();
        this.tagSetSelector.addItemListener((ItemListener)this.tagSetChanger);
        this.tagSetSelector.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, true), "applyTagSet");
        this.tagSetSelector.getActionMap().put("applyTagSet", this.tagSetChanger);
        this.tagSetChanger.itemStateChanged(null);
        pnl.add((Component)this.tagSetSelector, GBC.std().fill(2));
        pnl.add((Component)new JButton(new DeleteFromHistoryAction()), GBC.std());
        pnl.add((Component)new JButton(new FindMatchingAction()), GBC.eol());
        pnl.add((Component)this.tbl.getTableHeader(), GBC.eop().fill(2));
        pnl.add((Component)new JScrollPane(this.tbl), GBC.eol().fill(1));
        this.tbl.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tbl.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.setContent(pnl);
        this.setDefaultButton(-1);
        WindowGeometry defaultGeometry = WindowGeometry.centerInWindow((Component)Main.parent, (Dimension)new Dimension(500, 500));
        this.setRememberWindowGeometry(((Object)((Object)this)).getClass().getName() + ".geometry", defaultGeometry);
    }

    private void loadHistory() {
        LinkedList cmtHistory = new LinkedList(Main.pref.getCollection(HISTORY_KEY, Arrays.asList(this.defaultHistory)));
        Collections.reverse(cmtHistory);
        this.tagSetSelector.setPossibleItems(cmtHistory);
        this.tagSetSelector.setText(this.LAST_TAGS.get());
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        this.highlightHelper.clear();
        this.tbl.getSelectionModel().removeListSelectionListener(this.selectionListener);
        super.buttonAction(buttonIndex, evt);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.tableModel.selectionChanged(newSelection);
    }

    private OsmPrimitive getSelectedPrimitive() {
        int idx = this.tbl.getSelectedRow();
        if (idx >= 0) {
            return this.tableModel.getPrimitiveAt(this.tbl.convertRowIndexToModel(idx));
        }
        return null;
    }

    public void setAutoCompletion(boolean enable) {
        if (!enable) {
            // empty if block
        }
        OsmDataLayer l = Main.main.getEditLayer();
        AutoCompletionManager autocomplete = l.data.getAutoCompletionManager();
        AutoCompletionList acList = new AutoCompletionList();
    }

    private void initAutocompletion() {
        OsmDataLayer l = Main.main.getEditLayer();
        AutoCompletionManager autocomplete = l.data.getAutoCompletionManager();
        for (int i = 0; i < this.tableModel.mainTags.length; ++i) {
            if (this.tableModel.isSpecialTag[i]) continue;
            AutoCompletingTextField tf = new AutoCompletingTextField();
            AutoCompletionList acList = new AutoCompletionList();
            autocomplete.populateWithTagValues(acList, this.tableModel.mainTags[i]);
            tf.setAutoCompletionList(acList);
            this.tbl.getColumnModel().getColumn(i).setCellEditor((TableCellEditor)tf);
        }
    }

    private class TagSetChanger
    extends AbstractAction
    implements ItemListener {
        String oldTags;

        private TagSetChanger() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (MultiTagDialog.this.tagSetSelector.getSelectedIndex() < 0) {
                return;
            }
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = MultiTagDialog.this.tagSetSelector.getText();
            if (s == null || s.isEmpty() || s.equals(this.oldTags)) {
                return;
            }
            this.oldTags = s;
            Main.info((String)("Multitagger tags=" + s));
            MultiTagDialog.this.tagSetSelector.addCurrentItemToHistory();
            Main.pref.putCollection(MultiTagDialog.HISTORY_KEY, (Collection)MultiTagDialog.this.tagSetSelector.getHistory());
            MultiTagDialog.this.LAST_TAGS.put(MultiTagDialog.this.tagSetSelector.getText());
            MultiTagDialog.this.tableModel.setupColumnsFromText(s);
            MultiTagDialog.this.tbl.createDefaultColumnsFromModel();
            MultiTagDialog.this.tbl.setAutoCreateRowSorter(true);
            for (int i = 0; i < MultiTagDialog.this.tableModel.getColumnCount(); ++i) {
                TableHelper.adjustColumnWidth((JTable)MultiTagDialog.this.tbl, (int)i, (int)100);
            }
            MultiTagDialog.this.initAutocompletion();
            MultiTagDialog.this.tableModel.fireTableDataChanged();
        }
    }

    private class FindMatchingAction
    extends AbstractAction {
        public FindMatchingAction() {
            super("", ImageProvider.get((String)"dialogs", (String)"search"));
            this.putValue("ShortDescription", I18n.tr((String)"Find primitives with these tags", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchAction.search((String)MultiTagDialog.this.tableModel.getSearchExpression(), (SearchAction.SearchMode)SearchAction.SearchMode.replace);
        }
    }

    private class DeleteFromHistoryAction
    extends AbstractAction {
        public DeleteFromHistoryAction() {
            super("", ImageProvider.get((String)"dialogs", (String)"delete"));
            this.putValue("ShortDescription", I18n.tr((String)"Delete from history", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String txt = MultiTagDialog.this.tagSetSelector.getText();
            System.out.println(txt);
            List<String> history = MultiTagDialog.this.tagSetSelector.getHistory();
            history.remove(txt);
            if (history.isEmpty()) {
                history = Arrays.asList(MultiTagDialog.this.defaultHistory);
            }
            Main.pref.putCollection(MultiTagDialog.HISTORY_KEY, (Collection)history);
            if (!history.isEmpty()) {
                MultiTagDialog.this.LAST_TAGS.put(history.get(0));
            }
            MultiTagDialog.this.loadHistory();
        }
    }
}

