/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoUtils;
import org.openstreetmap.josm.plugins.pointinfo.addrPlaces;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

class ruianRecord {
    private double m_coor_lat;
    private double m_coor_lon;
    private String m_source;
    private long m_objekt_ruian_id;
    private int m_objekt_podlazi;
    private int m_objekt_byty;
    private String m_objekt_zpusob_vyuziti;
    private String m_objekt_zpusob_vyuziti_key;
    private String m_objekt_zpusob_vyuziti_val;
    private String m_objekt_dokonceni;
    private String m_objekt_plati_od;
    private ArrayList<addrPlaces> m_adresni_mista;
    private long m_parcela_ruian_id;
    private String m_parcela_druh_pozemku;
    private String m_parcela_zpusob_vyuziti;
    private String m_parcela_plati_od;
    private long m_ulice_ruian_id;
    private String m_ulice_jmeno;
    private long m_katastr_ruian_id;
    private String m_katastr_nazev;
    private String m_katastr_obec;
    private String m_katastr_okres;
    private String m_katastr_kraj;

    public ruianRecord() {
        this.init();
    }

    private void init() {
        this.m_coor_lat = 0.0;
        this.m_coor_lon = 0.0;
        this.m_source = "";
        this.m_objekt_ruian_id = 0L;
        this.m_objekt_podlazi = 0;
        this.m_objekt_byty = 0;
        this.m_objekt_zpusob_vyuziti = "";
        this.m_objekt_zpusob_vyuziti_key = "";
        this.m_objekt_zpusob_vyuziti_val = "";
        this.m_objekt_dokonceni = "";
        this.m_objekt_plati_od = "";
        this.m_adresni_mista = new ArrayList();
        this.m_parcela_ruian_id = 0L;
        this.m_parcela_druh_pozemku = "";
        this.m_parcela_zpusob_vyuziti = "";
        this.m_parcela_plati_od = "";
        this.m_ulice_ruian_id = 0L;
        this.m_ulice_jmeno = "";
        this.m_katastr_ruian_id = 0L;
        this.m_katastr_nazev = "";
        this.m_katastr_obec = "";
        this.m_katastr_okres = "";
        this.m_katastr_kraj = "";
    }

    public void parseJSON(String jsonStr) {
        this.init();
        try {
            JSONObject obj = new JSONObject(jsonStr);
            try {
                this.m_coor_lat = obj.getJSONObject("coordinates").getDouble("lat");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.m_coor_lon = obj.getJSONObject("coordinates").getDouble("lon");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.m_source = obj.getString("source");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                JSONObject stavebniObjekt = obj.getJSONObject("stavebni_objekt");
                try {
                    this.m_objekt_ruian_id = stavebniObjekt.getLong("ruian_id");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_podlazi = stavebniObjekt.getInt("pocet_podlazi");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_byty = stavebniObjekt.getInt("pocet_bytu");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_zpusob_vyuziti = stavebniObjekt.getString("zpusob_vyuziti");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_zpusob_vyuziti_key = stavebniObjekt.getString("zpusob_vyuziti_key");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_zpusob_vyuziti_val = stavebniObjekt.getString("zpusob_vyuziti_val");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_plati_od = stavebniObjekt.getString("plati_od");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_objekt_dokonceni = stavebniObjekt.getString("dokonceni");
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                JSONArray arr = obj.getJSONArray("adresni_mista");
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject adresniMisto = arr.getJSONObject(i);
                    addrPlaces am = new addrPlaces();
                    try {
                        am.setRuianID(adresniMisto.getLong("ruian_id"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        JSONArray node = adresniMisto.getJSONArray("pozice");
                        am.setPosition(new LatLon(LatLon.roundToOsmPrecisionStrict((double)node.getDouble(1)), LatLon.roundToOsmPrecisionStrict((double)node.getDouble(0))));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setBudovaID(adresniMisto.getLong("budova_kod"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setCisloTyp(adresniMisto.getString("cislo_typ"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setCisloDomovni(adresniMisto.getString("cislo_domovni"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setCisloOrientacni(adresniMisto.getString("cislo_orientacni"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setUlice(adresniMisto.getString("ulice"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setCastObce(adresniMisto.getString("cast_obce"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setMestskaCast(adresniMisto.getString("mestska_cast"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setObec(adresniMisto.getString("obec"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setOkres(adresniMisto.getString("okres"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setKraj(adresniMisto.getString("kraj"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        am.setPsc(adresniMisto.getString("psc"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_adresni_mista.add(am);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                JSONObject parcela = obj.getJSONObject("parcela");
                try {
                    this.m_parcela_ruian_id = parcela.getLong("ruian_id");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_parcela_druh_pozemku = parcela.getString("druh_pozemku");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_parcela_zpusob_vyuziti = parcela.getString("zpusob_vyuziti");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_parcela_plati_od = parcela.getString("plati_od");
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                JSONObject ulice = obj.getJSONObject("ulice");
                try {
                    this.m_ulice_ruian_id = ulice.getLong("ruian_id");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_ulice_jmeno = ulice.getString("jmeno");
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                JSONObject katastr = obj.getJSONObject("katastr");
                try {
                    this.m_katastr_ruian_id = katastr.getLong("ruian_id");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_katastr_nazev = katastr.getString("nazev");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_katastr_obec = katastr.getString("obec");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_katastr_okres = katastr.getString("okres");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.m_katastr_kraj = katastr.getString("kraj");
                }
                catch (Exception e) {
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHtml() {
        StringBuilder r = new StringBuilder();
        if (this.m_objekt_ruian_id == 0L && this.m_parcela_ruian_id == 0L && this.m_adresni_mista.size() == 0 && this.m_ulice_ruian_id == 0L && this.m_katastr_ruian_id == 0L) {
            return "";
        }
        r.append("<html>");
        r.append("<br/>");
        if (this.m_objekt_ruian_id > 0L) {
            int i;
            r.append("<i><u>Informace o objektu</u></i>");
            r.append("&nbsp;&nbsp;<a href=file://tags.copy/building><img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Vlo\u017eit tagy do schr\u00e1nky\" ></a><br/>");
            r.append("<b>RUIAN id: </b><a href=http://vdp.cuzk.cz/vdp/ruian/stavebniobjekty/" + this.m_objekt_ruian_id + ">" + this.m_objekt_ruian_id + "</a><br/>");
            if (this.m_adresni_mista.size() == 0) {
                r.append("<b>Budova: </b> bez \u010d.p./\u010d.e<br/>");
            } else if (this.m_adresni_mista.get(0).getCisloTyp().equals("\u010c\u00edslo popisn\u00e9")) {
                r.append("<b>Budova: </b>s \u010d\u00edslem popisn\u00fdm<br/>");
            } else {
                r.append("<b>Budova: </b>s \u010d\u00edslem eviden\u010dn\u00edm<br/>");
            }
            if (this.m_objekt_podlazi > 0) {
                r.append("<b>Po\u010det podla\u017e\u00ed: </b>" + this.m_objekt_podlazi + "<br/>");
            }
            if (this.m_objekt_byty > 0) {
                r.append("<b>Po\u010det byt\u016f: </b>" + this.m_objekt_byty + "<br/>");
            }
            r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>" + this.m_objekt_zpusob_vyuziti + "<br/>");
            r.append("<b>Datum dokon\u010den\u00ed: </b>" + this.m_objekt_dokonceni + "<br/>");
            r.append("<b>Plat\u00ed od: </b>" + this.m_objekt_plati_od + "<br/>");
            r.append("<br/>");
            if (this.m_adresni_mista.size() > 1) {
                r.append("<i><u>Informace o adrese</u></i><br/>");
                i = 0;
                r.append("<b>" + this.m_adresni_mista.get(i).getCisloTyp() + "</b> (v\u00edce adres)<b>: </b>" + this.m_adresni_mista.get(i).getCisloDomovni() + "<br/>");
                r.append("<b>\u010c\u00e1st obce: </b>" + this.m_adresni_mista.get(i).getCastObce() + "<br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast() + "<br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec() + "<br/>");
                r.append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres() + "<br/>");
                r.append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj() + "<br/>");
            } else if (this.m_adresni_mista.size() == 1 && (this.m_adresni_mista.get(0).getCisloDomovni() == null || this.m_adresni_mista.get(0).getCisloDomovni().isEmpty())) {
                i = 0;
                r.append("<i><u>Informace o adrese</u></i><br/>");
                r.append("<b>Budova: </b>" + this.m_adresni_mista.get(i).getCisloTyp() + "<br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast() + "<br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec() + "<br/>");
                r.append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres() + "<br/>");
                r.append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj() + "<br/>");
            } else if (this.m_adresni_mista.size() == 1) {
                i = 0;
                String x = "";
                String x_name = "";
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    x = "/" + this.m_adresni_mista.get(i).getCisloOrientacni();
                    x_name = "/orienta\u010dn\u00ed";
                }
                r.append("<i><u>Informace o adrese</u></i><br/>");
                r.append("<b>RUIAN id: </b><a href=http://vdp.cuzk.cz/vdp/ruian/adresnimista/" + this.m_adresni_mista.get(i).getRuianID() + ">" + this.m_adresni_mista.get(i).getRuianID() + "</a><br/>");
                r.append("<b>" + this.m_adresni_mista.get(i).getCisloTyp() + x_name + ": </b>" + this.m_adresni_mista.get(i).getCisloDomovni() + x);
                r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Vlo\u017eit tagy do schr\u00e1nky\"></a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod\"></a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod na pozici dle RUIAN\"></a>");
                r.append("<br/>");
                if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                    r.append("<b>Ulice: </b>" + this.m_adresni_mista.get(i).getUlice() + "<br/>");
                }
                r.append("<b>\u010c\u00e1st obce: </b>" + this.m_adresni_mista.get(i).getCastObce() + "<br/>");
                if (this.m_adresni_mista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>" + this.m_adresni_mista.get(i).getMestskaCast() + "<br/>");
                }
                r.append("<b>Obec: </b>" + this.m_adresni_mista.get(i).getObec() + "<br/>");
                r.append("<b>Okres: </b>" + this.m_adresni_mista.get(i).getOkres() + "<br/>");
                r.append("<b>Kraj: </b>" + this.m_adresni_mista.get(i).getKraj() + "<br/>");
                r.append("<b>PS\u010c: </b>" + this.m_adresni_mista.get(i).getPsc() + "<br/>");
            }
            r.append("<br/>");
        }
        if (this.m_adresni_mista.size() > 1 && this.m_objekt_ruian_id > 0L) {
            String x = "";
            if (this.m_adresni_mista.get(0).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                x = "ev.";
            }
            r.append("<i><u>Adresn\u00ed m\u00edsta</u></i><br/>");
            for (int i = 0; i < this.m_adresni_mista.size(); ++i) {
                r.append("<a href=http://vdp.cuzk.cz/vdp/ruian/adresnimista/" + this.m_adresni_mista.get(i).getRuianID() + ">");
                r.append(this.m_adresni_mista.get(i).getRuianID() + "</a> ");
                r.append(this.m_adresni_mista.get(i).getUlice() + " " + x + this.m_adresni_mista.get(i).getCisloDomovni());
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    r.append("/" + this.m_adresni_mista.get(i).getCisloOrientacni());
                }
                r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Vlo\u017eit tagy do schr\u00e1nky\"></a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod\"></a>");
                r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod na pozici dle RUIAN\"></a>");
                r.append("<br/>");
            }
            r.append("<br/>");
        }
        if (this.m_parcela_ruian_id > 0L) {
            r.append("<i><u>Informace o pozemku</u></i>");
            r.append("<br/>");
            r.append("<b>RUIAN id: </b><a href=http://vdp.cuzk.cz/vdp/ruian/parcely/" + this.m_parcela_ruian_id + ">" + this.m_parcela_ruian_id + "</a><br/>");
            r.append("<b>Druh pozemku: </b>" + this.m_parcela_druh_pozemku + "<br/>");
            if (this.m_parcela_zpusob_vyuziti != "") {
                r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>" + this.m_parcela_zpusob_vyuziti + "<br/>");
            }
            r.append("<b>Plat\u00ed od: </b>" + this.m_parcela_plati_od + "<br/>");
            r.append("<br/>");
        }
        if (this.m_ulice_ruian_id > 0L) {
            r.append("<i><u>Informace o ulici</u></i>");
            r.append("&nbsp;&nbsp;<a href=file://tags.copy/street><img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Vlo\u017eit tagy do schr\u00e1nky\"></a><br/>");
            r.append("<b>RUIAN id: </b><a href=http://vdp.cuzk.cz/vdp/ruian/ulice/" + this.m_ulice_ruian_id + ">" + this.m_ulice_ruian_id + "</a><br/>");
            r.append("<b>Jm\u00e9no: </b>" + this.m_ulice_jmeno + "<br/>");
            r.append("<br/>");
        }
        if (this.m_katastr_ruian_id > 0L) {
            r.append("<b>Katastr\u00e1ln\u00ed \u00fazem\u00ed: </b>" + this.m_katastr_nazev + "<br/>");
            r.append("<b>Obec: </b>" + this.m_katastr_obec + "<br/>");
            r.append("<b>Okres: </b>" + this.m_katastr_okres + "<br/>");
            r.append("<b>Kraj: </b>" + this.m_katastr_kraj + "<br/>");
            r.append("<br/>");
        }
        if (this.m_adresni_mista.size() > 0 && this.m_objekt_ruian_id == 0L) {
            r.append("<i><u>Adresn\u00ed m\u00edsta v okol\u00ed</u></i><br/>");
            for (int i = 0; i < this.m_adresni_mista.size(); ++i) {
                String x = "";
                String x_name = "";
                if (this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                    x = "ev.";
                }
                x = x + this.m_adresni_mista.get(i).getCisloDomovni();
                if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                    x = x + "/" + this.m_adresni_mista.get(i).getCisloOrientacni();
                    x_name = x_name + "/orienta\u010dn\u00ed";
                }
                r.append("<a href=http://vdp.cuzk.cz/vdp/ruian/adresnimista/" + this.m_adresni_mista.get(i).getRuianID() + ">");
                if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                    r.append(this.m_adresni_mista.get(i).getUlice() + " " + x + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Vlo\u017eit tagy do schr\u00e1nky\"></a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod\"></a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod na pozici dle RUIAN\"></a>");
                    r.append("<br/>" + this.m_adresni_mista.get(i).getObec());
                } else {
                    r.append(this.m_adresni_mista.get(i).getCastObce() + " " + x + "</a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.copy/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Vlo\u017eit tagy do schr\u00e1nky\"></a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod\"></a>");
                    r.append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:" + i + "><img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod na pozici dle RUIAN\"></a>");
                    if (!this.m_adresni_mista.get(i).getCastObce().equals(this.m_adresni_mista.get(i).getObec())) {
                        r.append("<br/>" + this.m_adresni_mista.get(i).getObec());
                    }
                }
                r.append("<br/>");
            }
        }
        r.append("<hr/>");
        r.append("<center><i><small>Zdroj: <a href=\"http://www.ruian.cz/\">" + this.m_source + "</a></small></i></center>");
        r.append("</html>");
        return r.toString();
    }

    String tagToString(String k, String v) {
        String r = "\"" + k + "\"=\"" + v + "\"\n";
        return r;
    }

    String getKeys(String keyType) {
        StringBuilder c = new StringBuilder();
        if (keyType.equals("building") && this.m_objekt_ruian_id > 0L) {
            c.append(this.tagToString("ref:ruian:building", Long.toString(this.m_objekt_ruian_id)));
            if (this.m_objekt_zpusob_vyuziti_key.length() > 0 && this.m_objekt_zpusob_vyuziti_val.length() > 0) {
                c.append(this.tagToString(this.m_objekt_zpusob_vyuziti_key, this.m_objekt_zpusob_vyuziti_val));
            }
            if (this.m_objekt_podlazi > 0) {
                c.append(this.tagToString("building:levels", Integer.toString(this.m_objekt_podlazi)));
            }
            if (this.m_objekt_byty > 0) {
                c.append(this.tagToString("building:flats", Integer.toString(this.m_objekt_byty)));
            }
            if (this.m_objekt_dokonceni.length() > 0) {
                c.append(this.tagToString("start_date", this.m_objekt_dokonceni));
            }
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        if (keyType.startsWith("address") && this.m_adresni_mista.size() > 0) {
            int i;
            if (this.m_adresni_mista.size() == 0) {
                i = 0;
            } else {
                String[] key = keyType.split(":");
                i = new Integer(key[1]);
                System.out.println("Address ID: " + i);
            }
            if (!this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                c.append(this.tagToString("addr:conscriptionnumber", this.m_adresni_mista.get(i).getCisloDomovni()));
            } else {
                c.append(this.tagToString("addr:provisionalnumber", this.m_adresni_mista.get(i).getCisloDomovni()));
            }
            if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                c.append(this.tagToString("addr:streetnumber", this.m_adresni_mista.get(i).getCisloOrientacni()));
            }
            StringBuilder addr = new StringBuilder();
            if (!this.m_adresni_mista.get(i).getCisloTyp().equals("\u010c\u00edslo eviden\u010dn\u00ed")) {
                addr.append(this.m_adresni_mista.get(i).getCisloDomovni());
            } else {
                addr.append("ev." + this.m_adresni_mista.get(i).getCisloDomovni());
            }
            if (!this.m_adresni_mista.get(i).getCisloOrientacni().isEmpty()) {
                addr.append("/" + this.m_adresni_mista.get(i).getCisloOrientacni());
            }
            c.append(this.tagToString("addr:housenumber", addr.toString()));
            if (!this.m_adresni_mista.get(i).getUlice().isEmpty()) {
                c.append(this.tagToString("addr:street", this.m_adresni_mista.get(i).getUlice()));
            }
            if (this.m_adresni_mista.get(i).getRuianID() > 0L) {
                c.append(this.tagToString("ref:ruian:addr", Long.toString(this.m_adresni_mista.get(i).getRuianID())));
            }
            if (!this.m_adresni_mista.get(i).getCastObce().isEmpty()) {
                c.append(this.tagToString("addr:place", this.m_adresni_mista.get(i).getCastObce()));
            }
            if (!this.m_adresni_mista.get(i).getMestskaCast().isEmpty()) {
                c.append(this.tagToString("addr:suburb", this.m_adresni_mista.get(i).getMestskaCast()));
            }
            if (!this.m_adresni_mista.get(i).getObec().isEmpty()) {
                c.append(this.tagToString("addr:city", this.m_adresni_mista.get(i).getObec()));
            }
            if (!this.m_adresni_mista.get(i).getPsc().isEmpty()) {
                c.append(this.tagToString("addr:postcode", this.m_adresni_mista.get(i).getPsc()));
            }
            c.append(this.tagToString("addr:country", "CZ"));
            c.append(this.tagToString("source:addr", "cuzk:ruian"));
        }
        if (keyType.equals("street") && this.m_ulice_ruian_id > 0L) {
            c.append(this.tagToString("ref:ruian:street", Long.toString(this.m_ulice_ruian_id)));
            c.append(this.tagToString("name", this.m_ulice_jmeno));
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        return c.toString();
    }

    void createAddrPoint(String cmd, String t) {
        Node node;
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        if (cmd.startsWith("tags.create-on-place")) {
            String[] key = cmd.split(":");
            int i = new Integer(key[1]);
            node = new Node(this.m_adresni_mista.get(i).getPosition());
        } else {
            node = new Node(new LatLon(this.m_coor_lat, this.m_coor_lon));
        }
        commands.add(new AddCommand((OsmPrimitive)node));
        LinkedList<Node> coll = new LinkedList<Node>();
        coll.add(node);
        TagCollection tc = new TagCollection();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(t.split("\n")));
        for (String line : list) {
            String[] tag = line.split("\"=\"");
            System.out.println("<" + tag[0] + ">. <" + tag[1] + ">");
            tc.add(new Tag(tag[0].substring(1), tag[1].substring(0, tag[1].length() - 1)));
        }
        tc.applyTo(coll);
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Add new address point", (Object[])new Object[0]), commands));
    }

    public void performAction(String act) {
        System.out.println("act: " + act.substring(7));
        String[] params = act.substring(7).split("/");
        if (!params[0].equals("tags.copy") && !params[0].startsWith("tags.create")) {
            return;
        }
        String task = this.getKeys(params[1]);
        if (params[0].equals("tags.copy") && task.length() > 0) {
            Utils.copyToClipboard((String)task);
            PointInfoUtils.showNotification(I18n.tr((String)"Tags copied to clipboard.", (Object[])new Object[0]), "info");
        }
        if (params[0].startsWith("tags.create") && task.length() > 0) {
            this.createAddrPoint(act.substring(7), task);
            PointInfoUtils.showNotification(I18n.tr((String)"New address point added.", (Object[])new Object[0]), "info");
        }
    }
}

