/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(83), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(84), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    private transient int longitudeAxis;
    private transient int latitudeAxis;
    private transient int heightAxis;
    private transient UnitConverter longitudeConverter;
    private transient UnitConverter latitudeConverter;
    private transient UnitConverter heightConverter;

    public DefaultEllipsoidalCS(EllipsoidalCS cs) {
        super((CoordinateSystem)cs);
    }

    public DefaultEllipsoidalCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(name, new CoordinateSystemAxis[]{axis0, axis1});
    }

    public DefaultEllipsoidalCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(name, new CoordinateSystemAxis[]{axis0, axis1, axis2});
    }

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, new CoordinateSystemAxis[]{axis0, axis1});
    }

    public DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, new CoordinateSystemAxis[]{axis0, axis1, axis2});
    }

    private DefaultEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis[] axis) {
        super(properties, axis);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.NORTH.equals((Object)(direction = direction.absolute())) || AxisDirection.EAST.equals((Object)direction) || AxisDirection.UP.equals((Object)direction);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection direction, Unit<?> unit) {
        Unit expected = AxisDirection.UP.equals((Object)(direction = direction.absolute())) ? SI.METER : NonSI.DEGREE_ANGLE;
        return expected.isCompatible(unit);
    }

    private void update() {
        int i = this.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = this.getAxis(i);
            AxisDirection direction = axis.getDirection().absolute();
            Unit unit = axis.getUnit();
            if (AxisDirection.EAST.equals((Object)direction)) {
                this.longitudeAxis = i;
                this.longitudeConverter = unit.getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.NORTH.equals((Object)direction)) {
                this.latitudeAxis = i;
                this.latitudeConverter = unit.getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.UP.equals((Object)direction)) {
                this.heightAxis = i;
                this.heightConverter = unit.getConverterTo(SI.METER);
                continue;
            }
            throw new AssertionError(direction);
        }
    }

    public double getLongitude(double[] coordinates) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", coordinates);
        if (this.longitudeConverter == null) {
            this.update();
        }
        return this.longitudeConverter.convert(coordinates[this.longitudeAxis]);
    }

    public double getLatitude(double[] coordinates) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", coordinates);
        if (this.latitudeConverter == null) {
            this.update();
        }
        return this.latitudeConverter.convert(coordinates[this.latitudeAxis]);
    }

    public double getHeight(double[] coordinates) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coordinates", coordinates);
        if (this.heightConverter == null) {
            this.update();
            if (this.heightConverter == null) {
                throw new IllegalStateException(Errors.format((int)126));
            }
        }
        return this.heightConverter.convert(coordinates[this.heightAxis]);
    }

    public DefaultEllipsoidalCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] axis = this.axisUsingUnit(unit);
        if (axis == null) {
            return this;
        }
        return new DefaultEllipsoidalCS(DefaultEllipsoidalCS.getProperties(this, null), axis);
    }
}

