/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;

public class BoundsVisitor
implements FeatureCalc {
    ReferencedEnvelope bounds = new ReferencedEnvelope();

    public void visit(Feature feature) {
        this.bounds.include(feature.getBounds());
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public void reset(Envelope bounds) {
        this.bounds = new ReferencedEnvelope();
    }

    @Override
    public CalcResult getResult() {
        if (this.bounds == null || this.bounds.isEmpty()) {
            return CalcResult.NULL_RESULT;
        }
        return new BoundsResult(this.bounds);
    }

    public static class BoundsResult
    extends AbstractCalcResult {
        private ReferencedEnvelope bbox;

        public BoundsResult(ReferencedEnvelope bbox) {
            this.bbox = bbox;
        }

        public ReferencedEnvelope getValue() {
            return new ReferencedEnvelope(this.bbox);
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof BoundsResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof BoundsResult) {
                BoundsResult boundsToAdd = (BoundsResult)resultsToAdd;
                ReferencedEnvelope newBounds = new ReferencedEnvelope(this.bbox);
                newBounds.include(boundsToAdd.getValue());
                return new BoundsResult(newBounds);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

