/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.MultiValuedFilter;

public abstract class GeometryFilterImpl
extends BinaryComparisonAbstract
implements GeometryFilter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    protected MultiValuedFilter.MatchAction matchAction;

    protected GeometryFilterImpl(FilterFactory factory, MultiValuedFilter.MatchAction matchAction) {
        super(factory);
        this.matchAction = matchAction;
    }

    protected GeometryFilterImpl(FilterFactory factory, org.opengis.filter.expression.Expression e1, org.opengis.filter.expression.Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(factory, e1, e2);
        this.matchAction = matchAction;
    }

    protected GeometryFilterImpl(FilterFactory factory) {
        this(factory, MultiValuedFilter.MatchAction.ANY);
    }

    protected GeometryFilterImpl(FilterFactory factory, org.opengis.filter.expression.Expression e1, org.opengis.filter.expression.Expression e2) {
        this(factory, e1, e2, MultiValuedFilter.MatchAction.ANY);
    }

    protected GeometryFilterImpl(short filterType) throws IllegalFilterException {
        super(CommonFactoryFinder.getFilterFactory(null));
        if (!GeometryFilterImpl.isGeometryFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create geometry filter with non-geometry type.");
        }
        this.filterType = filterType;
    }

    @Override
    public final void addLeftGeometry(Expression leftGeometry) throws IllegalFilterException {
        this.setExpression1(leftGeometry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setExpression1(org.opengis.filter.expression.Expression expression) {
        if (expression instanceof Expression) {
            Expression leftGeometry = (Expression)expression;
            if (!DefaultExpression.isGeometryExpression(leftGeometry.getType()) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add (left) non-geometry expression to geometry filter.");
            super.setExpression1(leftGeometry);
            return;
        } else {
            super.setExpression1(expression);
        }
    }

    @Override
    public final void addRightGeometry(Expression rightGeometry) throws IllegalFilterException {
        this.setExpression2(rightGeometry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setExpression2(org.opengis.filter.expression.Expression expression) {
        if (expression instanceof Expression) {
            Expression rightGeometry = (Expression)expression;
            if (!DefaultExpression.isGeometryExpression(rightGeometry.getType()) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add (right) non-geometryexpression to geometry filter.");
            super.setExpression2(rightGeometry);
            return;
        } else {
            super.setExpression2(expression);
        }
    }

    @Override
    public final Expression getLeftGeometry() {
        return (Expression)this.getExpression1();
    }

    @Override
    public final Expression getRightGeometry() {
        return (Expression)this.getExpression2();
    }

    protected Geometry getLeftGeometry(Object feature) {
        org.opengis.filter.expression.Expression leftGeometry = this.getExpression1();
        if (leftGeometry != null) {
            Object obj = leftGeometry.evaluate(feature, Geometry.class);
            return (Geometry)obj;
        }
        if (feature instanceof SimpleFeature) {
            return (Geometry)((SimpleFeature)feature).getDefaultGeometry();
        }
        return null;
    }

    protected Geometry getRightGeometry(Object feature) {
        org.opengis.filter.expression.Expression rightGeometry = this.getExpression2();
        if (rightGeometry != null) {
            return (Geometry)rightGeometry.evaluate(feature, Geometry.class);
        }
        if (feature instanceof SimpleFeature) {
            return (Geometry)((SimpleFeature)feature).getDefaultGeometry();
        }
        return null;
    }

    protected static Object getGeometries(org.opengis.filter.expression.Expression expr, Object feature) {
        Object o = expr.evaluate(feature);
        if (o instanceof Collection) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            for (Object item : (Collection)o) {
                Geometry geometry = Converters.convert(item, Geometry.class);
                if (geometry == null) continue;
                list.add(geometry);
            }
            return list.size() > 0 ? list : null;
        }
        return Converters.convert(o, Geometry.class);
    }

    @Override
    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public String toString() {
        String operator = null;
        if (this.filterType == 5) {
            operator = " equals ";
        } else if (this.filterType == 6) {
            operator = " disjoint ";
        } else if (this.filterType == 7) {
            operator = " intersects ";
        } else if (this.filterType == 8) {
            operator = " touches ";
        } else if (this.filterType == 9) {
            operator = " crosses ";
        } else if (this.filterType == 10) {
            operator = " within ";
        } else if (this.filterType == 11) {
            operator = " contains ";
        } else if (this.filterType == 12) {
            operator = " overlaps ";
        } else if (this.filterType == 13) {
            operator = " beyond ";
        } else if (this.filterType == 4) {
            operator = " bbox ";
        }
        org.opengis.filter.expression.Expression leftGeometry = this.getExpression1();
        org.opengis.filter.expression.Expression rightGeometry = this.getExpression2();
        if (this.expression1 == null && rightGeometry == null) {
            return "[ null" + operator + "null" + " ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator + rightGeometry.toString() + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator + "null" + " ]";
        }
        return "[ " + leftGeometry.toString() + operator + rightGeometry.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryFilterImpl) {
            GeometryFilterImpl geomFilter = (GeometryFilterImpl)obj;
            boolean isEqual = true;
            boolean bl = isEqual = geomFilter.getFilterType() == this.filterType;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("filter type match:" + isEqual + "; in:" + geomFilter.getFilterType() + "; out:" + this.filterType);
            }
            boolean bl2 = geomFilter.expression1 != null ? isEqual && geomFilter.expression1.equals(this.expression1) : (isEqual = isEqual && this.expression1 == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("left geom match:" + isEqual + "; in:" + geomFilter.expression1 + "; out:" + this.expression1);
            }
            boolean bl3 = geomFilter.expression2 != null ? isEqual && geomFilter.expression2.equals(this.expression2) : (isEqual = isEqual && this.expression2 == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("right geom match:" + isEqual + "; in:" + geomFilter.expression2 + "; out:" + this.expression2);
            }
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        org.opengis.filter.expression.Expression leftGeometry = this.getExpression1();
        org.opengis.filter.expression.Expression rightGeometry = this.getExpression2();
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + (leftGeometry == null ? 0 : leftGeometry.hashCode());
        result = 37 * result + (rightGeometry == null ? 0 : rightGeometry.hashCode());
        return result;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    public final boolean evaluate(Object feature) {
        Object object1 = GeometryFilterImpl.getGeometries(this.getExpression1(), feature);
        Object object2 = GeometryFilterImpl.getGeometries(this.getExpression2(), feature);
        if (object1 == null || object2 == null) {
            return false;
        }
        if (!(object1 instanceof Collection) && !(object2 instanceof Collection)) {
            return this.evaluateInternal((Geometry)object1, (Geometry)object2);
        }
        List<Geometry> leftValues = object1 instanceof Collection ? (List<Geometry>)object1 : Collections.singletonList((Geometry)object1);
        List<Geometry> rightValues = object2 instanceof Collection ? (List<Geometry>)object2 : Collections.singletonList((Geometry)object2);
        int count = 0;
        for (Geometry leftValue : leftValues) {
            for (Geometry rightValue : rightValues) {
                boolean temp = this.evaluateInternal(leftValue, rightValue);
                if (temp) {
                    ++count;
                }
                switch (this.matchAction) {
                    case ONE: {
                        if (count <= 1) break;
                        return false;
                    }
                    case ALL: {
                        if (temp) break;
                        return false;
                    }
                    case ANY: {
                        if (!temp) break;
                        return true;
                    }
                }
            }
        }
        switch (this.matchAction) {
            case ONE: {
                return count == 1;
            }
            case ALL: {
                return true;
            }
            case ANY: {
                return false;
            }
        }
        return false;
    }

    protected abstract boolean evaluateInternal(Geometry var1, Geometry var2);
}

